/*
 * Decompiled with CFR 0.152.
 */
package radixcore.modules.net;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import radixcore.modules.net.AbstractPacket;
import radixcore.modules.net.QueuedPacket;

public abstract class AbstractPacketHandler {
    private List<QueuedPacket> serverQueuedPackets;
    private List<QueuedPacket> clientQueuedPackets;
    protected SimpleNetworkWrapper wrapper;
    private int idCounter;

    public AbstractPacketHandler(String modId) {
        this.wrapper = NetworkRegistry.INSTANCE.newSimpleChannel(modId);
        this.registerPackets();
        this.clientQueuedPackets = new ArrayList<QueuedPacket>();
        this.serverQueuedPackets = new ArrayList<QueuedPacket>();
    }

    public abstract void registerPackets();

    protected final void registerPacket(Class packetClass, Side processorSide) {
        try {
            Method setPacketHandler = packetClass.getMethod("setPacketHandler", AbstractPacketHandler.class);
            setPacketHandler.invoke(null, this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.wrapper.registerMessage(packetClass, packetClass, this.idCounter, processorSide);
        ++this.idCounter;
    }

    public final void sendPacketToAllPlayers(IMessage packet) {
        this.wrapper.sendToAll(packet);
    }

    public final void sendPacketToAllPlayersExcept(IMessage packet, EntityPlayerMP player) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        PlayerList playerList = server.func_184103_al();
        for (int index = 0; index < playerList.func_72394_k(); ++index) {
            EntityPlayerMP playerInList = (EntityPlayerMP)playerList.func_181057_v().get(index);
            if (playerInList.func_70005_c_().equals(player.func_70005_c_())) continue;
            this.wrapper.sendTo(packet, playerInList);
        }
    }

    public final void sendPacketToPlayer(IMessage packet, EntityPlayer player) {
        if (player != null) {
            this.wrapper.sendTo(packet, (EntityPlayerMP)player);
        }
    }

    public final void sendPacketToAllAround(IMessage packet, NetworkRegistry.TargetPoint point) {
        this.wrapper.sendToAllAround(packet, point);
    }

    public final void sendPacketToDimension(IMessage packet, int dimensionId) {
        this.wrapper.sendToDimension(packet, dimensionId);
    }

    public final void sendPacketToServer(IMessage packet) {
        this.wrapper.sendToServer(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processPackets(Side side) {
        List<QueuedPacket> queuedPackets;
        List<QueuedPacket> list = queuedPackets = side.isClient() ? this.clientQueuedPackets : this.serverQueuedPackets;
        synchronized (list) {
            while (!queuedPackets.isEmpty()) {
                QueuedPacket queuedObject = queuedPackets.get(0);
                AbstractPacket packet = queuedObject.getPacket();
                packet.processOnGameThread((IMessage)queuedObject.getMessage(), queuedObject.getContext());
                queuedPackets.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPacketForProcessing(Side side, AbstractPacket packet, MessageContext context) {
        List<QueuedPacket> queuedPackets;
        Side currentSide = context.side;
        List<QueuedPacket> list = queuedPackets = currentSide.isClient() ? this.clientQueuedPackets : this.serverQueuedPackets;
        synchronized (list) {
            queuedPackets.add(new QueuedPacket(packet, packet, context));
        }
    }
}

