/*
 * Decompiled with CFR 0.152.
 */
package radixcore.packets;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import radixcore.modules.RadixNettyIO;
import radixcore.modules.datawatcher.DataWatcherEx;
import radixcore.modules.datawatcher.IWatchable;
import radixcore.modules.datawatcher.WatchedObjectEx;
import radixcore.modules.net.AbstractPacket;

public class PacketDataSync
extends AbstractPacket<PacketDataSync> {
    private int entityId;
    private Map dataWatcherData;

    public PacketDataSync() {
    }

    public PacketDataSync(int entityId, DataWatcherEx dataWatcherEx) {
        this.entityId = entityId;
        this.dataWatcherData = dataWatcherEx.getWatchedDataMap();
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.entityId = byteBuf.readInt();
        this.dataWatcherData = (Map)RadixNettyIO.readObject(byteBuf);
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.entityId);
        RadixNettyIO.writeObject(byteBuf, this.dataWatcherData);
    }

    @Override
    public void processOnGameThread(PacketDataSync message, MessageContext context) {
        PacketDataSync packet = message;
        IWatchable entity = (IWatchable)this.getPlayerClient().field_70170_p.func_73045_a(packet.entityId);
        DataWatcherEx dataWatcherEx = entity.getDataWatcherEx();
        for (Object obj : packet.dataWatcherData.values()) {
            WatchedObjectEx recvObject = (WatchedObjectEx)obj;
            WatchedObjectEx currentObject = dataWatcherEx.getWatchedObject(recvObject.getDataValueId());
            currentObject.setObject(recvObject.getObject());
        }
    }
}

