/*
 * Decompiled with CFR 0.152.
 */
package radixcore.packets;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import radixcore.core.RadixCore;
import radixcore.modules.net.AbstractPacket;

public class PacketTest
extends AbstractPacket<PacketTest> {
    private Type type;

    public PacketTest() {
    }

    public PacketTest(Type type) {
        this.type = type;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = Type.byId(buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type.id);
    }

    @Override
    public void processOnGameThread(PacketTest packet, MessageContext context) {
        RadixCore.getLogger().info("Recieved packet: " + (Object)((Object)packet.type));
        switch (packet.type) {
            case REQ: {
                packetHandler.sendPacketToServer(new PacketTest(Type.SYN));
                break;
            }
            case SYN: {
                packetHandler.sendPacketToPlayer(new PacketTest(Type.SYNACK), this.getPlayer(context));
                break;
            }
            case SYNACK: {
                packetHandler.sendPacketToServer(new PacketTest(Type.ACK));
                break;
            }
        }
    }

    public static enum Type {
        REQ(1),
        SYN(2),
        SYNACK(3),
        ACK(4);

        int id;

        private Type(int id) {
            this.id = id;
        }

        static Type byId(int id) {
            for (Type type : Type.values()) {
                if (type.id != id) continue;
                return type;
            }
            return null;
        }
    }
}

