/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.Provisional;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.tree.BINDelta;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INLogContext;
import com.sleepycat.je.tree.INLogItem;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.utilint.TinyHashSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BIN
extends IN
implements Loggable {
    private static final String BEGIN_TAG = "<bin>";
    private static final String END_TAG = "</bin>";
    private TinyHashSet<CursorImpl> cursorSet = new TinyHashSet();
    private long lastDeltaVersion = -1L;
    private int numDeltasSinceLastFull = 0;
    private boolean prohibitNextDelta = false;

    public BIN() {
    }

    public BIN(DatabaseImpl db, byte[] identifierKey, int maxEntriesPerNode, int level) {
        super(db, identifierKey, maxEntriesPerNode, level);
    }

    public BINReference createReference() {
        return new BINReference(this.getNodeId(), this.getDatabase().getId(), this.getIdentifierKey());
    }

    @Override
    protected IN createNewInstance(byte[] identifierKey, int maxEntries, int level) {
        return new BIN(this.getDatabase(), identifierKey, maxEntries, level);
    }

    @Override
    boolean isAlwaysLatchedExclusively() {
        return true;
    }

    @Override
    public byte[] getChildKey(IN child) throws DatabaseException {
        return child.getDupKey();
    }

    LogEntryType getBINDeltaType() {
        return LogEntryType.LOG_BIN_DELTA;
    }

    public long getLastDeltaVersion() {
        return this.lastDeltaVersion;
    }

    @Override
    public void setProhibitNextDelta() {
        this.prohibitNextDelta = true;
    }

    @Override
    protected void descendOnParentSearch(SearchResult result, boolean targetContainsDuplicates, boolean targetIsRoot, long targetNodeId, Node child, boolean requireExactMatch) throws DatabaseException {
        if (child.canBeAncestor(targetContainsDuplicates)) {
            if (targetContainsDuplicates && targetIsRoot) {
                long childNid = child.getNodeId();
                ((IN)child).releaseLatch();
                result.keepSearching = false;
                result.exactParentFound = childNid == targetNodeId;
                if (requireExactMatch && !result.exactParentFound) {
                    result.parent = null;
                    this.releaseLatch();
                } else {
                    result.parent = this;
                }
            } else {
                this.releaseLatch();
                result.parent = (IN)child;
            }
        } else {
            result.exactParentFound = false;
            result.keepSearching = false;
            if (!requireExactMatch && targetContainsDuplicates) {
                result.parent = this;
            } else {
                this.releaseLatch();
                result.parent = null;
            }
        }
    }

    @Override
    protected boolean canBeAncestor(boolean targetContainsDuplicates) {
        return targetContainsDuplicates;
    }

    @Override
    boolean isEvictionProhibited() {
        return this.nCursors() > 0;
    }

    @Override
    boolean hasPinnedChildren() {
        DatabaseImpl db = this.getDatabase();
        if (db.getId().equals(DbTree.ID_DB_ID)) {
            return this.hasResidentChildren();
        }
        if (!db.getSortedDuplicates()) {
            return false;
        }
        for (int i = 0; i < this.getNEntries(); ++i) {
            Node node = this.getTarget(i);
            if (node == null || node instanceof LN) continue;
            return true;
        }
        return false;
    }

    @Override
    int getChildEvictionType() {
        Cleaner cleaner = this.getDatabase().getDbEnvironment().getCleaner();
        for (int i = 0; i < this.getNEntries(); ++i) {
            Node node = this.getTarget(i);
            if (node == null) continue;
            if (node instanceof LN) {
                LN ln = (LN)node;
                if (!ln.isEvictableInexact()) {
                    return 0;
                }
                if (!cleaner.isEvictable(this, i)) continue;
                return 1;
            }
            return 0;
        }
        return 2;
    }

    @Override
    boolean entryZeroKeyComparesLow() {
        return false;
    }

    @Override
    public void setKnownDeleted(int index) {
        super.setKnownDeleted(index);
        LN oldLN = (LN)this.getTarget(index);
        this.updateMemorySize(oldLN, null);
        if (oldLN != null) {
            oldLN.releaseMemoryBudget();
        }
        this.setMigrate(index, false);
        super.setTarget(index, null);
        this.setDirty(true);
    }

    public void setKnownDeletedLeaveTarget(int index) {
        this.setMigrate(index, false);
        super.setKnownDeleted(index);
        this.setDirty(true);
    }

    @Override
    public void clearKnownDeleted(int index) {
        super.clearKnownDeleted(index);
        this.setDirty(true);
    }

    public static long computeOverhead(DbConfigManager configManager) throws DatabaseException {
        return (long)MemoryBudget.BIN_FIXED_OVERHEAD + IN.computeArraysOverhead(configManager);
    }

    @Override
    protected long getMemoryOverhead(MemoryBudget mb) {
        return mb.getBINOverhead();
    }

    @Override
    public long getTreeAdminMemorySize() {
        if (this.getDatabase().getId().equals(DbTree.ID_DB_ID)) {
            long treeAdminMem = 0L;
            for (int i = 0; i < this.getMaxEntries(); ++i) {
                Node n = this.getTarget(i);
                if (n == null) continue;
                MapLN mapLN = (MapLN)n;
                treeAdminMem += mapLN.getDatabase().getTreeAdminMemory();
            }
            return treeAdminMem;
        }
        return 0L;
    }

    public Set<CursorImpl> getCursorSet() {
        return this.cursorSet.copy();
    }

    public void addCursor(CursorImpl cursor) {
        assert (this.isLatchOwnerForWrite());
        this.cursorSet.add(cursor);
    }

    public void removeCursor(CursorImpl cursor) {
        assert (this.isLatchOwnerForWrite());
        this.cursorSet.remove(cursor);
    }

    public int nCursors() {
        return this.cursorSet.size();
    }

    BIN getCursorBIN(CursorImpl cursor) {
        return cursor.getBIN();
    }

    BIN getCursorBINToBeRemoved(CursorImpl cursor) {
        return cursor.getBINToBeRemoved();
    }

    int getCursorIndex(CursorImpl cursor) {
        return cursor.getIndex();
    }

    void setCursorBIN(CursorImpl cursor, BIN bin) {
        cursor.setBIN(bin);
    }

    void setCursorIndex(CursorImpl cursor, int index) {
        cursor.setIndex(index);
    }

    @Override
    void splitSpecial(IN parent, int parentIndex, int maxEntriesPerNode, byte[] key, boolean leftSide, CacheMode cacheMode) throws DatabaseException {
        int index = this.findEntry(key, true, false);
        int nEntries = this.getNEntries();
        boolean exact = (index & 0x10000) != 0;
        if (leftSide && (index &= 0xFFFEFFFF) < 0) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, 1, cacheMode);
        } else if (!leftSide && !exact && index == nEntries - 1) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, nEntries - 1, cacheMode);
        } else {
            this.split(parent, parentIndex, maxEntriesPerNode, cacheMode);
        }
    }

    @Override
    void adjustCursors(IN newSibling, int newSiblingLow, int newSiblingHigh) {
        assert (newSibling.isLatchOwnerForWrite());
        assert (this.isLatchOwnerForWrite());
        int adjustmentDelta = newSiblingHigh - newSiblingLow;
        Iterator<CursorImpl> iter = this.cursorSet.iterator();
        while (iter.hasNext()) {
            CursorImpl cursor = iter.next();
            if (this.getCursorBINToBeRemoved(cursor) == this) continue;
            int cIdx = this.getCursorIndex(cursor);
            BIN cBin = this.getCursorBIN(cursor);
            assert (cBin == this) : "nodeId=" + this.getNodeId() + " cursor=" + cursor.dumpToString(true);
            assert (newSibling instanceof BIN);
            BIN ns = (BIN)newSibling;
            if (newSiblingLow == 0) {
                if (cIdx < newSiblingHigh) {
                    this.setCursorBIN(cursor, ns);
                    iter.remove();
                    ns.addCursor(cursor);
                    continue;
                }
                this.setCursorIndex(cursor, cIdx - adjustmentDelta);
                continue;
            }
            if (cIdx < newSiblingLow) continue;
            this.setCursorIndex(cursor, cIdx - newSiblingLow);
            this.setCursorBIN(cursor, ns);
            iter.remove();
            ns.addCursor(cursor);
        }
    }

    public void verifyCursors() {
        if (this.cursorSet != null) {
            Iterator<CursorImpl> iter = this.cursorSet.iterator();
            while (iter.hasNext()) {
                CursorImpl cursor = iter.next();
                if (this.getCursorBINToBeRemoved(cursor) == this) continue;
                BIN cBin = this.getCursorBIN(cursor);
                assert (cBin == this);
            }
        }
    }

    @Override
    void adjustCursorsForInsert(int insertIndex) {
        assert (this.isLatchOwnerForWrite());
        if (this.cursorSet != null) {
            Iterator<CursorImpl> iter = this.cursorSet.iterator();
            while (iter.hasNext()) {
                int cIdx;
                CursorImpl cursor = iter.next();
                if (this.getCursorBINToBeRemoved(cursor) == this || insertIndex > (cIdx = this.getCursorIndex(cursor))) continue;
                this.setCursorIndex(cursor, cIdx + 1);
            }
        }
    }

    void adjustCursorsForMutation(int binIndex, DBIN dupBin, int dupBinIndex, CursorImpl excludeCursor) {
        assert (this.isLatchOwnerForWrite());
        if (this.cursorSet != null) {
            Iterator<CursorImpl> iter = this.cursorSet.iterator();
            while (iter.hasNext()) {
                CursorImpl cursor = iter.next();
                if (this.getCursorBINToBeRemoved(cursor) == this || cursor == excludeCursor || cursor.getIndex() != binIndex) continue;
                assert (cursor.getDupBIN() == null);
                cursor.addCursor(dupBin);
                cursor.updateDBin(dupBin, dupBinIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compress(BINReference binRef, boolean canFetch, LocalUtilizationTracker localTracker) throws DatabaseException {
        boolean ret = false;
        boolean setNewIdKey = false;
        boolean anyLocksDenied = false;
        DatabaseImpl db = this.getDatabase();
        EnvironmentImpl envImpl = db.getDbEnvironment();
        BasicLocker lockingTxn = BasicLocker.createBasicLocker(envImpl);
        try {
            for (int i = 0; i < this.getNEntries(); ++i) {
                boolean entryIsIdentifierKey;
                boolean deleteEntry = false;
                Node n = null;
                if (binRef == null || this.isEntryPendingDeleted(i) || this.isEntryKnownDeleted(i) || binRef.hasDeletedKey(new Key(this.getKey(i)))) {
                    if (canFetch) {
                        n = db.isDeferredWriteMode() && this.getLsn(i) == -1L ? this.getTarget(i) : this.fetchTarget(i);
                    } else {
                        n = this.getTarget(i);
                        if (n == null) continue;
                    }
                    if (n == null) {
                        deleteEntry = true;
                    } else if (this.isEntryKnownDeleted(i)) {
                        LockResult lockRet = lockingTxn.nonBlockingLock(n.getNodeId(), LockType.READ, db);
                        if (lockRet.getLockGrant() == LockGrantType.DENIED) {
                            anyLocksDenied = true;
                            continue;
                        }
                        deleteEntry = true;
                    } else if (!n.containsDuplicates()) {
                        LN ln = (LN)n;
                        LockResult lockRet = lockingTxn.nonBlockingLock(ln.getNodeId(), LockType.READ, db);
                        if (lockRet.getLockGrant() == LockGrantType.DENIED) {
                            anyLocksDenied = true;
                            continue;
                        }
                        if (ln.isDeleted()) {
                            deleteEntry = true;
                        }
                    }
                    if (binRef != null) {
                        binRef.removeDeletedKey(new Key(this.getKey(i)));
                    }
                }
                if (!deleteEntry) continue;
                boolean bl = entryIsIdentifierKey = Key.compareKeys(this.getKey(i), this.getIdentifierKey(), this.getKeyComparator()) == 0;
                if (entryIsIdentifierKey) {
                    setNewIdKey = true;
                }
                if (db.isDeferredWriteMode() && n instanceof LN) {
                    LN ln = (LN)n;
                    long lsn = this.getLsn(i);
                    if (ln.isDirty() && lsn != -1L) {
                        if (db.isTemporary()) {
                            if (localTracker != null) {
                                localTracker.countObsoleteNode(lsn, ln.getLogType(), ln.getLastLoggedSize(), db);
                            }
                        } else {
                            this.logDirtyLN(i, ln, false);
                        }
                    }
                }
                boolean deleteSuccess = this.deleteEntry(i, true);
                assert (deleteSuccess);
                --i;
            }
        }
        finally {
            if (lockingTxn != null) {
                lockingTxn.operationEnd();
            }
        }
        if (anyLocksDenied && binRef != null) {
            db.getDbEnvironment().addToCompressorQueue(binRef, false);
            ret = true;
        }
        if (this.getNEntries() != 0 && setNewIdKey) {
            this.setIdentifierKey(this.getKey(0));
        }
        if (this.getNEntries() == 0) {
            this.setGeneration(0L);
        }
        return ret;
    }

    @Override
    public boolean isCompressible() {
        return true;
    }

    public long evictLNs() throws DatabaseException {
        assert (this.isLatchOwnerForWrite()) : "BIN must be latched before evicting LNs";
        Cleaner cleaner = this.getDatabase().getDbEnvironment().getCleaner();
        long removed = 0L;
        if (this.nCursors() == 0) {
            for (int i = 0; i < this.getNEntries(); ++i) {
                removed += this.evictInternal(i, cleaner);
            }
            this.updateMemorySize(removed, 0L);
        }
        return removed;
    }

    public void evictLN(int index) throws DatabaseException {
        Cleaner cleaner = this.getDatabase().getDbEnvironment().getCleaner();
        long removed = this.evictInternal(index, cleaner);
        this.updateMemorySize(removed, 0L);
    }

    private long evictInternal(int index, Cleaner cleaner) throws DatabaseException {
        LN ln;
        Node n = this.getTarget(index);
        if (n instanceof LN && (ln = (LN)n).isEvictable() && cleaner.isEvictable(this, index)) {
            boolean force = this.getDatabase().isDeferredWriteMode() && this.getLsn(index) == -1L;
            this.logDirtyLN(index, (LN)n, force);
            this.setTarget(index, null);
            ln.releaseMemoryBudget();
            return n.getMemorySizeIncludedByParent();
        }
        return 0L;
    }

    private void logDirtyLN(int index, LN ln, boolean force) throws DatabaseException {
        if (ln.isDirty() || force) {
            DatabaseImpl dbImpl = this.getDatabase();
            assert (dbImpl.isDeferredWriteMode());
            byte[] key = this.containsDuplicates() ? this.getDupKey() : this.getKey(index);
            long lsn = ln.log(dbImpl.getDbEnvironment(), dbImpl, key, this.getLsn(index), null, true, ReplicationContext.NO_REPLICATE);
            this.updateEntry(index, lsn);
        }
    }

    @Override
    boolean validateSubtreeBeforeDelete(int index) throws DatabaseException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isValidForDelete() throws DatabaseException {
        int validIndex = 0;
        int numValidEntries = 0;
        boolean needToLatch = !this.isLatchOwnerForWrite();
        try {
            int i;
            if (needToLatch) {
                this.latch();
            }
            for (i = 0; i < this.getNEntries(); ++i) {
                if (this.isEntryKnownDeleted(i)) continue;
                ++numValidEntries;
                validIndex = i;
            }
            if (numValidEntries > 1) {
                i = 0;
                return i != 0;
            }
            if (this.nCursors() > 0) {
                i = 0;
                return i != 0;
            }
            if (numValidEntries == 1) {
                Node child = this.fetchTarget(validIndex);
                if (child == null) {
                    boolean bl = false;
                    return bl;
                }
                child.latchShared();
                boolean ret = child.isValidForDelete();
                child.releaseLatch();
                boolean bl = ret;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (needToLatch && this.isLatchOwnerForWrite()) {
                this.releaseLatch();
            }
        }
    }

    @Override
    void accumulateStats(TreeWalkerStatsAccumulator acc) {
        acc.processBIN(this, this.getNodeId(), this.getLevel());
    }

    @Override
    public Comparator<byte[]> getKeyComparator() {
        return this.getDatabase().getBtreeComparator();
    }

    @Override
    public String beginTag() {
        return BEGIN_TAG;
    }

    @Override
    public String endTag() {
        return END_TAG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logDirtyChildren() throws DatabaseException {
        EnvironmentImpl envImpl = this.getDatabase().getDbEnvironment();
        for (int i = 0; i < this.getNEntries(); ++i) {
            Node node = this.getTarget(i);
            if (node == null) continue;
            if (node instanceof LN) {
                this.logDirtyLN(i, (LN)node, false);
                continue;
            }
            DIN din = (DIN)node;
            din.latch(CacheMode.UNCHANGED);
            try {
                if (!din.getDirty()) continue;
                din.logDirtyChildren();
                long childLsn = din.log(envImpl.getLogManager(), false, true, false, true, (IN)this);
                this.updateEntry(i, childLsn);
                continue;
            }
            finally {
                din.releaseLatch();
            }
        }
    }

    @Override
    public LogEntryType getLogType() {
        return LogEntryType.LOG_BIN;
    }

    @Override
    public String shortClassName() {
        return "BIN";
    }

    @Override
    public void beforeLog(LogManager logManager, INLogItem item, INLogContext context) throws DatabaseException {
        EnvironmentImpl envImpl = this.getDatabase().getDbEnvironment();
        envImpl.getCleaner().lazyMigrateLNs(this, context.proactiveMigration, context.backgroundIO);
        if (this.getDatabase().isDeferredWriteMode()) {
            this.logDirtyLNs(logManager);
        }
        boolean doDeltaLog = false;
        BINDelta deltaInfo = null;
        if (context.allowDeltas && this.getLastFullVersion() != -1L && !this.prohibitNextDelta && !this.getDatabase().isDeferredWriteMode()) {
            deltaInfo = new BINDelta(this);
            doDeltaLog = this.doDeltaLog(deltaInfo);
        }
        if (doDeltaLog) {
            item.provisional = Provisional.NO;
            item.oldLsn = -1L;
            item.entry = new SingleItemEntry(this.getBINDeltaType(), deltaInfo);
            item.isDelta = true;
        } else {
            super.beforeLog(logManager, item, context);
        }
    }

    @Override
    public void afterLog(LogManager logManager, INLogItem item, INLogContext context) throws DatabaseException {
        if (item.isDelta) {
            this.lastDeltaVersion = item.newLsn;
            item.newLsn = -1L;
            ++this.numDeltasSinceLastFull;
        } else {
            super.afterLog(logManager, item, context);
            this.lastDeltaVersion = -1L;
            this.numDeltasSinceLastFull = 0;
        }
        this.prohibitNextDelta = false;
    }

    private void logDirtyLNs(LogManager logManager) throws DatabaseException {
        boolean isDeferredWrite = this.getDatabase().isDeferredWriteMode();
        for (int i = 0; i < this.getNEntries(); ++i) {
            Node node = this.getTarget(i);
            if (node == null || !(node instanceof LN)) continue;
            this.logDirtyLN(i, (LN)node, this.getLsn(i) == -1L && isDeferredWrite);
        }
    }

    private boolean doDeltaLog(BINDelta deltaInfo) throws DatabaseException {
        int maxDiffs = this.getNEntries() * this.getDatabase().getBinDeltaPercent() / 100;
        return deltaInfo.getNumDeltas() <= maxDiffs && this.numDeltasSinceLastFull < this.getDatabase().getBinMaxDeltas();
    }
}

