/*
 * Decompiled with CFR 0.152.
 */
package mobac;

import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class StartMOBAC {
    public static final String MAIN_CLASS = "mobac.Main";
    public static String[] ARGS;

    public static void main(String[] args) {
        ARGS = args;
        StartMOBAC.setLookAndFeel();
        StartMOBAC.checkVersion();
        try {
            Class.forName(MAIN_CLASS).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Unable to start Mobile Atlas Creator: \n" + e.getMessage(), "Error", 0);
            System.exit(1);
        }
    }

    public static void setLookAndFeel() {
        try {
            if (System.getProperty("swing.defaultlaf") != null) {
                return;
            }
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void checkVersion() {
        String ver = System.getProperty("java.specification.version");
        if (ver == null) {
            ver = "Unknown";
        }
        String[] v = ver.split("\\.");
        int major = 0;
        int minor = 0;
        try {
            major = Integer.parseInt(v[0]);
            minor = Integer.parseInt(v[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int version = major * 1000 + minor;
        if (version < 1007) {
            JOptionPane.showMessageDialog(null, "The used Java Runtime Environment does not meet the minimum requirements.\n\nMobile Atlas Creator requires at least Java 7 (1.7) or higher.\nPlease update your Java Runtime before starting Mobile Atlas Creator.\n\nDetected Java Runtime Version: " + ver, "Java Runtime version problem detected", 0);
            System.exit(1);
        }
    }
}

