/*
 * Decompiled with CFR 0.152.
 */
package mobac.exceptions;

import mobac.utilities.Utilities;

public class MOBACOutOfMemoryException
extends RuntimeException {
    long requiredMemory;
    long heapAvailable;

    public MOBACOutOfMemoryException(long requiredMemory, String message) {
        super(message);
        Runtime r = Runtime.getRuntime();
        this.heapAvailable = r.maxMemory() - r.totalMemory() + r.freeMemory();
        this.requiredMemory = requiredMemory;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + "\nRequired memory: " + this.getFormattedRequiredMemory() + "\nAvailable free memory: " + Utilities.formatBytes(this.heapAvailable);
    }

    public long getRequiredMemory() {
        return this.requiredMemory;
    }

    public String getFormattedRequiredMemory() {
        return Utilities.formatBytes(this.requiredMemory);
    }
}

