/*
 * Decompiled with CFR 0.152.
 */
package mobac.externaltools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import mobac.externaltools.ExternalToolDef;
import mobac.externaltools.ToolParameters;
import mobac.program.DirectoryManager;
import mobac.utilities.GUIExceptionHandler;
import mobac.utilities.Utilities;
import mobac.utilities.file.FileExtFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ExternalToolsLoader {
    public static List<ExternalToolDef> tools = null;

    public static boolean load() {
        try {
            File dir2 = DirectoryManager.toolsDir;
            if (!dir2.isDirectory()) {
                return false;
            }
            File[] files = dir2.listFiles(new FileExtFilter(".xml"));
            tools = new LinkedList<ExternalToolDef>();
            for (File f : files) {
                tools.add(ExternalToolsLoader.loadFile(f));
            }
            return true;
        }
        catch (Exception e) {
            GUIExceptionHandler.showExceptionDialog("Failed to load external tools definition", e);
            return false;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ExternalToolDef loadFile(File f) throws JAXBException {
        ExternalToolDef externalToolDef;
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ExternalToolDef.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder loader = factory.newDocumentBuilder();
            Document document = loader.parse(is);
            externalToolDef = (ExternalToolDef)unmarshaller.unmarshal((Node)document);
        }
        catch (JAXBException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new JAXBException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                Utilities.closeStream(is);
                throw throwable;
            }
        }
        Utilities.closeStream(is);
        return externalToolDef;
    }

    public static void save(ExternalToolDef toolsDef, File f) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ExternalToolDef.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(f);
            marshaller.marshal((Object)toolsDef, (OutputStream)os);
        }
        catch (FileNotFoundException e) {
            try {
                throw new JAXBException((Throwable)e);
            }
            catch (Throwable throwable) {
                Utilities.closeStream(os);
                throw throwable;
            }
        }
        Utilities.closeStream(os);
    }

    public static final void main(String[] args) {
        try {
            ExternalToolDef t = new ExternalToolDef();
            t.command = "command";
            t.name = "test";
            t.parameters.add(ToolParameters.MAX_LAT);
            t.parameters.add(ToolParameters.MAX_LON);
            t.parameters.add(ToolParameters.MIN_LAT);
            t.parameters.add(ToolParameters.MIN_LON);
            ExternalToolsLoader.save(t, new File("tools/test.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        ExternalToolsLoader.load();
    }
}

