/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.FontUIResource;
import javax.xml.bind.JAXBException;
import mobac.exceptions.MapSourceInitializationException;
import mobac.externaltools.ExternalToolDef;
import mobac.externaltools.ExternalToolsLoader;
import mobac.gui.actions.AddGpxTrackAreaPolygonMap;
import mobac.gui.actions.AddGpxTrackPolygonMap;
import mobac.gui.actions.AddMapLayer;
import mobac.gui.actions.AtlasConvert;
import mobac.gui.actions.AtlasCreate;
import mobac.gui.actions.AtlasNew;
import mobac.gui.actions.BookmarkAdd;
import mobac.gui.actions.BookmarkManage;
import mobac.gui.actions.DebugSetLogLevel;
import mobac.gui.actions.DebugShowLogFile;
import mobac.gui.actions.DebugShowMapSourceNames;
import mobac.gui.actions.DebugShowMapTileGrid;
import mobac.gui.actions.DebugShowReport;
import mobac.gui.actions.HelpLicenses;
import mobac.gui.actions.PanelShowHide;
import mobac.gui.actions.RefreshCustomMapsources;
import mobac.gui.actions.SelectionModeCircle;
import mobac.gui.actions.SelectionModePolygon;
import mobac.gui.actions.SelectionModeRectangle;
import mobac.gui.actions.SettingsButtonListener;
import mobac.gui.actions.ShowAboutDialog;
import mobac.gui.actions.ShowHelpAction;
import mobac.gui.actions.ShowReadme;
import mobac.gui.actions.SplitPaneHideLeftComponent;
import mobac.gui.atlastree.JAtlasTree;
import mobac.gui.components.FilledLayeredPane;
import mobac.gui.components.JAtlasNameField;
import mobac.gui.components.JBookmarkMenuItem;
import mobac.gui.components.JCollapsiblePanel;
import mobac.gui.components.JMapSourceTree;
import mobac.gui.components.JMenuItem2;
import mobac.gui.components.JZoomCheckBox;
import mobac.gui.listeners.AtlasModelListener;
import mobac.gui.mapview.GridZoom;
import mobac.gui.mapview.PreviewMap;
import mobac.gui.mapview.WgsGrid;
import mobac.gui.mapview.controller.JMapController;
import mobac.gui.mapview.controller.PolygonCircleSelectionMapController;
import mobac.gui.mapview.controller.PolygonSelectionMapController;
import mobac.gui.mapview.controller.RectangleSelectionMapController;
import mobac.gui.mapview.interfaces.MapEventListener;
import mobac.gui.panels.JCoordinatesPanel;
import mobac.gui.panels.JGpxPanel;
import mobac.gui.panels.JMapSourcesPanel;
import mobac.gui.panels.JProfilesPanel;
import mobac.gui.panels.JTileImageParametersPanel;
import mobac.gui.panels.JTileStoreCoveragePanel;
import mobac.mapsources.MapSourcesManager;
import mobac.program.ProgramInfo;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.InitializableMapSource;
import mobac.program.interfaces.MapSource;
import mobac.program.model.Bookmark;
import mobac.program.model.MapSelection;
import mobac.program.model.MercatorPixelCoordinate;
import mobac.program.model.Profile;
import mobac.program.model.SelectedZoomLevels;
import mobac.program.model.Settings;
import mobac.program.model.SettingsWgsGrid;
import mobac.program.model.TileImageParameters;
import mobac.utilities.GBC;
import mobac.utilities.GUIExceptionHandler;
import mobac.utilities.I18nUtils;
import mobac.utilities.Utilities;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MainGUI
extends JFrame
implements MapEventListener {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(MainGUI.class);
    private static Color labelBackgroundColor = new Color(0, 0, 0, 127);
    private static Color checkboxBackgroundColor = new Color(0, 0, 0, 40);
    private static Color labelForegroundColor = Color.WHITE;
    public static final int LEFT_PANEL_MIN_SIZE = 254;
    private static final int LEFT_PANEL_MARGIN = 2;
    private static MainGUI mainGUI = null;
    public static final ArrayList<Image> MOBAC_ICONS = new ArrayList(3);
    protected JMenuBar menuBar;
    protected JMenu externalToolsMenu = null;
    private JMenu bookmarkMenu = null;
    public final PreviewMap previewMap = new PreviewMap();
    public final JAtlasTree jAtlasTree = new JAtlasTree(this.previewMap);
    private JCheckBox wgsGridCheckBox;
    private JComboBox wgsGridCombo;
    private JLabel zoomLevelText;
    private JComboBox gridZoomCombo;
    private JSlider zoomSlider;
    private JMapSourceTree mapSourceTree;
    private JAtlasNameField atlasNameTextField;
    private JButton createAtlasButton;
    private JPanel zoomLevelPanel;
    private JZoomCheckBox[] cbZoom = new JZoomCheckBox[0];
    private JLabel amountOfTilesLabel;
    private JMapSourcesPanel mapSourcePanel;
    private AtlasCreate atlasCreateAction = new AtlasCreate(this.jAtlasTree);
    private JCoordinatesPanel coordinatesPanel;
    private JProfilesPanel profilesPanel;
    public JTileImageParametersPanel tileImageParametersPanel;
    private JTileStoreCoveragePanel tileStoreCoveragePanel;
    public JGpxPanel gpxPanel;
    private JSplitPane splitPane;
    private JPanel mapControlPanel = new JPanel(new BorderLayout());
    private JPanel leftPanel = new JPanel(new GridBagLayout());
    private JPanel leftPanelContent = null;
    private JPanel rightPanel = new JPanel(new GridBagLayout());
    public JMenu logLevelMenu;
    private JMenuItem smRectangle;
    private JMenuItem smPolygon;
    private JMenuItem smCircle;
    private MercatorPixelCoordinate mapSelectionMax = null;
    private MercatorPixelCoordinate mapSelectionMin = null;
    static Font sCustomFont;

    public static void createMainGui() {
        if (mainGUI != null) {
            return;
        }
        mainGUI = new MainGUI();
        mainGUI.setVisible(true);
        log.trace("MainGUI now visible");
    }

    public static MainGUI getMainGUI() {
        return mainGUI;
    }

    public static Font customFont() {
        if (sCustomFont == null) {
            sCustomFont = new Font("\u5b8b\u4f53", 9, 13);
        }
        return sCustomFont;
    }

    public static void setDefaultFontOfAllUIComponents(Font defaultFont) {
        if (defaultFont != null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(defaultFont);
            FontUIResource fontRes = new FontUIResource(defaultFont);
            Enumeration keys = UIManager.getDefaults().keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = UIManager.get(key);
                if (!(value instanceof FontUIResource)) continue;
                UIManager.put(key, fontRes);
            }
        }
    }

    private MainGUI() {
        mainGUI = this;
        this.setIconImages(MOBAC_ICONS);
        GUIExceptionHandler.registerForCurrentThread();
        this.setTitle(ProgramInfo.getCompleteTitle());
        log.trace("Creating main dialog - " + this.getTitle());
        this.setResizable(true);
        Dimension dScreen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setMinimumSize(new Dimension(Math.min(800, dScreen.width), Math.min(590, dScreen.height)));
        this.setSize(this.getMinimumSize());
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowDestroyer());
        this.addComponentListener(new MainWindowListener());
        this.previewMap.addMapEventListener(this);
        this.createControls();
        this.calculateNrOfTilesToDownload();
        this.setLayout(new BorderLayout());
        FilledLayeredPane layeredPane = new FilledLayeredPane();
        layeredPane.add((Component)this.previewMap, (Object)0);
        layeredPane.add((Component)this.mapControlPanel, (Object)1);
        JPanel centerRightPanel = new JPanel();
        centerRightPanel.setLayout(new BorderLayout());
        centerRightPanel.add((Component)layeredPane, "Center");
        centerRightPanel.add((Component)this.rightPanel, "East");
        this.leftPanel.setMinimumSize(new Dimension(254, 100));
        this.splitPane = new JSplitPane(1, true, this.leftPanel, centerRightPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.add(this.splitPane);
        this.updateMapControlsPanel();
        this.updateLeftPanel();
        this.updateRightPanel();
        this.updateZoomLevelCheckBoxes();
        this.calculateNrOfTilesToDownload();
        this.menuBar = new JMenuBar();
        this.prepareMenuBar();
        this.setJMenuBar(this.menuBar);
        this.loadSettings();
        this.profilesPanel.initialize();
        this.mapSourceChanged(this.previewMap.getMapSource());
        this.updateZoomLevelCheckBoxes();
        this.updateGridSizeCombo();
        this.tileImageParametersPanel.updateControlsState();
        this.zoomChanged(this.previewMap.getZoom());
        this.gridZoomChanged(this.previewMap.getGridZoom());
        this.previewMap.updateMapSelection();
        this.previewMap.grabFocus();
    }

    private void createControls() {
        this.zoomSlider = new JSlider(0, this.previewMap.getMapSource().getMaxZoom());
        this.zoomSlider.setOrientation(0);
        this.zoomSlider.setMinimumSize(new Dimension(50, 10));
        this.zoomSlider.setSize(50, this.zoomSlider.getPreferredSize().height);
        this.zoomSlider.addChangeListener(new ZoomSliderListener());
        this.zoomSlider.setOpaque(false);
        this.zoomLevelText = new JLabel(" 00 ");
        this.zoomLevelText.setOpaque(true);
        this.zoomLevelText.setBackground(labelBackgroundColor);
        this.zoomLevelText.setForeground(labelForegroundColor);
        this.zoomLevelText.setToolTipText(I18nUtils.localizedStringForKey("map_ctrl_zoom_level_title_tips", new Object[0]));
        this.gridZoomCombo = new JComboBox();
        this.gridZoomCombo.setEditable(false);
        this.gridZoomCombo.addActionListener(new GridZoomComboListener());
        this.gridZoomCombo.setToolTipText(I18nUtils.localizedStringForKey("map_ctrl_zoom_grid_tips", new Object[0]));
        SettingsWgsGrid s = Settings.getInstance().wgsGrid;
        this.wgsGridCheckBox = new JCheckBox(I18nUtils.localizedStringForKey("map_ctrl_wgs_grid_title", new Object[0]), s.enabled);
        this.wgsGridCheckBox.setOpaque(true);
        this.wgsGridCheckBox.setBackground(checkboxBackgroundColor);
        this.wgsGridCheckBox.setForeground(labelForegroundColor);
        this.wgsGridCheckBox.setToolTipText(I18nUtils.localizedStringForKey("map_ctrl_wgs_grid_tips", new Object[0]));
        this.wgsGridCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.wgsGridCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled;
                Settings.getInstance().wgsGrid.enabled = enabled = MainGUI.this.wgsGridCheckBox.isSelected();
                MainGUI.this.wgsGridCombo.setVisible(enabled);
                MainGUI.this.previewMap.repaint();
            }
        });
        this.wgsGridCombo = new JComboBox<WgsGrid.WgsDensity>(WgsGrid.WgsDensity.values());
        this.wgsGridCombo.setMaximumRowCount(WgsGrid.WgsDensity.values().length);
        this.wgsGridCombo.setVisible(s.enabled);
        this.wgsGridCombo.setSelectedItem((Object)s.density);
        this.wgsGridCombo.setToolTipText(I18nUtils.localizedStringForKey("map_ctrl_wgs_grid_density_tips", new Object[0]));
        this.wgsGridCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WgsGrid.WgsDensity d;
                Settings.getInstance().wgsGrid.density = d = (WgsGrid.WgsDensity)((Object)MainGUI.this.wgsGridCombo.getSelectedItem());
                MainGUI.this.previewMap.repaint();
            }
        });
        this.mapSourceTree = new JMapSourceTree(MapSourcesManager.getInstance().getEnabledOrderedMapSources());
        this.mapSourceTree.addTreeSelectionListener(new MapSourceTreeListener());
        this.mapSourceTree.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                boolean isLocationClickable = ((JMapSourceTree)e.getComponent()).isLocationClickable(e.getPoint());
                JTree jTree = (JTree)e.getComponent();
                jTree.setCursor(isLocationClickable ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
            }
        });
        this.atlasNameTextField = new JAtlasNameField();
        this.atlasNameTextField.setColumns(12);
        this.atlasNameTextField.setActionCommand("atlasNameTextField");
        this.atlasNameTextField.setToolTipText(I18nUtils.localizedStringForKey("lp_atlas_name_field_tips", new Object[0]));
        this.createAtlasButton = new JButton(I18nUtils.localizedStringForKey("lp_mian_create_btn_title", new Object[0]));
        this.createAtlasButton.setIcon(new ImageIcon(MainGUI.class.getResource("/mobac/resources/images/atlas_create.png")));
        this.createAtlasButton.addActionListener(this.atlasCreateAction);
        this.createAtlasButton.setToolTipText(I18nUtils.localizedStringForKey("lp_main_create_btn_tips", new Object[0]));
        this.zoomLevelPanel = new JPanel();
        this.zoomLevelPanel.setBorder(BorderFactory.createEmptyBorder());
        this.zoomLevelPanel.setOpaque(false);
        this.amountOfTilesLabel = new JLabel();
        this.amountOfTilesLabel.setToolTipText(I18nUtils.localizedStringForKey("lp_zoom_total_tile_count_tips", new Object[0]));
        this.amountOfTilesLabel.setOpaque(true);
        this.amountOfTilesLabel.setBackground(labelBackgroundColor);
        this.amountOfTilesLabel.setForeground(labelForegroundColor);
        this.coordinatesPanel = new JCoordinatesPanel();
        this.tileImageParametersPanel = new JTileImageParametersPanel();
        this.profilesPanel = new JProfilesPanel(this.jAtlasTree);
        this.profilesPanel.getLoadButton().addActionListener(new LoadProfileListener());
        this.tileStoreCoveragePanel = new JTileStoreCoveragePanel(this.previewMap);
    }

    private void prepareMenuBar() {
        JMenu atlasMenu = new JMenu(I18nUtils.localizedStringForKey("menu_atlas", new Object[0]));
        atlasMenu.setIcon(Utilities.loadResourceImageIcon("atlas.png"));
        atlasMenu.setMnemonic(65);
        JMenuItem newAtlas = new JMenuItem(I18nUtils.localizedStringForKey("menu_atlas_new", new Object[0]));
        newAtlas.setIcon(Utilities.loadResourceImageIcon("atlas_add.png"));
        newAtlas.setMnemonic(78);
        newAtlas.addActionListener(new AtlasNew());
        atlasMenu.add(newAtlas);
        JMenuItem convertAtlas = new JMenuItem(I18nUtils.localizedStringForKey("menu_atlas_convert_format", new Object[0]));
        convertAtlas.setIcon(Utilities.loadResourceImageIcon("atlas_convert.png"));
        convertAtlas.setMnemonic(86);
        convertAtlas.addActionListener(new AtlasConvert());
        atlasMenu.add(convertAtlas);
        atlasMenu.addSeparator();
        JMenuItem createAtlas = new JMenuItem(I18nUtils.localizedStringForKey("menu_atlas_create", new Object[0]));
        createAtlas.setIcon(Utilities.loadResourceImageIcon("atlas_create.png"));
        createAtlas.setMnemonic(67);
        createAtlas.addActionListener(this.atlasCreateAction);
        atlasMenu.add(createAtlas);
        JMenu selectionMenu = new JMenu(I18nUtils.localizedStringForKey("menu_selection", new Object[0]));
        selectionMenu.setIcon(Utilities.loadResourceImageIcon("menu_icons/selections.png"));
        selectionMenu.setMnemonic(83);
        JMenu selectionModeMenu = new JMenu(I18nUtils.localizedStringForKey("menu_selection_selection", new Object[0]));
        selectionModeMenu.setIcon(Utilities.loadResourceImageIcon("menu_icons/menu_selection_mode.png"));
        selectionModeMenu.setMnemonic(77);
        selectionMenu.add(selectionModeMenu);
        this.smRectangle = new JCheckBoxMenuItem(I18nUtils.localizedStringForKey("menu_selection_selection_rect", new Object[0]));
        this.smRectangle.setIcon(Utilities.loadResourceImageIcon("menu_icons/menu_selection_mode.png"));
        this.smRectangle.addActionListener(new SelectionModeRectangle());
        this.smRectangle.setSelected(true);
        selectionModeMenu.add(this.smRectangle);
        this.smPolygon = new JCheckBoxMenuItem(I18nUtils.localizedStringForKey("menu_selection_selection_polygon", new Object[0]));
        this.smPolygon.setIcon(Utilities.loadResourceImageIcon("menu_icons/menu_selection_polygon.png"));
        this.smPolygon.addActionListener(new SelectionModePolygon());
        selectionModeMenu.add(this.smPolygon);
        this.smCircle = new JCheckBoxMenuItem(I18nUtils.localizedStringForKey("menu_selection_selection_circle", new Object[0]));
        this.smCircle.setIcon(Utilities.loadResourceImageIcon("menu_icons/menu_selection_circle.png"));
        this.smCircle.addActionListener(new SelectionModeCircle());
        selectionModeMenu.add(this.smCircle);
        ButtonGroup selectionModeGroup = new ButtonGroup();
        selectionModeGroup.add(this.smRectangle);
        selectionModeGroup.add(this.smPolygon);
        selectionModeGroup.add(this.smCircle);
        JMenuItem addSelection = new JMenuItem(I18nUtils.localizedStringForKey("menu_selection_selection_add", new Object[0]));
        addSelection.setIcon(Utilities.loadResourceImageIcon("menu_icons/menu_selection_add.png"));
        addSelection.addActionListener(AddMapLayer.INSTANCE);
        JSeparator selectionSeparator = new JSeparator();
        selectionMenu.add(selectionSeparator);
        addSelection.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        addSelection.setMnemonic(65);
        selectionMenu.add(addSelection);
        JMenuItem2 addGpxTrackSelection = new JMenuItem2(I18nUtils.localizedStringForKey("menu_selection_selection_add_around_gpx", new Object[0]), AddGpxTrackPolygonMap.class);
        addGpxTrackSelection.setIcon(Utilities.loadResourceImageIcon("menu_icons/menu_selection_add.png"));
        selectionMenu.add(addGpxTrackSelection);
        JMenuItem2 addGpxTrackAreaSelection = new JMenuItem2(I18nUtils.localizedStringForKey("menu_selection_selection_add_by_gpx", new Object[0]), AddGpxTrackAreaPolygonMap.class);
        addGpxTrackAreaSelection.setIcon(Utilities.loadResourceImageIcon("menu_icons/menu_selection_add.png"));
        selectionMenu.add(addGpxTrackAreaSelection);
        this.bookmarkMenu = new JMenu(I18nUtils.localizedStringForKey("menu_bookmark", new Object[0]));
        this.bookmarkMenu.setIcon(Utilities.loadResourceImageIcon("menu_icons/menu_bookmarks.png"));
        this.bookmarkMenu.setMnemonic(66);
        JMenuItem addBookmark = new JMenuItem(I18nUtils.localizedStringForKey("menu_bookmark_save", new Object[0]));
        addBookmark.setIcon(Utilities.loadResourceImageIcon("menu_icons/menu_save_view.png"));
        addBookmark.setMnemonic(83);
        addBookmark.addActionListener(new BookmarkAdd(this.previewMap));
        this.bookmarkMenu.add(addBookmark);
        JMenuItem2 manageBookmarks = new JMenuItem2(I18nUtils.localizedStringForKey("menu_bookmark_manage", new Object[0]), BookmarkManage.class);
        manageBookmarks.setIcon(Utilities.loadResourceImageIcon("menu_icons/menu_manage_bookmarks.png"));
        manageBookmarks.setMnemonic(83);
        this.bookmarkMenu.add(addBookmark);
        this.bookmarkMenu.add(manageBookmarks);
        this.bookmarkMenu.addSeparator();
        this.menuBar.add(atlasMenu);
        this.menuBar.add(selectionMenu);
        this.menuBar.add(this.bookmarkMenu);
        this.loadExternalToolsMenu();
        this.menuBar.add(Box.createHorizontalGlue());
        JMenu debugMenu = new JMenu(I18nUtils.localizedStringForKey("menu_debug", new Object[0]));
        debugMenu.setIcon(Utilities.loadResourceImageIcon("icon_debug_ms.png"));
        JCheckBoxMenuItem mapGrid = new JCheckBoxMenuItem(I18nUtils.localizedStringForKey("menu_debug_show_hide_tile_border", new Object[0]), false);
        mapGrid.setIcon(Utilities.loadResourceImageIcon("menu_icons/menu_show_tile_borders.png"));
        mapGrid.addActionListener(new DebugShowMapTileGrid());
        debugMenu.add(mapGrid);
        debugMenu.addSeparator();
        debugMenu.setMnemonic(68);
        JMenuItem2 mapSourceNames = new JMenuItem2(I18nUtils.localizedStringForKey("menu_debug_show_all_map_source", new Object[0]), DebugShowMapSourceNames.class);
        mapSourceNames.setIcon(Utilities.loadResourceImageIcon("menu_icons/menu_show_mapsources.png"));
        mapSourceNames.setMnemonic(78);
        debugMenu.add(mapSourceNames);
        debugMenu.addSeparator();
        JMenuItem2 refreshCustomMapSources = new JMenuItem2(I18nUtils.localizedStringForKey("menu_debug_refresh_map_source", new Object[0]), RefreshCustomMapsources.class);
        refreshCustomMapSources.setIcon(Utilities.loadResourceImageIcon("refresh.png"));
        debugMenu.add(refreshCustomMapSources);
        debugMenu.addSeparator();
        JMenuItem2 showLog = new JMenuItem2(I18nUtils.localizedStringForKey("menu_debug_show_log_file", new Object[0]), DebugShowLogFile.class);
        showLog.setIcon(Utilities.loadResourceImageIcon("menu_icons/menu_show_logfile.png"));
        showLog.setMnemonic(83);
        debugMenu.add(showLog);
        this.logLevelMenu = new JMenu(I18nUtils.localizedStringForKey("menu_debug_log_level", new Object[0]));
        this.logLevelMenu.setIcon(Utilities.loadResourceImageIcon("menu_icons/menu_log_level.png"));
        this.logLevelMenu.setMnemonic(76);
        Level[] list = new Level[]{Level.TRACE, Level.DEBUG, Level.INFO, Level.ERROR, Level.FATAL, Level.OFF};
        DebugSetLogLevel al = new DebugSetLogLevel();
        Level rootLogLevel = Logger.getRootLogger().getLevel();
        for (Level level : list) {
            String name = level.toString();
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(name, rootLogLevel.toString().equals(name));
            item.setName(name);
            item.addActionListener(al);
            this.logLevelMenu.add(item);
        }
        debugMenu.add(this.logLevelMenu);
        debugMenu.addSeparator();
        JMenuItem2 report = new JMenuItem2(I18nUtils.localizedStringForKey("menu_debug_system_report", new Object[0]), DebugShowReport.class);
        report.setIcon(Utilities.loadResourceImageIcon("menu_icons/menu_gen_sysreport.png"));
        report.setMnemonic(82);
        debugMenu.add(report);
        this.menuBar.add(debugMenu);
        JMenu toolsMenu = new JMenu(I18nUtils.localizedStringForKey("menu_tools", new Object[0]));
        toolsMenu.setIcon(new ImageIcon(MainGUI.class.getResource("/mobac/resources/images/menu_icons/menu_tools.png")));
        toolsMenu.setMnemonic(84);
        this.menuBar.add(toolsMenu);
        JMenuItem2 settingsMenuItem = new JMenuItem2(I18nUtils.localizedStringForKey("menu_tools_settings", new Object[0]), SettingsButtonListener.class);
        settingsMenuItem.setIcon(new ImageIcon(MainGUI.class.getResource("/mobac/resources/images/menu_icons/menu_settings.png")));
        toolsMenu.add(settingsMenuItem);
        JSeparator separator = new JSeparator();
        toolsMenu.add(separator);
        JMenuItem showRightPanel = new JMenuItem(I18nUtils.localizedStringForKey("menu_show_hide_gpx_panel", new Object[0]));
        showRightPanel.setIcon(new ImageIcon(MainGUI.class.getResource("/mobac/resources/images/menu_icons/menu_panels_right.png")));
        showRightPanel.addActionListener(new PanelShowHide(this.rightPanel));
        JMenuItem showLeftPanel = new JMenuItem(I18nUtils.localizedStringForKey("menu_show_hide_left_panel", new Object[0]));
        toolsMenu.add(showLeftPanel);
        showLeftPanel.setIcon(new ImageIcon(MainGUI.class.getResource("/mobac/resources/images/menu_icons/menu_panels_left.png")));
        showLeftPanel.addActionListener(new SplitPaneHideLeftComponent(this.splitPane));
        toolsMenu.add(showRightPanel);
        JMenu help = new JMenu(I18nUtils.localizedStringForKey("menu_help", new Object[0]));
        help.setIcon(new ImageIcon(MainGUI.class.getResource("/mobac/resources/images/menu_icons/menu_help.png")));
        JMenuItem readme = new JMenuItem(I18nUtils.localizedStringForKey("menu_help_readme", new Object[0]));
        readme.setIcon(new ImageIcon(MainGUI.class.getResource("/mobac/resources/images/menu_icons/menu_info.png")));
        JMenuItem howToMap = new JMenuItem(I18nUtils.localizedStringForKey("menu_help_how_to_preview", new Object[0]));
        howToMap.setIcon(new ImageIcon(MainGUI.class.getResource("/mobac/resources/images/menu_icons/menu_info.png")));
        JMenuItem licenses = new JMenuItem(I18nUtils.localizedStringForKey("menu_help_licenses", new Object[0]));
        licenses.setIcon(new ImageIcon(MainGUI.class.getResource("/mobac/resources/images/menu_icons/menu_licenses.png")));
        JMenuItem about = new JMenuItem(I18nUtils.localizedStringForKey("menu_help_about", new Object[0]));
        about.setIcon(new ImageIcon(MainGUI.class.getResource("/mobac/resources/images/mobac16.png")));
        readme.addActionListener(new ShowReadme());
        about.addActionListener(new ShowAboutDialog());
        howToMap.addActionListener(new ShowHelpAction());
        licenses.addActionListener(new HelpLicenses());
        help.add(readme);
        help.add(howToMap);
        help.addSeparator();
        help.add(licenses);
        help.addSeparator();
        help.add(about);
        this.menuBar.add(help);
    }

    public void loadExternalToolsMenu() {
        if (ExternalToolsLoader.load()) {
            if (this.externalToolsMenu == null) {
                this.externalToolsMenu = new JMenu(I18nUtils.localizedStringForKey("menu_external_tools", new Object[0]));
                this.externalToolsMenu.setIcon(new ImageIcon(MainGUI.class.getResource("/mobac/resources/images/menu_icons/menu_external_tools.png")));
                this.externalToolsMenu.setMnemonic(69);
                this.externalToolsMenu.addMenuListener(new MenuListener(){

                    @Override
                    public void menuSelected(MenuEvent e) {
                        MainGUI.this.loadExternalToolsMenu();
                        log.debug("External Tools menu Loaded");
                    }

                    @Override
                    public void menuDeselected(MenuEvent e) {
                    }

                    @Override
                    public void menuCanceled(MenuEvent e) {
                    }
                });
                this.menuBar.add(this.externalToolsMenu);
            }
            this.externalToolsMenu.removeAll();
            for (ExternalToolDef t : ExternalToolsLoader.tools) {
                JMenuItem externalToolMenuItem = new JMenuItem(t.name);
                externalToolMenuItem.addActionListener(t);
                externalToolMenuItem.setIcon(new ImageIcon(MainGUI.class.getResource("/mobac/resources/images/menu_icons/menu_external_tool_item.png")));
                this.externalToolsMenu.add(externalToolMenuItem);
            }
        }
    }

    private void updateLeftPanel() {
        this.leftPanel.removeAll();
        this.coordinatesPanel.addButtonActionListener(new ApplySelectionButtonListener());
        this.mapSourcePanel = new JMapSourcesPanel(this.mapSourceTree);
        JCollapsiblePanel zoomLevelsPanel = new JCollapsiblePanel(I18nUtils.localizedStringForKey("lp_zoom_title", new Object[0]), new GridBagLayout());
        zoomLevelsPanel.addContent(this.zoomLevelPanel, GBC.eol().insets(2, 4, 2, 0));
        zoomLevelsPanel.addContent(this.amountOfTilesLabel, GBC.std().anchor(17).insets(0, 5, 0, 2));
        int leftPanelVerticalScrollWidth = 14;
        GBC gbc_std = GBC.std().insets(5, 2, 5, 3);
        GBC gbc_eol = GBC.eol().insets(2, 2, 2, 3);
        JCollapsiblePanel atlasContentPanel = new JCollapsiblePanel(I18nUtils.localizedStringForKey("lp_atlas_title", new Object[0]), new GridBagLayout());
        JScrollPane treeScrollPane = new JScrollPane(this.jAtlasTree, 20, 30);
        this.jAtlasTree.getTreeModel().addTreeModelListener(new AtlasModelListener(this.jAtlasTree, this.profilesPanel));
        treeScrollPane.setPreferredSize(new Dimension(100, 200));
        treeScrollPane.setAutoscrolls(true);
        atlasContentPanel.addContent(treeScrollPane, GBC.eol().fill().insets(0, 1, 0, 0));
        JButton clearAtlas = new JButton(I18nUtils.localizedStringForKey("lp_atlas_new_btn_title", new Object[0]));
        atlasContentPanel.addContent(clearAtlas, GBC.std());
        clearAtlas.addActionListener(new AtlasNew());
        JButton addLayers = new JButton(I18nUtils.localizedStringForKey("lp_atlas_add_selection_btn_title", new Object[0]));
        atlasContentPanel.addContent(addLayers, GBC.eol());
        addLayers.addActionListener(AddMapLayer.INSTANCE);
        atlasContentPanel.addContent(new JLabel(I18nUtils.localizedStringForKey("lp_atlas_name_label_title", new Object[0])), gbc_std);
        atlasContentPanel.addContent(this.atlasNameTextField, gbc_eol.fill(2));
        this.leftPanelContent = new JPanel(new GridBagLayout());
        this.leftPanelContent.add((Component)this.mapSourcePanel, gbc_eol);
        this.leftPanelContent.add((Component)zoomLevelsPanel, gbc_eol);
        this.leftPanelContent.add((Component)atlasContentPanel, gbc_eol);
        this.leftPanelContent.add((Component)this.profilesPanel, gbc_eol);
        this.leftPanelContent.add((Component)this.createAtlasButton, gbc_eol);
        this.leftPanelContent.add((Component)this.tileImageParametersPanel, gbc_eol);
        this.leftPanelContent.add((Component)this.tileStoreCoveragePanel, gbc_eol);
        this.leftPanelContent.add((Component)this.coordinatesPanel, gbc_eol);
        this.leftPanelContent.add(Box.createVerticalGlue(), GBC.eol().fill(3));
        JScrollPane scrollPane = new JScrollPane(this.leftPanelContent);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(leftPanelVerticalScrollWidth, 0));
        this.leftPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.GRAY));
        this.leftPanel.add((Component)scrollPane, GBC.std().fill());
    }

    private void updateRightPanel() {
        GBC gbc_eol = GBC.eol().insets(5, 2, 5, 2).fill();
        this.gpxPanel = new JGpxPanel(this.previewMap);
        this.rightPanel.add((Component)this.gpxPanel, gbc_eol);
    }

    private JPanel updateMapControlsPanel() {
        this.mapControlPanel.removeAll();
        this.mapControlPanel.setOpaque(false);
        JLabel zoomLabel = new JLabel(I18nUtils.localizedStringForKey("map_ctrl_zoom_level_title", new Object[0]));
        zoomLabel.setOpaque(true);
        zoomLabel.setBackground(labelBackgroundColor);
        zoomLabel.setForeground(labelForegroundColor);
        JPanel topControls = new JPanel(new GridBagLayout());
        topControls.setOpaque(false);
        topControls.add((Component)zoomLabel, GBC.std().insets(5, 5, 0, 0));
        topControls.add((Component)this.zoomSlider, GBC.std().insets(0, 5, 0, 0));
        topControls.add((Component)this.zoomLevelText, GBC.std().insets(0, 5, 0, 0));
        topControls.add((Component)this.gridZoomCombo, GBC.std().insets(10, 5, 0, 0));
        topControls.add((Component)this.wgsGridCheckBox, GBC.std().insets(10, 5, 0, 0));
        topControls.add((Component)this.wgsGridCombo, GBC.std().insets(5, 5, 0, 0));
        topControls.add(Box.createHorizontalGlue(), GBC.std().fillH());
        this.mapControlPanel.add((Component)topControls, "North");
        return this.mapControlPanel;
    }

    public void updateMapSourcesList() {
        MapSource ms2;
        this.mapSourceTree.selectClickedMapSource();
        MapSource ms = this.mapSourceTree.getSelectedMapSource();
        this.mapSourceTree.initialize(MapSourcesManager.getInstance().getEnabledOrderedMapSources());
        if (!this.mapSourceTree.selectMapSource(ms)) {
            this.mapSourceTree.selectFirstMapSource();
        }
        if (!ms.equals(ms2 = this.mapSourceTree.getSelectedMapSource())) {
            this.previewMap.setMapSource(ms2);
        }
    }

    public void updateBookmarksMenu() {
        LinkedList<JMenuItem> items = new LinkedList<JMenuItem>();
        for (int i = 0; i < this.bookmarkMenu.getMenuComponentCount(); ++i) {
            JMenuItem item = this.bookmarkMenu.getItem(i);
            if (item instanceof JBookmarkMenuItem) continue;
            items.add(item);
        }
        this.bookmarkMenu.removeAll();
        for (JMenuItem item : items) {
            if (item != null) {
                this.bookmarkMenu.add(item);
                continue;
            }
            this.bookmarkMenu.addSeparator();
        }
        for (Bookmark bookmark : Settings.getInstance().placeBookmarks) {
            JBookmarkMenuItem bookmarkMenuItem = new JBookmarkMenuItem(bookmark);
            bookmarkMenuItem.setIcon(new ImageIcon(MainGUI.class.getResource("/mobac/resources/images/menu_icons/menu_bookmark_item.png")));
            this.bookmarkMenu.add(bookmarkMenuItem);
        }
    }

    private void loadSettings() {
        if (Profile.DEFAULT.exists()) {
            try {
                this.jAtlasTree.load(Profile.DEFAULT);
            }
            catch (Exception e) {
                log.error("Failed to load atlas", e);
                GUIExceptionHandler.processException(e);
                new AtlasNew().actionPerformed(null);
            }
        } else {
            new AtlasNew().actionPerformed(null);
        }
        Settings settings = Settings.getInstance();
        this.atlasNameTextField.setText(settings.elementName);
        this.previewMap.settingsLoad();
        int nextZoom = 0;
        List<Integer> zoomList = settings.selectedZoomLevels;
        if (zoomList != null) {
            block2: for (JZoomCheckBox currentZoomCb : this.cbZoom) {
                for (int i = nextZoom; i < zoomList.size(); ++i) {
                    int currentListZoom = zoomList.get(i);
                    if (currentZoomCb.getZoomLevel() != currentListZoom) continue;
                    currentZoomCb.setSelected(true);
                    nextZoom = 1;
                    continue block2;
                }
            }
        }
        this.coordinatesPanel.setNumberFormat(settings.coordinateNumberFormat);
        this.tileImageParametersPanel.loadSettings();
        this.tileImageParametersPanel.atlasFormatChanged(this.jAtlasTree.getAtlas().getOutputFormat());
        this.setSize(settings.mainWindow.size);
        Point windowLocation = settings.mainWindow.position;
        if (windowLocation.x == -1 && windowLocation.y == -1) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation(windowLocation);
        }
        if (settings.mainWindow.maximized) {
            this.setExtendedState(6);
        }
        this.leftPanel.setVisible(settings.mainWindow.leftPanelVisible);
        this.leftPanel.setPreferredSize(new Dimension(settings.mainWindow.leftPanelWidth, 100));
        this.rightPanel.setVisible(settings.mainWindow.rightPanelVisible);
        if (this.leftPanelContent != null) {
            for (Component c : this.leftPanelContent.getComponents()) {
                JCollapsiblePanel cp;
                String name;
                if (!(c instanceof JCollapsiblePanel) || (name = (cp = (JCollapsiblePanel)c).getName()) == null || !settings.mainWindow.collapsedPanels.contains(name)) continue;
                cp.setCollapsed(true);
            }
        }
        this.updateBookmarksMenu();
    }

    private void saveSettings() {
        try {
            boolean maximized;
            this.jAtlasTree.save(Profile.DEFAULT);
            Settings s = Settings.getInstance();
            this.previewMap.settingsSave();
            s.mapviewMapSource = this.previewMap.getMapSource().getName();
            s.selectedZoomLevels = new SelectedZoomLevels(this.cbZoom).getZoomLevelList();
            s.elementName = this.atlasNameTextField.getText();
            s.coordinateNumberFormat = this.coordinatesPanel.getNumberFormat();
            this.tileImageParametersPanel.saveSettings();
            s.mainWindow.maximized = maximized = (this.getExtendedState() & 6) != 0;
            if (!maximized) {
                s.mainWindow.size = this.getSize();
                s.mainWindow.position = this.getLocation();
            }
            s.mainWindow.collapsedPanels.clear();
            if (this.leftPanelContent != null) {
                for (Component c : this.leftPanelContent.getComponents()) {
                    JCollapsiblePanel cp;
                    if (!(c instanceof JCollapsiblePanel) || !(cp = (JCollapsiblePanel)c).isCollapsed()) continue;
                    s.mainWindow.collapsedPanels.add(cp.getName());
                }
            }
            s.mainWindow.leftPanelVisible = this.leftPanel.isVisible();
            s.mainWindow.leftPanelWidth = this.leftPanel.getWidth();
            s.mainWindow.rightPanelVisible = this.rightPanel.isVisible();
            this.checkAndSaveSettings();
        }
        catch (Exception e) {
            GUIExceptionHandler.showExceptionDialog(e);
            JOptionPane.showMessageDialog(null, I18nUtils.localizedStringForKey("msg_settings_write_error", new Object[0]), I18nUtils.localizedStringForKey("Error", new Object[0]), 0);
        }
    }

    public void checkAndSaveSettings() throws JAXBException {
        int x;
        if (Settings.checkSettingsFileModified() && (x = JOptionPane.showConfirmDialog(this, I18nUtils.localizedStringForKey("msg_setting_file_is_changed_by_other", new Object[0]), I18nUtils.localizedStringForKey("msg_setting_file_is_changed_by_other_title", new Object[0]), 0, 3)) != 0) {
            return;
        }
        Settings.save();
    }

    public JTileImageParametersPanel getParametersPanel() {
        return this.tileImageParametersPanel;
    }

    public String getUserText() {
        return this.atlasNameTextField.getText();
    }

    public void refreshPreviewMap() {
        this.previewMap.refreshMap();
    }

    private void updateGridSizeCombo() {
        int maxZoom = this.previewMap.getMapSource().getMaxZoom();
        int minZoom = this.previewMap.getMapSource().getMinZoom();
        GridZoom lastGridZoom = (GridZoom)this.gridZoomCombo.getSelectedItem();
        this.gridZoomCombo.setEnabled(false);
        this.gridZoomCombo.removeAllItems();
        this.gridZoomCombo.setMaximumRowCount(maxZoom - minZoom + 2);
        this.gridZoomCombo.addItem(new GridZoom(-1){

            @Override
            public String toString() {
                return I18nUtils.localizedStringForKey("map_ctrl_zoom_grid_disable", new Object[0]);
            }
        });
        for (int i = maxZoom; i >= minZoom; --i) {
            this.gridZoomCombo.addItem(new GridZoom(i));
        }
        if (lastGridZoom != null) {
            this.gridZoomCombo.setSelectedItem(lastGridZoom);
        }
        this.gridZoomCombo.setEnabled(true);
    }

    private void updateZoomLevelCheckBoxes() {
        MapSource tileSource = this.previewMap.getMapSource();
        int zoomLevels = tileSource.getMaxZoom() - tileSource.getMinZoom() + 1;
        zoomLevels = Math.max(zoomLevels, 0);
        JZoomCheckBox[] oldZoomLevelCheckBoxes = this.cbZoom;
        int oldMinZoom = 0;
        if (this.cbZoom.length > 0) {
            oldMinZoom = this.cbZoom[0].getZoomLevel();
        }
        this.cbZoom = new JZoomCheckBox[zoomLevels];
        this.zoomLevelPanel.removeAll();
        this.zoomLevelPanel.setLayout(new GridLayout(0, 10, 1, 2));
        ZoomLevelCheckBoxListener cbl = new ZoomLevelCheckBoxListener();
        for (int i = this.cbZoom.length - 1; i >= 0; --i) {
            int cbz = i + tileSource.getMinZoom();
            JZoomCheckBox cb = new JZoomCheckBox(cbz);
            cb.setPreferredSize(new Dimension(22, 11));
            cb.setMinimumSize(cb.getPreferredSize());
            cb.setOpaque(false);
            cb.setFocusable(false);
            cb.setName(Integer.toString(cbz));
            int oldCbIndex = cbz - oldMinZoom;
            if (oldCbIndex >= 0 && oldCbIndex < oldZoomLevelCheckBoxes.length) {
                cb.setSelected(oldZoomLevelCheckBoxes[oldCbIndex].isSelected());
            }
            cb.addActionListener(cbl);
            this.zoomLevelPanel.add(cb);
            this.cbZoom[i] = cb;
            JLabel l = new JLabel(Integer.toString(cbz));
            this.zoomLevelPanel.add(l);
        }
        this.amountOfTilesLabel.setOpaque(false);
        this.amountOfTilesLabel.setForeground(Color.black);
    }

    @Override
    public void selectionChanged(MercatorPixelCoordinate max, MercatorPixelCoordinate min) {
        this.mapSelectionMax = max;
        this.mapSelectionMin = min;
        this.coordinatesPanel.setSelection(max, min);
        this.calculateNrOfTilesToDownload();
    }

    @Override
    public void zoomChanged(int zoomLevel) {
        this.zoomLevelText.setText(" " + zoomLevel + " ");
        this.zoomSlider.setValue(zoomLevel);
    }

    @Override
    public void gridZoomChanged(int newGridZoomLevel) {
        this.gridZoomCombo.setSelectedItem(new GridZoom(newGridZoomLevel));
    }

    public MapSource getSelectedMapSource() {
        this.mapSourceTree.selectClickedMapSource();
        return this.mapSourceTree.getSelectedMapSource();
    }

    public SelectedZoomLevels getSelectedZoomLevels() {
        return new SelectedZoomLevels(this.cbZoom);
    }

    @Override
    public void selectNextMapSource() {
        if (!this.mapSourceTree.selectNextMapSource()) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.mapSourceChanged(this.mapSourceTree.getSelectedMapSource());
        }
    }

    @Override
    public void selectPreviousMapSource() {
        if (!this.mapSourceTree.selectPreviousMapSource()) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.mapSourceChanged(this.mapSourceTree.getSelectedMapSource());
        }
    }

    @Override
    public void mapSourceChanged(MapSource newMapSource) {
        this.calculateNrOfTilesToDownload();
        this.mapSourceTree.selectMapSource(newMapSource);
        this.mapSourcePanel.setMapSourceLabel(newMapSource);
    }

    @Override
    public void mapSelectionControllerChanged(JMapController newMapController) {
        this.smPolygon.setSelected(false);
        this.smCircle.setSelected(false);
        this.smRectangle.setSelected(false);
        if (newMapController instanceof PolygonSelectionMapController) {
            this.smPolygon.setSelected(true);
        } else if (newMapController instanceof PolygonCircleSelectionMapController) {
            this.smCircle.setSelected(true);
        } else if (newMapController instanceof RectangleSelectionMapController) {
            this.smRectangle.setSelected(true);
        }
    }

    private void setSelectionByEnteredCoordinates() {
        this.coordinatesPanel.correctMinMax();
        MapSelection ms = this.coordinatesPanel.getMapSelection(this.previewMap.getMapSource());
        this.mapSelectionMax = ms.getBottomRightPixelCoordinate();
        this.mapSelectionMin = ms.getTopLeftPixelCoordinate();
        this.previewMap.setSelectionAndZoomTo(ms, false);
    }

    public MapSelection getMapSelectionCoordinates() {
        if (this.mapSelectionMax == null || this.mapSelectionMin == null) {
            return null;
        }
        return new MapSelection(this.previewMap.getMapSource(), this.mapSelectionMax, this.mapSelectionMin);
    }

    public TileImageParameters getSelectedTileImageParameters() {
        return this.tileImageParametersPanel.getSelectedTileImageParameters();
    }

    private void calculateNrOfTilesToDownload() {
        MapSelection ms = this.getMapSelectionCoordinates();
        String baseText = I18nUtils.localizedStringForKey("lp_zoom_total_tile_title", new Object[0]);
        if (ms == null || !ms.isAreaSelected()) {
            this.amountOfTilesLabel.setText(String.format(baseText, "0"));
            this.amountOfTilesLabel.setToolTipText("");
        } else {
            try {
                SelectedZoomLevels sZL = new SelectedZoomLevels(this.cbZoom);
                int[] zoomLevels = sZL.getZoomLevels();
                long totalNrOfTiles = 0L;
                StringBuilder hint = new StringBuilder(1024);
                hint.append(I18nUtils.localizedStringForKey("lp_zoom_total_tile_hint_head", new Object[0]));
                for (int i = 0; i < zoomLevels.length; ++i) {
                    int zoom = zoomLevels[i];
                    long[] info = ms.calculateNrOfTilesEx(zoom);
                    totalNrOfTiles += info[0];
                    hint.append(String.format(I18nUtils.localizedStringForKey("lp_zoom_total_tile_hint_row", new Object[0]), zoomLevels[i], info[0], info[1], info[2]));
                }
                String hintText = "<html>" + hint.toString() + "</html>";
                this.amountOfTilesLabel.setText(String.format(baseText, Long.toString(totalNrOfTiles)));
                this.amountOfTilesLabel.setToolTipText(hintText);
            }
            catch (Exception e) {
                this.amountOfTilesLabel.setText(String.format(baseText, "?"));
                log.error("", e);
            }
        }
    }

    public AtlasInterface getAtlas() {
        return this.jAtlasTree.getAtlas();
    }

    static {
        MOBAC_ICONS.add(Utilities.loadResourceImageIcon("mobac48.png").getImage());
        MOBAC_ICONS.add(Utilities.loadResourceImageIcon("mobac32.png").getImage());
        MOBAC_ICONS.add(Utilities.loadResourceImageIcon("mobac16.png").getImage());
        sCustomFont = null;
    }

    private class MainWindowListener
    extends ComponentAdapter {
        private MainWindowListener() {
        }

        @Override
        public void componentResized(ComponentEvent event) {
            this.updateValues();
        }

        @Override
        public void componentMoved(ComponentEvent event) {
            this.updateValues();
        }

        private void updateValues() {
            if ((MainGUI.this.getExtendedState() & 6) != 0) {
                return;
            }
            Settings s = Settings.getInstance();
            s.mainWindow.size = MainGUI.this.getSize();
            s.mainWindow.position = MainGUI.this.getLocation();
        }
    }

    private class WindowDestroyer
    extends WindowAdapter {
        private WindowDestroyer() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainGUI.this.previewMap.setEnabled(true);
                }
            });
        }

        @Override
        public void windowClosing(WindowEvent event) {
            MainGUI.this.saveSettings();
        }
    }

    private class ZoomLevelCheckBoxListener
    implements ActionListener {
        private ZoomLevelCheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainGUI.this.calculateNrOfTilesToDownload();
        }
    }

    private class LoadProfileListener
    implements ActionListener {
        private LoadProfileListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Profile profile = MainGUI.this.profilesPanel.getSelectedProfile();
            MainGUI.this.profilesPanel.getDeleteButton().setEnabled(profile != null);
            if (profile == null) {
                return;
            }
            MainGUI.this.jAtlasTree.load(profile);
            MainGUI.this.previewMap.repaint();
            MainGUI.this.tileImageParametersPanel.atlasFormatChanged(MainGUI.this.jAtlasTree.getAtlas().getOutputFormat());
        }
    }

    private class MapSourceTreeListener
    implements TreeSelectionListener {
        private MapSourceTreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            MainGUI.this.mapSourceTree.selectClickedMapSource();
            MapSource selectedMapSource = MainGUI.this.mapSourceTree.getSelectedMapSource();
            if (selectedMapSource == null) {
                boolean wasFirstValidSourceSelected = MainGUI.this.mapSourceTree.selectFirstMapSource();
                if (!wasFirstValidSourceSelected) {
                    return;
                }
                selectedMapSource = MainGUI.this.mapSourceTree.getSelectedMapSource();
            }
            if (selectedMapSource instanceof InitializableMapSource) {
                try {
                    ((InitializableMapSource)selectedMapSource).initialize();
                }
                catch (MapSourceInitializationException e1) {
                    JOptionPane.showMessageDialog(null, I18nUtils.localizedStringForKey("msg_map_source_initialization_failed", selectedMapSource.toString(), e1.getLocalizedMessage()), I18nUtils.localizedStringForKey("Error", new Object[0]), 0);
                }
            }
            MainGUI.this.previewMap.setMapSource(selectedMapSource);
            MainGUI.this.zoomSlider.setMinimum(MainGUI.this.previewMap.getMapSource().getMinZoom());
            MainGUI.this.zoomSlider.setMaximum(MainGUI.this.previewMap.getMapSource().getMaxZoom());
            MainGUI.this.updateGridSizeCombo();
            MainGUI.this.updateZoomLevelCheckBoxes();
            MainGUI.this.calculateNrOfTilesToDownload();
        }
    }

    private class ApplySelectionButtonListener
    implements ActionListener {
        private ApplySelectionButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainGUI.this.setSelectionByEnteredCoordinates();
        }
    }

    private class GridZoomComboListener
    implements ActionListener {
        private GridZoomComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!MainGUI.this.gridZoomCombo.isEnabled()) {
                return;
            }
            GridZoom g = (GridZoom)MainGUI.this.gridZoomCombo.getSelectedItem();
            if (g == null) {
                return;
            }
            log.debug("Selected grid zoom combo box item has changed: " + g.getZoom());
            MainGUI.this.previewMap.setGridZoom(g.getZoom());
            MainGUI.this.repaint();
            MainGUI.this.previewMap.updateMapSelection();
        }
    }

    private class ZoomSliderListener
    implements ChangeListener {
        private ZoomSliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            MainGUI.this.previewMap.setZoom(MainGUI.this.zoomSlider.getValue());
        }
    }
}

