/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import mobac.gui.MainGUI;
import mobac.program.model.AtlasOutputFormat;
import mobac.utilities.I18nUtils;

public class AtlasNew
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent event) {
        MainGUI mg = MainGUI.getMainGUI();
        JPanel panel = new JPanel();
        BorderLayout layout = new BorderLayout();
        layout.setVgap(4);
        panel.setLayout(layout);
        JPanel formatPanel = new JPanel(new BorderLayout());
        formatPanel.add((Component)new JLabel(I18nUtils.localizedStringForKey("dlg_new_atlas_select_format_title", new Object[0])), "North");
        JList<AtlasOutputFormat> atlasFormatList = new JList<AtlasOutputFormat>(AtlasOutputFormat.getFormatsAsVector());
        atlasFormatList.setSelectionMode(0);
        JScrollPane scroller = new JScrollPane(atlasFormatList);
        scroller.setPreferredSize(new Dimension(140, 200));
        formatPanel.add((Component)scroller, "Center");
        JPanel namePanel = new JPanel(new BorderLayout());
        namePanel.add((Component)new JLabel(I18nUtils.localizedStringForKey("dlg_new_atlas_name_title", new Object[0])), "North");
        JTextField atlasName = new JTextField(I18nUtils.localizedStringForKey("dlg_new_atlas_default_atlas_name", new Object[0]));
        namePanel.add((Component)atlasName, "South");
        panel.add((Component)namePanel, "North");
        panel.add((Component)formatPanel, "Center");
        panel.setPreferredSize(new Dimension(300, 300));
        AtlasOutputFormat currentAOF = null;
        try {
            currentAOF = mg.getAtlas().getOutputFormat();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (currentAOF != null) {
            atlasFormatList.setSelectedValue(currentAOF, true);
        } else {
            atlasFormatList.setSelectedIndex(1);
        }
        int result = JOptionPane.showConfirmDialog(MainGUI.getMainGUI(), panel, I18nUtils.localizedStringForKey("dlg_new_atlas_title", new Object[0]), 2);
        if (result != 0) {
            return;
        }
        AtlasOutputFormat format = atlasFormatList.getSelectedValue();
        mg.jAtlasTree.newAtlas(atlasName.getText(), format);
        mg.getParametersPanel().atlasFormatChanged(format);
    }
}

