/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.actions;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import mobac.gui.MainGUI;
import mobac.program.Logging;
import mobac.utilities.GUIExceptionHandler;
import mobac.utilities.I18nUtils;
import org.apache.log4j.Logger;

public class DebugShowLogFile
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent event) {
        Logger log = Logger.getLogger(DebugShowLogFile.class);
        String logFile = Logging.getLogFile();
        if (logFile == null) {
            log.error("No file logger configured");
            JOptionPane.showMessageDialog(MainGUI.getMainGUI(), I18nUtils.localizedStringForKey("msg_no_log_file_config", new Object[0]), I18nUtils.localizedStringForKey("Error", new Object[0]), 0);
            return;
        }
        File f = new File(logFile);
        if (!f.isFile()) {
            log.error("Log file does not exists: " + f.getAbsolutePath());
            JOptionPane.showMessageDialog(MainGUI.getMainGUI(), String.format(I18nUtils.localizedStringForKey("msg_no_log_file", new Object[0]), f.getAbsolutePath()), I18nUtils.localizedStringForKey("Error", new Object[0]), 0);
            return;
        }
        try {
            Desktop.getDesktop().open(f);
        }
        catch (IOException e) {
            GUIExceptionHandler.processException(e);
        }
    }
}

