/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.actions;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import mobac.data.gpx.gpx11.WptType;
import mobac.gui.MainGUI;
import mobac.gui.actions.GpxEditor;
import mobac.gui.gpxtree.GpxEntry;
import mobac.gui.gpxtree.GpxRootEntry;
import mobac.gui.gpxtree.RteEntry;
import mobac.gui.gpxtree.TrkEntry;
import mobac.gui.gpxtree.TrksegEntry;
import mobac.gui.gpxtree.WptEntry;
import mobac.gui.mapview.PreviewMap;
import mobac.gui.mapview.controller.GpxMapController;
import mobac.utilities.I18nUtils;

public class GpxElementListener
implements MouseListener {
    public static final String MENU_NAME_RENAME = I18nUtils.localizedStringForKey("rp_gpx_menu_rename", new Object[0]);
    public static final String MENU_NAME_DELETE = I18nUtils.localizedStringForKey("rp_gpx_menu_delete", new Object[0]);
    private final GpxEntry gpxEntry;
    private GpxMapController mapController = null;
    private GpxEditor editor = GpxEditor.getInstance();

    public GpxElementListener(GpxEntry gpxEntry) {
        this.gpxEntry = gpxEntry;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.handleClick(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.handleClick(e);
    }

    private void handleClick(MouseEvent e) {
        JMenuItem item = (JMenuItem)e.getSource();
        if (item == null) {
            return;
        }
        if (MENU_NAME_RENAME.equals(item.getName())) {
            this.renameEntry();
        } else if (MENU_NAME_DELETE.equals(item.getName())) {
            this.removeEntry();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void removeEntry() {
        int answer = JOptionPane.showConfirmDialog(null, I18nUtils.localizedStringForKey("rp_gpx_msg_confim_delete", new Object[0]), I18nUtils.localizedStringForKey("rp_gpx_msg_confim_delete_title", new Object[0]), 0, 3);
        if (answer != 0) return;
        PreviewMap map = MainGUI.getMainGUI().previewMap;
        map.getMapSelectionController().disable();
        if (this.mapController == null) {
            this.mapController = new GpxMapController(map, this.gpxEntry.getLayer().getPanel(), false);
        }
        this.mapController.enable();
        if (this.gpxEntry.getClass().equals(RteEntry.class) || this.gpxEntry.getClass().equals(TrkEntry.class)) return;
        if (this.gpxEntry.getClass().equals(WptEntry.class)) {
            WptEntry wptEntry = (WptEntry)this.gpxEntry;
            WptType wpt = wptEntry.getWpt();
            this.editor.findWptAndDelete(wpt, this.gpxEntry);
            wptEntry.getLayer().getPanel().removeWpt(wptEntry);
            this.mapController.repaint();
            return;
        } else if (!this.gpxEntry.getClass().equals(GpxRootEntry.class)) return;
    }

    private void renameEntry() {
        if (this.gpxEntry.getClass().equals(TrksegEntry.class)) {
            JOptionPane.showMessageDialog(null, I18nUtils.localizedStringForKey("rp_gpx_msg_can_not_rename_track", new Object[0]), I18nUtils.localizedStringForKey("Error", new Object[0]), 1);
            return;
        }
        if (this.gpxEntry.getClass().equals(RteEntry.class)) {
            RteEntry rte = (RteEntry)this.gpxEntry;
            String name = JOptionPane.showInputDialog(null, I18nUtils.localizedStringForKey("rp_gpx_rename_element_title", new Object[0]), rte.getRte().getName());
            if (name == null) {
                return;
            }
            rte.getRte().setName(name);
        } else if (this.gpxEntry.getClass().equals(TrkEntry.class)) {
            TrkEntry trk = (TrkEntry)this.gpxEntry;
            String name = JOptionPane.showInputDialog(null, I18nUtils.localizedStringForKey("rp_gpx_rename_element_title", new Object[0]), trk.getTrk().getName());
            if (name == null) {
                return;
            }
            trk.getTrk().setName(name);
        } else if (this.gpxEntry.getClass().equals(WptEntry.class)) {
            WptEntry wpt = (WptEntry)this.gpxEntry;
            String name = JOptionPane.showInputDialog(null, I18nUtils.localizedStringForKey("rp_gpx_rename_element_title", new Object[0]), wpt.getWpt().getName());
            if (name == null) {
                return;
            }
            wpt.getWpt().setName(name);
        } else if (this.gpxEntry.getClass().equals(GpxRootEntry.class)) {
            GpxRootEntry root = (GpxRootEntry)this.gpxEntry;
            String initialValue = root.getMetaDataName();
            String name = JOptionPane.showInputDialog(null, I18nUtils.localizedStringForKey("rp_gpx_rename_element_title", new Object[0]), initialValue);
            if (name == null) {
                return;
            }
            root.setMetaDataName(name);
        }
    }
}

