/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.components;

import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import mobac.program.interfaces.MapSpace;
import mobac.program.model.UnitSystem;

public class JDistanceSlider
extends JSlider {
    private static final long serialVersionUID = 1L;
    private final Hashtable<Integer, JLabel> labelTable = new Hashtable();

    public JDistanceSlider(MapSpace mapSpace, int zoom, int y, UnitSystem unit, int pixelMin, int pixelMax) {
        super(pixelMin, pixelMax);
        int[] labelvalues;
        int diff4 = (pixelMax - pixelMin) / 4;
        for (int i : labelvalues = new int[]{pixelMin, pixelMin + diff4, pixelMin + 2 * diff4, pixelMin + 3 * diff4, pixelMax}) {
            double distance = mapSpace.horizontalDistance(zoom, y, i) * unit.earthRadius * (double)unit.unitFactor;
            String label = distance > (double)unit.unitFactor ? String.format("%2.0f %s", distance /= (double)unit.unitFactor, unit.unitLarge) : String.format("%2.0f %s", distance, unit.unitSmall);
            this.labelTable.put(new Integer(i), new JLabel(label));
        }
        this.setPaintTicks(true);
        this.setMajorTickSpacing(diff4);
        this.setLabelTable(this.labelTable);
        this.setPaintLabels(true);
    }
}

