/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import mobac.mapsources.AbstractMultiLayerMapSource;
import mobac.program.interfaces.FileBasedMapSource;
import mobac.program.interfaces.HttpMapSource;
import mobac.program.interfaces.MapSource;
import mobac.program.model.MapSourceLoaderInfo;
import mobac.utilities.I18nUtils;
import mobac.utilities.Utilities;
import org.apache.commons.lang3.StringEscapeUtils;

public class JMapSourceTree
extends JTree {
    private static final long serialVersionUID = 1L;
    static final Class<String> folderClass = String.class;
    private static Color mapSourceInTreeHighlightColor = new Color(230, 245, 255);
    private Vector<MapSource> mapSources;
    private MapSource selectedMapSource;
    private MapSource previouslySelectedMapSource;
    private ComparableTreeNode rootNode = new ComparableTreeNode("Maps sources root");
    private DefaultTreeModel treeModel = new DefaultTreeModel(this.rootNode);

    public JMapSourceTree(Vector<MapSource> enabledOrderedMapSources) {
        this.setCellRenderer(new CustomIconRenderer());
        this.initialize(enabledOrderedMapSources);
        this.setRootVisible(false);
        this.getSelectionModel().setSelectionMode(1);
        this.setExpandsSelectedPaths(true);
        this.setToggleClickCount(1);
        this.setToolTipText(I18nUtils.localizedStringForKey("lp_map_source_tree_tips", new Object[0]));
    }

    public void initialize(Vector<MapSource> enabledOrderedMapSources) {
        this.mapSources = enabledOrderedMapSources;
        this.resetTree();
        this.generateTreeModel();
        super.setModel(this.treeModel);
    }

    private void addChildBasedOnFolderPath(MapSource mapSource) {
        MapSourceLoaderInfo loaderInfo = mapSource.getLoaderInfo();
        String[] folderPath = null;
        if (loaderInfo != null) {
            folderPath = loaderInfo.getRelativePath();
        }
        ComparableTreeNode parent = this.rootNode;
        if (folderPath != null) {
            for (String folderPathElementName : folderPath) {
                ComparableTreeNode folderPathElement = null;
                ComparableTreeNode childFound = JMapSourceTree.getChildByUserObject(parent, folderPathElementName);
                if (childFound != null) {
                    folderPathElement = childFound;
                } else {
                    folderPathElement = new ComparableTreeNode(folderPathElementName);
                    this.insertInRightOrder(parent, folderPathElement);
                }
                parent = folderPathElement;
            }
        }
        ComparableTreeNode newLeaf = new ComparableTreeNode(mapSource);
        this.insertInRightOrder(parent, newLeaf);
    }

    private void resetTree() {
        this.setModel(null);
        this.rootNode.removeAllChildren();
    }

    private void insertInRightOrder(ComparableTreeNode parentNode, ComparableTreeNode insertedNode) {
        int parentChildCount = this.treeModel.getChildCount(parentNode);
        int insertIndex = 0;
        if (parentChildCount != 0) {
            ComparableTreeNode child;
            insertIndex = parentChildCount;
            int i = parentChildCount - 1;
            while (i >= 0 && insertedNode.compareTo(child = (ComparableTreeNode)this.treeModel.getChild(parentNode, i)) <= 0) {
                insertIndex = i--;
            }
        }
        this.treeModel.insertNodeInto(insertedNode, parentNode, insertIndex);
    }

    private static ComparableTreeNode getChildByUserObject(ComparableTreeNode parentNode, String nodeName) {
        Enumeration<TreeNode> childsOfParent = parentNode.breadthFirstEnumeration();
        while (childsOfParent.hasMoreElements()) {
            ComparableTreeNode child = (ComparableTreeNode)childsOfParent.nextElement();
            if (!child.getUserObject().equals(nodeName)) continue;
            return child;
        }
        return null;
    }

    private void generateTreeModel() {
        for (MapSource mapSource : this.mapSources) {
            this.addChildBasedOnFolderPath(mapSource);
        }
    }

    private int getMapSourceIndexByName(String mapSourceName) {
        for (int i = 0; i < this.mapSources.size(); ++i) {
            MapSource mapSource = this.mapSources.get(i);
            String mapSourceAsString = mapSource.toString();
            if (!mapSourceAsString.equals(mapSourceName)) continue;
            return i;
        }
        return -1;
    }

    private MapSource getMapSourceByName(String mapSourceName) {
        int mapSourceIndex = this.getMapSourceIndexByName(mapSourceName);
        if (mapSourceIndex == -1) {
            return null;
        }
        return this.mapSources.get(mapSourceIndex);
    }

    private TreePath findTreePathOfMapSource(MapSource mapSource) {
        Enumeration<TreeNode> rootDescendants = this.rootNode.depthFirstEnumeration();
        while (rootDescendants.hasMoreElements()) {
            ComparableTreeNode descendantNode = (ComparableTreeNode)rootDescendants.nextElement();
            if (!descendantNode.getUserObject().equals(mapSource)) continue;
            return new TreePath(descendantNode.getPath());
        }
        return null;
    }

    public boolean selectMapSource(MapSource mapSourceToSelect) {
        int foundMapSourceIndex = this.mapSources.indexOf(mapSourceToSelect);
        if (foundMapSourceIndex != -1) {
            this.previouslySelectedMapSource = this.selectedMapSource;
            this.selectedMapSource = mapSourceToSelect;
            this.chooseAndShowTreeNodeInTree(mapSourceToSelect);
            return true;
        }
        return false;
    }

    private void chooseAndShowTreeNodeInTree(MapSource mapSourceToSelect) {
        TreePath pathFound = this.findTreePathOfMapSource(mapSourceToSelect);
        if (pathFound != null) {
            this.expandPath(pathFound.getParentPath());
            this.setSelectionPath(pathFound);
            this.scrollPathToVisibleVerticalOnly(pathFound);
            ((DefaultTreeModel)this.getModel()).nodeChanged((TreeNode)pathFound.getLastPathComponent());
        }
    }

    private void scrollPathToVisibleVerticalOnly(TreePath treePath) {
        if (treePath != null) {
            this.makeVisible(treePath);
            Rectangle pathBounds = this.getPathBounds(treePath);
            if (pathBounds != null) {
                pathBounds.x = 0;
                this.scrollRectToVisible(pathBounds);
            }
        }
    }

    public boolean selectClickedMapSource() {
        if (this.getSelectionPath() != null) {
            String selectedTreeElement = this.getSelectionPath().getLastPathComponent().toString();
            MapSource foundMapSource = this.getMapSourceByName(selectedTreeElement);
            if (foundMapSource == null) {
                this.setSelectionPath(this.findTreePathOfMapSource(this.previouslySelectedMapSource));
            } else {
                return this.selectMapSource(foundMapSource);
            }
        }
        return false;
    }

    public MapSource getSelectedMapSource() {
        return this.selectedMapSource;
    }

    public boolean selectNextMapSource() {
        if (this.mapSources.lastElement().equals(this.selectedMapSource)) {
            return false;
        }
        int indexOfSelectedMapSource = this.mapSources.indexOf(this.selectedMapSource);
        return this.selectMapSource(this.mapSources.get(indexOfSelectedMapSource + 1));
    }

    public boolean selectPreviousMapSource() {
        if (this.mapSources.firstElement().equals(this.selectedMapSource)) {
            return false;
        }
        int indexOfSelectedMapSource = this.mapSources.indexOf(this.selectedMapSource);
        return this.selectMapSource(this.mapSources.get(indexOfSelectedMapSource - 1));
    }

    public boolean selectFirstMapSource() {
        return this.selectMapSource(this.mapSources.get(0));
    }

    public int getMapSourcesCount() {
        return this.mapSources.size();
    }

    public boolean isLocationClickable(Point eventPoint) {
        int y;
        int x = (int)eventPoint.getX();
        TreePath treePathForXY = this.getPathForLocation(x, y = (int)eventPoint.getY());
        if (treePathForXY != null && treePathForXY.isDescendant(this.findTreePathOfMapSource(this.selectedMapSource))) {
            return false;
        }
        boolean isInside = false;
        if (treePathForXY != null) {
            Rectangle pathBounds = this.getPathBounds(treePathForXY);
            isInside = pathBounds.contains(eventPoint);
        }
        return isInside;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.getRowForLocation(event.getX(), event.getY()) == -1) {
            return "";
        }
        TreePath curPath = this.getPathForLocation(event.getX(), event.getY());
        Object lastPathComponent = curPath.getLastPathComponent();
        if (lastPathComponent == null) {
            return null;
        }
        Object userObject = ((ComparableTreeNode)lastPathComponent).getUserObject();
        if (userObject.getClass().equals(folderClass)) {
            return null;
        }
        return JMapSourceTree.generateMapSourceTooltip((MapSource)userObject);
    }

    public static String generateMapSourceTooltip(MapSource mapSource) {
        boolean multiLayer = mapSource instanceof AbstractMultiLayerMapSource;
        boolean fileBased = mapSource instanceof FileBasedMapSource;
        String locName = I18nUtils.localizedStringForKey("lp_map_source_tooltip_layer_name", new Object[0]);
        String locInternalName = I18nUtils.localizedStringForKey("lp_map_source_tooltip_inernal_name", new Object[0]);
        String locType = I18nUtils.localizedStringForKey("lp_map_source_tooltip_type", new Object[0]);
        String locLoadedFrom = I18nUtils.localizedStringForKey("lp_map_source_tooltip_loaded_from", new Object[0]);
        String locFileName = I18nUtils.localizedStringForKey("lp_map_source_tooltip_file_name", new Object[0]);
        String locMultiLayer = I18nUtils.localizedStringForKey("lp_map_source_layer_multi", new Object[0]);
        String locSingleLayer = I18nUtils.localizedStringForKey("lp_map_source_layer_single", new Object[0]);
        String locFileBased = I18nUtils.localizedStringForKey("lp_map_source_layer_file_based", new Object[0]);
        String locWebBased = I18nUtils.localizedStringForKey("lp_map_source_layer_web_based", new Object[0]);
        String name = StringEscapeUtils.escapeHtml4(mapSource.toString());
        String nameInternal = StringEscapeUtils.escapeHtml4(mapSource.getName());
        String type1 = multiLayer ? locMultiLayer : locSingleLayer;
        String type2 = fileBased ? locFileBased : locWebBased;
        String toolTipString = locName + ": <b>%s</b><br>" + locInternalName + ": %s<br>" + locType + ": %s (%s)";
        toolTipString = String.format(toolTipString, name, nameInternal, type1, type2);
        MapSourceLoaderInfo info = mapSource.getLoaderInfo();
        if (info != null) {
            toolTipString = toolTipString + "<br>" + locLoadedFrom + ": " + info.getLoaderType().displayName;
            File f = info.getSourceFile();
            if (f != null) {
                toolTipString = toolTipString + "<br>" + locFileName + ": <tt>" + StringEscapeUtils.escapeHtml4(f.getName()) + "</tt>";
            }
        }
        return "<html>" + toolTipString + "</html>";
    }

    static class CustomIconRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        private ImageIcon multiLayerIcon = new ImageIcon(Utilities.getResourceImageUrl("icon_multilayer_ms.png"));
        private ImageIcon fileBasedIcon = new ImageIcon(Utilities.getResourceImageUrl("icon_filebased_ms.png"));
        private ImageIcon httpIcon = new ImageIcon(Utilities.getResourceImageUrl("icon_http_ms.png"));
        private ImageIcon debugIcon = new ImageIcon(Utilities.getResourceImageUrl("icon_debug_ms.png"));
        private ImageIcon folderOpenedIcon = new ImageIcon(Utilities.getResourceImageUrl("icon_folder_opened.png"));
        private ImageIcon folderClosedIcon = new ImageIcon(Utilities.getResourceImageUrl("icon_folder_closed.png"));

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            this.setTextSelectionColor(this.getTextNonSelectionColor());
            this.setBorderSelectionColor(null);
            if (selected) {
                this.setFont(this.getFont().deriveFont(1));
                this.setBackgroundSelectionColor(mapSourceInTreeHighlightColor);
            } else {
                this.setFont(this.getFont().deriveFont(0));
                this.setBackgroundSelectionColor(null);
            }
            this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            this.setOpenIcon(this.folderOpenedIcon);
            this.setClosedIcon(this.folderClosedIcon);
            Object treeNodeObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (treeNodeObject instanceof AbstractMultiLayerMapSource) {
                this.setIcon(this.multiLayerIcon);
            } else if (treeNodeObject instanceof FileBasedMapSource) {
                this.setIcon(this.fileBasedIcon);
            } else if (treeNodeObject instanceof HttpMapSource) {
                this.setIcon(this.httpIcon);
            } else if (treeNodeObject instanceof MapSource) {
                this.setIcon(this.debugIcon);
            }
            return this;
        }
    }

    class ComparableTreeNode
    extends DefaultMutableTreeNode
    implements Comparable<DefaultMutableTreeNode> {
        private static final long serialVersionUID = 1L;

        public ComparableTreeNode(MapSource mapSource) {
            super(mapSource);
        }

        public ComparableTreeNode(String string) {
            super(string);
        }

        @Override
        public int compareTo(DefaultMutableTreeNode treeNode) {
            Class<?> thisObjectClass = this.getUserObject().getClass();
            Class<?> comparedObjectClass = treeNode.getUserObject().getClass();
            if (thisObjectClass.equals(folderClass) != comparedObjectClass.equals(folderClass)) {
                return thisObjectClass.equals(folderClass) ? -1 : 1;
            }
            return this.toString().compareToIgnoreCase(treeNode.toString());
        }
    }
}

