/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import mobac.gui.MainGUI;
import mobac.program.ProgramInfo;
import mobac.utilities.GBC;
import mobac.utilities.I18nUtils;
import mobac.utilities.Utilities;

public class AboutDialog
extends JDialog
implements MouseListener {
    public AboutDialog() throws HeadlessException {
        super((Frame)MainGUI.getMainGUI(), I18nUtils.localizedStringForKey("dlg_about_title", new Object[0]));
        this.setIconImages(MainGUI.MOBAC_ICONS);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        JPanel panel = new JPanel(null);
        panel.setBackground(Color.WHITE);
        GBC std = GBC.std();
        GBC eol = GBC.eol();
        std.insets(3, 3, 3, 3);
        eol.insets(3, 3, 3, 3);
        ImageIcon splash = Utilities.loadResourceImageIcon("Splash.jpg");
        Dimension size = new Dimension(splash.getIconWidth(), splash.getIconHeight());
        panel.setPreferredSize(size);
        panel.setMinimumSize(size);
        panel.setMaximumSize(size);
        panel.setSize(size);
        JLabel splashLabel = new JLabel(splash);
        JPanel infoPanel = new JPanel(new GridBagLayout());
        infoPanel.setBackground(Color.WHITE);
        infoPanel.setOpaque(false);
        infoPanel.add((Component)new JLabel(I18nUtils.localizedStringForKey("dlg_about_version", new Object[0])), std);
        infoPanel.add((Component)new JLabel(ProgramInfo.getVersion()), eol);
        infoPanel.add((Component)new JLabel(I18nUtils.localizedStringForKey("dlg_about_program_version", new Object[0])), std);
        infoPanel.add((Component)new JLabel(ProgramInfo.getRevisionStr()), eol);
        panel.add(infoPanel);
        panel.add(splashLabel);
        infoPanel.setBounds(200, 155, 320, 200);
        splashLabel.setBounds(0, 0, splash.getIconWidth(), splash.getIconHeight());
        this.add(panel);
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dim.width - this.getWidth()) / 2, (dim.height - this.getHeight()) / 2);
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.setVisible(false);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            ProgramInfo.initialize();
            AboutDialog dlg = new AboutDialog();
            dlg.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

