/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import mobac.gui.MainGUI;
import mobac.utilities.GBC;
import mobac.utilities.I18nUtils;

public class Help
extends JFrame
implements WindowListener {
    private static Help INSTANCE = null;

    public static synchronized void showHelp() {
        if (INSTANCE == null) {
            INSTANCE = new Help();
        }
        INSTANCE.setVisible(true);
    }

    public Help() throws HeadlessException {
        super(I18nUtils.localizedStringForKey("dlg_help_title", new Object[0]));
        this.setIconImages(MainGUI.MOBAC_ICONS);
        this.setLayout(new GridBagLayout());
        JLabel text = new JLabel();
        JButton closeButton = new JButton(I18nUtils.localizedStringForKey("Close", new Object[0]));
        closeButton.setDefaultCapable(true);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Help.this.setVisible(false);
                Help.this.dispose();
            }
        });
        DataInputStream in = new DataInputStream(I18nUtils.getI18nResourceAsStream("resources/text/help_dialog", "html"));
        try {
            byte[] buf = new byte[in.available()];
            in.readFully(buf);
            in.close();
            String helpMessage = new String(buf, StandardCharsets.UTF_8);
            text.setText(helpMessage);
        }
        catch (IOException helpMessage) {
            // empty catch block
        }
        this.add((Component)text, GBC.eol().insets(10, 10, 10, 10));
        this.add((Component)closeButton, GBC.eol().anchor(10).insets(0, 0, 0, 10));
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dim.width - this.getWidth()) / 2, (dim.height - this.getHeight()) / 2);
        this.setAlwaysOnTop(true);
        this.setResizable(false);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        INSTANCE = null;
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

