/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mobac.gui.MainGUI;
import mobac.program.ProgramInfo;
import mobac.utilities.GBC;
import mobac.utilities.I18nUtils;
import mobac.utilities.Utilities;

public class LicensesDialog
extends JFrame
implements ChangeListener,
ActionListener {
    private LicenseInfo[] licenses = new LicenseInfo[]{new LicenseInfo("<h2>Mobile Atlas Creator</h2>", "gpl.txt"), new LicenseInfo("<h3>Library Apache Log4J</h3>", "apache-2.0.txt"), new LicenseInfo("<h3>Library Apache Commons Codec</h3>", "apache-2.0.txt"), new LicenseInfo("<h3>Library Apache Commons IO</h3>", "apache-2.0.txt"), new LicenseInfo("<h3>Library Berkely-DB JavaEdition</h3>", "license-dbd-je.txt"), new LicenseInfo("<h3>Library BeanShell</h3>", "lgpl-3.0.txt"), new LicenseInfo("<h3>Library JavaPNG</h3>", "gpl.txt"), new LicenseInfo("<h3>Library iTextPDF</h3>", "agpl.txt"), new LicenseInfo("<h3>mapsforge</h3>", "lgpl-3.0.txt"), new LicenseInfo("<h3>Silk Icons</h3>", "cc-attribution-2.5.txt")};
    private final JTextArea textArea;
    private final JTabbedPane tab;
    private String currentLicense = null;

    public LicensesDialog() {
        super(I18nUtils.localizedStringForKey("dlg_license_title", new Object[0]));
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLayout(new GridBagLayout());
        this.setIconImages(MainGUI.MOBAC_ICONS);
        this.setDefaultCloseOperation(2);
        JButton ok = new JButton("OK");
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setBackground(this.getBackground());
        JScrollPane textScroller = new JScrollPane(this.textArea);
        textScroller.setPreferredSize(new Dimension(700, (int)((double)dim.height * 0.8)));
        this.tab = new JTabbedPane(2, 0);
        ImageIcon icon = new ImageIcon(new BufferedImage(1, 50, 2));
        boolean first = true;
        for (LicenseInfo li : this.licenses) {
            this.tab.addTab("<html>" + li.name + "</html>", icon, first ? textScroller : null);
            first = false;
        }
        this.tab.addChangeListener(this);
        this.stateChanged(null);
        this.add((Component)this.tab, GBC.eol().anchor(11).fill());
        this.add((Component)ok, GBC.eol().anchor(10).insets(5, 10, 10, 10));
        ok.addActionListener(this);
        this.pack();
        this.setLocation((dim.width - this.getWidth()) / 2, (dim.height - this.getHeight()) / 2);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        String license;
        try {
            String nextLicense = this.licenses[this.tab.getSelectedIndex()].licenseResource;
            if (nextLicense.equals(this.currentLicense)) {
                return;
            }
            license = Utilities.loadTextResource("text/" + nextLicense);
            this.currentLicense = nextLicense;
        }
        catch (IOException e) {
            license = "Failed to load license: " + e.getMessage();
        }
        this.textArea.setText(license);
        this.textArea.setCaretPosition(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            ProgramInfo.initialize();
            LicensesDialog dlg = new LicensesDialog();
            dlg.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class LicenseInfo {
        public final String name;
        public final String licenseResource;

        public LicenseInfo(String name, String licenseResource) {
            this.name = name;
            this.licenseResource = licenseResource;
        }
    }
}

