/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.dialogs;

import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import mobac.program.tilestore.berkeleydb.DelayedInterruptThread;
import mobac.utilities.I18nUtils;
import mobac.utilities.Utilities;
import org.apache.log4j.Logger;

public class WorkinprogressDialog
extends JDialog
implements WindowListener {
    private static final Logger log = Logger.getLogger(WorkinprogressDialog.class);
    private final ThreadFactory threadFactory;
    private Thread workerThread;

    public WorkinprogressDialog(Frame owner, String title) {
        this(owner, title, Executors.defaultThreadFactory());
    }

    public WorkinprogressDialog(Frame owner, String title, ThreadFactory threadFactory) {
        super(owner, title, true);
        this.threadFactory = threadFactory;
        this.setLayout(new FlowLayout());
        this.add(new JLabel(new ImageIcon(Utilities.getResourceImageUrl("ajax-loader.gif"))));
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(owner);
        this.addWindowListener(this);
        JButton abort = new JButton(I18nUtils.localizedStringForKey("Abort", new Object[0]));
        abort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                log.debug("User interrupted process");
                WorkinprogressDialog.this.close();
            }
        });
        this.add(abort);
        this.pack();
    }

    public void startWork(final Runnable r) {
        this.workerThread = this.threadFactory.newThread(new Runnable(){

            @Override
            public void run() {
                try {
                    r.run();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), e);
                }
                finally {
                    WorkinprogressDialog.this.close();
                    log.debug("Worker thread finished");
                }
            }
        });
        Thread t1 = new Thread(){

            @Override
            public void run() {
                WorkinprogressDialog.this.setVisible(true);
            }
        };
        t1.start();
    }

    protected synchronized void abortWorking() {
        try {
            if (this.workerThread != null && !this.workerThread.isInterrupted()) {
                log.debug("User aborted process - interrupting worker thread");
                this.workerThread.interrupt();
                this.workerThread = null;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public void close() {
        this.abortWorking();
        this.setVisible(false);
    }

    @Override
    public void windowActivated(WindowEvent event) {
    }

    @Override
    public void windowOpened(WindowEvent event) {
        this.workerThread.start();
    }

    @Override
    public void windowClosed(WindowEvent event) {
        this.abortWorking();
    }

    @Override
    public void windowClosing(WindowEvent event) {
    }

    @Override
    public void windowDeactivated(WindowEvent event) {
    }

    @Override
    public void windowDeiconified(WindowEvent event) {
    }

    @Override
    public void windowIconified(WindowEvent event) {
    }

    public static void main(String[] args) {
        JFrame parentFrame = new JFrame();
        parentFrame.setSize(500, 150);
        final JLabel jl = new JLabel();
        jl.setText(I18nUtils.localizedStringForKey("dlg_progress_count", new Object[0]));
        parentFrame.add("Center", jl);
        parentFrame.setDefaultCloseOperation(3);
        parentFrame.setVisible(true);
        final WorkinprogressDialog dlg = new WorkinprogressDialog((Frame)parentFrame, I18nUtils.localizedStringForKey("dlg_progress_title", new Object[0]), DelayedInterruptThread.createThreadFactory());
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    for (int i = 0; i <= 500; ++i) {
                        jl.setText(String.format(I18nUtils.localizedStringForKey("dlg_progress_count_i", new Object[0]), i));
                        if (Thread.currentThread().isInterrupted()) {
                            System.out.println("Aborted");
                            return;
                        }
                        Thread.sleep(25L);
                    }
                }
                catch (InterruptedException e) {
                    System.out.println("Aborted");
                    return;
                }
                finally {
                    dlg.setVisible(false);
                }
            }
        };
        dlg.startWork(t);
    }
}

