/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import mobac.program.interfaces.MapSourceCallerThreadInfo;
import mobac.program.tilestore.berkeleydb.DelayedInterruptThread;
import org.apache.log4j.Logger;

public class JobDispatcher
implements ThreadFactory,
RejectedExecutionHandler {
    private static final Logger log = Logger.getLogger(JobDispatcher.class);
    private static final JobDispatcher INSTANCE = new JobDispatcher();
    private static final int WORKER_THREAD_MAX_COUNT = 5;
    private static final int WORKER_THREAD_TIMEOUT = 30;
    private int WORKER_THREAD_ID = 1;
    private final BlockingQueue<Runnable> jobQueue = new LinkedBlockingQueue<Runnable>();
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(5, 5, 30L, TimeUnit.SECONDS, this.jobQueue, this, this);

    public static JobDispatcher getInstance() {
        return INSTANCE;
    }

    public void cancelOutstandingJobs() {
        this.jobQueue.clear();
    }

    private JobDispatcher() {
        this.executor.allowCoreThreadTimeOut(true);
    }

    public void addJob(Runnable job) {
        this.executor.execute(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Thread newThread(Runnable r) {
        int id;
        JobDispatcher jobDispatcher = this;
        synchronized (jobDispatcher) {
            id = this.WORKER_THREAD_ID++;
        }
        log.trace("New map preview worker thread created with id=" + id);
        return new MapPreviewThread(r, "Map preview thread " + id);
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        log.error("Map preview job rejected: " + r);
    }

    public class MapPreviewThread
    extends DelayedInterruptThread
    implements MapSourceCallerThreadInfo {
        public MapPreviewThread(Runnable target, String name) {
            super(target, name);
        }

        @Override
        public boolean isMapPreviewThread() {
            return true;
        }
    }
}

