/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.Hashtable;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationListener;
import mobac.gui.mapview.Tile;
import mobac.program.interfaces.MapSource;
import org.apache.log4j.Logger;

public class MemoryTileCache
implements NotificationListener {
    protected final Logger log = Logger.getLogger(this.getClass());
    protected int cacheSize = 500;
    protected Hashtable<String, CacheEntry> hashtable = new Hashtable(this.cacheSize);
    protected CacheLinkedListElement lruTiles = new CacheLinkedListElement();

    public MemoryTileCache() {
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        NotificationBroadcaster emitter = (NotificationBroadcaster)((Object)mbean);
        emitter.addNotificationListener(this, null, null);
        for (MemoryPoolMXBean memPool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!memPool.isUsageThresholdSupported()) continue;
            MemoryUsage memUsage = memPool.getUsage();
            memPool.setUsageThreshold((long)((double)memUsage.getMax() * 0.95));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notification, Object handback) {
        this.log.trace("Memory notification: " + notification.toString());
        if (!"java.management.memory.threshold.exceeded".equals(notification.getType())) {
            return;
        }
        CacheLinkedListElement cacheLinkedListElement = this.lruTiles;
        synchronized (cacheLinkedListElement) {
            int count_half = this.lruTiles.getElementCount() / 2;
            count_half = Math.max(25, count_half);
            if (this.lruTiles.getElementCount() <= count_half) {
                return;
            }
            this.log.warn("memory low - freeing cached tiles: " + this.lruTiles.getElementCount() + " -> " + count_half);
            try {
                while (this.lruTiles.getElementCount() > count_half) {
                    this.removeEntry(this.lruTiles.getLastElement());
                }
            }
            catch (Exception e) {
                this.log.error("", e);
            }
        }
    }

    public void addTile(Tile tile) {
        CacheEntry entry = this.createCacheEntry(tile);
        this.hashtable.put(tile.getKey(), entry);
        this.lruTiles.addFirst(entry);
        if (this.hashtable.size() > this.cacheSize) {
            this.removeOldEntries();
        }
    }

    public Tile getTile(MapSource source, int x, int y, int z) {
        CacheEntry entry = this.hashtable.get(Tile.getTileKey(source, x, y, z));
        if (entry == null) {
            return null;
        }
        if (entry.tile.getTileState() == Tile.TileState.TS_LOADED) {
            this.lruTiles.moveElementToFirstPos(entry);
        }
        return entry.tile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeOldEntries() {
        CacheLinkedListElement cacheLinkedListElement = this.lruTiles;
        synchronized (cacheLinkedListElement) {
            try {
                while (this.lruTiles.getElementCount() > this.cacheSize) {
                    this.removeEntry(this.lruTiles.getLastElement());
                }
            }
            catch (Exception e) {
                this.log.warn("", e);
            }
        }
    }

    protected void removeEntry(CacheEntry entry) {
        this.hashtable.remove(entry.tile.getKey());
        this.lruTiles.removeEntry(entry);
    }

    protected CacheEntry createCacheEntry(Tile tile) {
        return new CacheEntry(tile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CacheLinkedListElement cacheLinkedListElement = this.lruTiles;
        synchronized (cacheLinkedListElement) {
            this.hashtable.clear();
            this.lruTiles.clear();
        }
    }

    public int getTileCount() {
        return this.hashtable.size();
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        if (this.hashtable.size() > cacheSize) {
            this.removeOldEntries();
        }
    }

    protected static class CacheLinkedListElement {
        protected CacheEntry firstElement = null;
        protected CacheEntry lastElement;
        protected int elementCount;

        public CacheLinkedListElement() {
            this.clear();
        }

        public synchronized void clear() {
            this.elementCount = 0;
            this.firstElement = null;
            this.lastElement = null;
        }

        public synchronized void addFirst(CacheEntry element) {
            if (this.elementCount == 0) {
                this.firstElement = element;
                this.lastElement = element;
                element.prev = null;
                element.next = null;
            } else {
                element.next = this.firstElement;
                this.firstElement.prev = element;
                element.prev = null;
                this.firstElement = element;
            }
            ++this.elementCount;
        }

        public synchronized void removeEntry(CacheEntry element) {
            if (element.next != null) {
                element.next.prev = element.prev;
            }
            if (element.prev != null) {
                element.prev.next = element.next;
            }
            if (element == this.firstElement) {
                this.firstElement = element.next;
            }
            if (element == this.lastElement) {
                this.lastElement = element.prev;
            }
            element.next = null;
            element.prev = null;
            --this.elementCount;
        }

        public synchronized void moveElementToFirstPos(CacheEntry entry) {
            if (this.firstElement == entry) {
                return;
            }
            this.removeEntry(entry);
            this.addFirst(entry);
        }

        public int getElementCount() {
            return this.elementCount;
        }

        public CacheEntry getLastElement() {
            return this.lastElement;
        }

        public CacheEntry getFirstElement() {
            return this.firstElement;
        }
    }

    protected static class CacheEntry {
        Tile tile;
        CacheEntry next;
        CacheEntry prev;

        protected CacheEntry(Tile tile) {
            this.tile = tile;
        }

        public Tile getTile() {
            return this.tile;
        }

        public CacheEntry getNext() {
            return this.next;
        }

        public CacheEntry getPrev() {
            return this.prev;
        }
    }
}

