/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import mobac.gui.mapview.JMapViewer;
import mobac.gui.mapview.ScaleBar;
import mobac.gui.mapview.WgsGrid;
import mobac.gui.mapview.controller.DefaultMapController;
import mobac.gui.mapview.controller.JMapController;
import mobac.gui.mapview.controller.MapKeyboardController;
import mobac.gui.mapview.controller.RectangleSelectionMapController;
import mobac.gui.mapview.interfaces.MapEventListener;
import mobac.mapsources.MapSourcesManager;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSourceTextAttribution;
import mobac.program.interfaces.MapSpace;
import mobac.program.interfaces.RefreshableMapSource;
import mobac.program.model.Bookmark;
import mobac.program.model.EastNorthCoordinate;
import mobac.program.model.MapSelection;
import mobac.program.model.MercatorPixelCoordinate;
import mobac.program.model.Settings;
import mobac.utilities.I18nUtils;
import mobac.utilities.MyMath;
import org.apache.log4j.Logger;

public class PreviewMap
extends JMapViewer {
    private static final long serialVersionUID = 1L;
    public static final Color GRID_COLOR = new Color(200, 20, 20, 130);
    public static final Color SEL_COLOR = new Color(0.9f, 0.7f, 0.7f, 0.6f);
    public static final Color MAP_COLOR = new Color(1.0f, 0.84f, 0.0f, 0.4f);
    public static final int MAP_CONTROLLER_RECTANGLE_SELECT = 0;
    public static final int MAP_CONTROLLER_GPX = 1;
    protected static final Font LOADING_FONT = new Font("Sans Serif", 1, 30);
    private static Logger log = Logger.getLogger(PreviewMap.class);
    private Point iSelectionMin;
    private Point iSelectionMax;
    private Point gridSelectionStart;
    private Point gridSelectionEnd;
    private BufferedImage gridTile = new BufferedImage(256, 256, 2);
    private int gridZoom = -1;
    private int gridSize;
    protected LinkedList<MapEventListener> mapEventListeners = new LinkedList();
    protected JMapController mapKeyboardController;
    protected JMapController mapSelectionController;
    protected DefaultMapController defaultMapController;
    private final WgsGrid wgsGrid;

    public PreviewMap() {
        super(MapSourcesManager.getInstance().getDefaultMapSource(), 5);
        this.wgsGrid = new WgsGrid(Settings.getInstance().wgsGrid, this);
        this.setEnabled(false);
        this.defaultMapController = new DefaultMapController(this);
        this.mapMarkersVisible = false;
        this.setZoomContolsVisible(false);
        this.mapKeyboardController = new MapKeyboardController(this, true);
        this.setMapSelectionController(new RectangleSelectionMapController(this));
    }

    public void setDisplayPositionByLatLon(EastNorthCoordinate c, int zoom) {
        this.setDisplayPositionByLatLon(new Point(this.getWidth() / 2, this.getHeight() / 2), c.lat, c.lon, zoom);
    }

    public void settingsSave() {
        Settings settings = Settings.getInstance();
        settings.mapviewZoom = this.getZoom();
        settings.mapviewCenterCoordinate = this.getCenterCoordinate();
        settings.mapviewGridZoom = this.gridZoom;
        settings.mapviewMapSource = this.mapSource.getName();
        settings.mapviewSelectionMin = this.iSelectionMin;
        settings.mapviewSelectionMax = this.iSelectionMax;
    }

    public void settingsLoad() {
        Settings settings = Settings.getInstance();
        MapSource mapSource = MapSourcesManager.getInstance().getSourceByName(settings.mapviewMapSource);
        if (mapSource != null) {
            this.setMapSource(mapSource);
        }
        EastNorthCoordinate c = settings.mapviewCenterCoordinate;
        this.gridZoom = settings.mapviewGridZoom;
        this.setDisplayPositionByLatLon(c, settings.mapviewZoom);
        this.setSelectionByTileCoordinate(22, settings.mapviewSelectionMin, settings.mapviewSelectionMax, true);
    }

    @Override
    public void setMapSource(MapSource newMapSource) {
        if (newMapSource == null || newMapSource.equals(this.mapSource)) {
            return;
        }
        log.trace("Preview map source changed from " + this.mapSource + " to " + newMapSource);
        super.setMapSource(newMapSource);
        if (this.mapEventListeners == null) {
            return;
        }
        for (MapEventListener listener : this.mapEventListeners) {
            listener.mapSourceChanged(this.mapSource);
        }
    }

    @Override
    protected void zoomChanged(int oldZoom) {
        log.trace("Preview map zoom changed from " + oldZoom + " to " + this.zoom);
        if (this.mapEventListeners != null) {
            for (MapEventListener listener : this.mapEventListeners) {
                listener.zoomChanged(this.zoom);
            }
        }
        this.updateGridValues();
    }

    public void setGridZoom(int gridZoom) {
        if (gridZoom == this.gridZoom) {
            return;
        }
        this.gridZoom = gridZoom;
        this.updateGridValues();
        this.applyGridOnSelection();
        this.updateMapSelection();
        this.repaint();
    }

    public int getGridZoom() {
        return this.gridZoom;
    }

    protected void updateGridValues() {
        if (this.gridZoom < 0) {
            return;
        }
        int zoomToGridZoom = this.zoom - this.gridZoom;
        int tileSize = this.mapSource.getMapSpace().getTileSize();
        if (zoomToGridZoom > 0) {
            this.gridSize = tileSize << zoomToGridZoom;
            this.gridTile = null;
        } else {
            this.gridSize = tileSize >> -zoomToGridZoom;
            BufferedImage newGridTile = null;
            if (this.gridSize > 2) {
                newGridTile = new BufferedImage(tileSize, tileSize, 2);
                Graphics2D g = newGridTile.createGraphics();
                int alpha = 5 + (6 + zoomToGridZoom) * 16;
                alpha = Math.max(0, alpha);
                alpha = Math.min(130, alpha);
                g.setColor(new Color(200, 20, 20, alpha));
                for (int x = 0; x < tileSize; x += this.gridSize) {
                    g.drawLine(x, 0, x, 255);
                }
                for (int y = 0; y < tileSize; y += this.gridSize) {
                    g.drawLine(0, y, 255, y);
                }
            }
            this.gridTile = newGridTile;
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        MapSourceTextAttribution ta;
        String attributionText;
        int h;
        int w;
        int y_max;
        int x_max;
        int y_min;
        int x_min;
        int zoomDiff;
        if (!this.isEnabled()) {
            graphics.setFont(LOADING_FONT);
            graphics.drawString(I18nUtils.localizedStringForKey("map_loading_wait", new Object[0]), 100, 100);
            return;
        }
        if (this.mapSource == null) {
            return;
        }
        Graphics2D g = (Graphics2D)graphics;
        super.paintComponent(g);
        Point tlc = this.getTopLeftCoordinate();
        if (this.gridZoom >= 0) {
            int max = 256 << this.zoom;
            int w2 = Math.min(this.getWidth(), max - tlc.x);
            int h2 = Math.min(this.getHeight(), max - tlc.y);
            g.setColor(GRID_COLOR);
            if (this.gridSize > 1) {
                int x;
                int off_y;
                int off_x;
                int tilesize = this.mapSource.getMapSpace().getTileSize();
                if (this.gridSize >= tilesize) {
                    off_x = tlc.x < 0 ? -tlc.x : -(tlc.x % this.gridSize);
                    off_y = tlc.y < 0 ? -tlc.y : -(tlc.y % this.gridSize);
                    for (x = off_x; x <= w2; x += this.gridSize) {
                        g.drawLine(x, off_y, x, h2);
                    }
                    for (int y = off_y; y <= h2; y += this.gridSize) {
                        g.drawLine(off_x, y, w2, y);
                    }
                } else {
                    off_x = tlc.x < 0 ? tlc.x : tlc.x % tilesize;
                    off_y = tlc.y < 0 ? tlc.y : tlc.y % tilesize;
                    for (x = -off_x; x < w2; x += 256) {
                        for (int y = -off_y; y < h2; y += 256) {
                            g.drawImage((Image)this.gridTile, x, y, null);
                        }
                    }
                }
            }
        }
        if (this.gridSelectionStart != null && this.gridSelectionEnd != null) {
            zoomDiff = 22 - this.zoom;
            x_min = (this.gridSelectionStart.x >> zoomDiff) - tlc.x;
            y_min = (this.gridSelectionStart.y >> zoomDiff) - tlc.y;
            x_max = (this.gridSelectionEnd.x >> zoomDiff) - tlc.x;
            y_max = (this.gridSelectionEnd.y >> zoomDiff) - tlc.y;
            w = x_max - x_min + 1;
            h = y_max - y_min + 1;
            g.setColor(SEL_COLOR);
            g.fillRect(x_min, y_min, w, h);
        }
        if (this.iSelectionMin != null && this.iSelectionMax != null) {
            zoomDiff = 22 - this.zoom;
            x_min = (this.iSelectionMin.x >> zoomDiff) - tlc.x;
            y_min = (this.iSelectionMin.y >> zoomDiff) - tlc.y;
            x_max = (this.iSelectionMax.x >> zoomDiff) - tlc.x;
            y_max = (this.iSelectionMax.y >> zoomDiff) - tlc.y;
            w = x_max - x_min + 1;
            h = y_max - y_min + 1;
            g.setColor(GRID_COLOR);
            g.drawRect(x_min, y_min, w, h);
        }
        if (this.mapSource instanceof MapSourceTextAttribution && (attributionText = (ta = (MapSourceTextAttribution)((Object)this.mapSource)).getAttributionText()) != null) {
            Rectangle2D stringBounds = g.getFontMetrics().getStringBounds(attributionText, g);
            int text_x = this.getWidth() - 10 - (int)stringBounds.getWidth();
            int text_y = this.getHeight() - 1 - (int)stringBounds.getHeight();
            g.setColor(Color.black);
            g.drawString(attributionText, text_x + 1, text_y + 1);
            g.setColor(Color.white);
            g.drawString(attributionText, text_x, text_y);
        }
        if (Settings.getInstance().wgsGrid.enabled) {
            this.wgsGrid.paintWgsGrid(g, this.mapSource.getMapSpace(), tlc, this.zoom);
        }
        ScaleBar.paintScaleBar(this, g, this.mapSource.getMapSpace(), tlc, this.zoom);
    }

    public Bookmark getPositionBookmark() {
        return new Bookmark(this.mapSource, this.zoom, this.center.x, this.center.y);
    }

    public void gotoPositionBookmark(Bookmark bookmark) {
        this.setMapSource(bookmark.getMapSource());
        this.setDisplayPositionByLatLon(bookmark, bookmark.getZoom());
        this.setZoom(bookmark.getZoom());
    }

    public EastNorthCoordinate getCenterCoordinate() {
        MapSpace mapSpace = this.mapSource.getMapSpace();
        double lon = mapSpace.cXToLon(this.center.x, this.zoom);
        double lat = mapSpace.cYToLat(this.center.y, this.zoom);
        return new EastNorthCoordinate(lat, lon);
    }

    public Point getTopLeftCoordinate() {
        return new Point(this.center.x - this.getWidth() / 2, this.center.y - this.getHeight() / 2);
    }

    public void zoomTo(MapSelection ms) {
        if (!ms.isAreaSelected()) {
            return;
        }
        log.trace("Setting selection to: " + ms);
        Point max = ms.getBottomRightPixelCoordinate(22);
        Point min = ms.getTopLeftPixelCoordinate(22);
        this.setDisplayToFitPixelCoordinates(max.x, max.y, min.x, min.y);
    }

    public void setSelectionAndZoomTo(MapSelection ms, boolean notifyListeners) {
        log.trace("Setting selection to: " + ms);
        Point max = ms.getBottomRightPixelCoordinate(22);
        Point min = ms.getTopLeftPixelCoordinate(22);
        this.setDisplayToFitPixelCoordinates(max.x, max.y, min.x, min.y);
        Point pStart = ms.getTopLeftPixelCoordinate(this.zoom);
        Point pEnd = ms.getBottomRightPixelCoordinate(this.zoom);
        this.setSelectionByTileCoordinate(pStart, pEnd, notifyListeners);
    }

    public void setSelectionByTileCoordinate(Point pStart, Point pEnd, boolean notifyListeners) {
        this.setSelectionByTileCoordinate(this.zoom, pStart, pEnd, notifyListeners);
    }

    public void setSelectionByTileCoordinate(int cZoom, Point pStart, Point pEnd, boolean notifyListeners) {
        if (pStart == null || pEnd == null) {
            this.iSelectionMin = null;
            this.iSelectionMax = null;
            this.gridSelectionStart = null;
            this.gridSelectionEnd = null;
            return;
        }
        Point pNewStart = new Point();
        Point pNewEnd = new Point();
        int mapMaxCoordinate = this.mapSource.getMapSpace().getMaxPixels(cZoom) - 1;
        pNewStart.x = Math.max(0, Math.min(mapMaxCoordinate, Math.min(pStart.x, pEnd.x)));
        pNewStart.y = Math.max(0, Math.min(mapMaxCoordinate, Math.min(pStart.y, pEnd.y)));
        pNewEnd.x = Math.max(0, Math.min(mapMaxCoordinate, Math.max(pStart.x, pEnd.x)));
        pNewEnd.y = Math.max(0, Math.min(mapMaxCoordinate, Math.max(pStart.y, pEnd.y)));
        int zoomDiff = 22 - cZoom;
        pNewEnd.x <<= zoomDiff;
        pNewEnd.y <<= zoomDiff;
        pNewStart.x <<= zoomDiff;
        pNewStart.y <<= zoomDiff;
        this.iSelectionMin = pNewStart;
        this.iSelectionMax = pNewEnd;
        this.gridSelectionStart = null;
        this.gridSelectionEnd = null;
        this.updateGridValues();
        this.applyGridOnSelection();
        if (notifyListeners) {
            this.updateMapSelection();
        }
        this.repaint();
    }

    protected void applyGridOnSelection() {
        if (this.gridZoom < 0) {
            this.gridSelectionStart = this.iSelectionMin;
            this.gridSelectionEnd = this.iSelectionMax;
            return;
        }
        if (this.iSelectionMin == null || this.iSelectionMax == null) {
            return;
        }
        int gridZoomDiff = 22 - this.gridZoom;
        int gridFactor = this.mapSource.getMapSpace().getTileSize() << gridZoomDiff;
        Point pNewStart = new Point(this.iSelectionMin);
        Point pNewEnd = new Point(this.iSelectionMax);
        pNewStart.x = MyMath.roundDownToNearest(pNewStart.x, gridFactor);
        pNewStart.y = MyMath.roundDownToNearest(pNewStart.y, gridFactor);
        pNewEnd.x = MyMath.roundUpToNearest(pNewEnd.x, gridFactor) - 1;
        pNewEnd.y = MyMath.roundUpToNearest(pNewEnd.y, gridFactor) - 1;
        this.gridSelectionStart = pNewStart;
        this.gridSelectionEnd = pNewEnd;
    }

    public void updateMapSelection() {
        int y_max;
        int x_max;
        int y_min;
        int x_min;
        if (this.gridZoom >= 0) {
            if (this.gridSelectionStart == null || this.gridSelectionEnd == null) {
                return;
            }
            x_min = this.gridSelectionStart.x;
            y_min = this.gridSelectionStart.y;
            x_max = this.gridSelectionEnd.x;
            y_max = this.gridSelectionEnd.y;
        } else {
            if (this.iSelectionMin == null || this.iSelectionMax == null) {
                return;
            }
            x_min = this.iSelectionMin.x;
            y_min = this.iSelectionMin.y;
            x_max = this.iSelectionMax.x;
            y_max = this.iSelectionMax.y;
        }
        MercatorPixelCoordinate min = new MercatorPixelCoordinate(this.mapSource.getMapSpace(), x_min, y_min, 22);
        MercatorPixelCoordinate max = new MercatorPixelCoordinate(this.mapSource.getMapSpace(), x_max, y_max, 22);
        for (MapEventListener listener : this.mapEventListeners) {
            listener.selectionChanged(max, min);
        }
    }

    public void addMapEventListener(MapEventListener l) {
        this.mapEventListeners.add(l);
    }

    public void selectPreviousMap() {
        for (MapEventListener listener : this.mapEventListeners) {
            listener.selectPreviousMapSource();
        }
    }

    public void selectNextMap() {
        for (MapEventListener listener : this.mapEventListeners) {
            listener.selectNextMapSource();
        }
    }

    public void refreshMap() {
        this.tileCache.clear();
        if (this.mapSource instanceof RefreshableMapSource) {
            ((RefreshableMapSource)((Object)this.mapSource)).refresh();
        }
        this.repaint();
    }

    public JMapController getMapKeyboardController() {
        return this.mapKeyboardController;
    }

    public JMapController getMapSelectionController() {
        return this.mapSelectionController;
    }

    public void setMapSelectionController(JMapController mapSelectionController) {
        if (this.mapSelectionController != null) {
            this.mapSelectionController.disable();
        }
        this.mapSelectionController = mapSelectionController;
        mapSelectionController.enable();
        for (MapEventListener listener : this.mapEventListeners) {
            listener.mapSelectionControllerChanged(mapSelectionController);
        }
        this.repaint();
    }
}

