/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.JComponent;
import mobac.program.interfaces.MapSpace;
import mobac.program.model.Coordinate;
import mobac.program.model.SettingsWgsGrid;
import mobac.utilities.I18nUtils;

public class WgsGrid {
    private static final WgsDensity[] DENSITIES = WgsDensity.values();
    private static final Stroke BASIC_STROKE = new BasicStroke(1.0f);
    private static final int LABEL_OFFSET = 2;
    private final StringBuilder stringBuilder = new StringBuilder(16);
    private final Rectangle viewport = new Rectangle();
    public final SettingsWgsGrid s;
    private final JComponent c;
    private Placement placement = Placement.BOTTOM_RIGHT;
    private BasicStroke stroke;
    private int lastDegree;
    private int lastMinute;

    public WgsGrid(SettingsWgsGrid s, JComponent c) {
        this.s = s;
        this.c = c;
    }

    public void paintWgsGrid(Graphics2D g, MapSpace ms, Point tlc, int zoom) {
        int labelRectX;
        int labelX;
        String label;
        int stringWidth;
        int i;
        int i2;
        if (!this.s.enabled) {
            return;
        }
        WgsDensity density = this.s.density;
        while (zoom < density.minZoom) {
            int index = density.ordinal();
            if (--index <= 0) {
                return;
            }
            density = DENSITIES[index];
        }
        int maxPixels = ms.getMaxPixels(zoom);
        this.viewport.width = this.c.getWidth();
        this.viewport.height = this.c.getHeight();
        if (tlc.x > maxPixels || tlc.y > maxPixels || tlc.x + this.viewport.width < 0 || tlc.y + this.viewport.width < 0) {
            return;
        }
        this.viewport.x = this.c.getX();
        this.viewport.y = this.c.getY();
        this.viewport.translate(tlc.x, tlc.y);
        g = (Graphics2D)g.create();
        g.translate(-tlc.x, -tlc.y);
        int x1 = Math.max(tlc.x, 0);
        int y1 = Math.max(tlc.y, 0);
        int x2 = Math.min(tlc.x + this.viewport.width, maxPixels);
        int y2 = Math.min(tlc.y + this.viewport.height, maxPixels);
        int hLineX1 = x1 + 1;
        int hLineX2 = x2 - 1;
        int vLineY1 = y1 + 1;
        int vLineY2 = y2 - 1;
        int vMin = Coordinate.doubleToInt(ms.cXToLon(x1, zoom)) / density.iStep;
        int vMax = Coordinate.doubleToInt(ms.cXToLon(x2, zoom)) / density.iStep;
        int hMin = Coordinate.doubleToInt(ms.cYToLat(y2, zoom)) / density.iStep;
        int hMax = Coordinate.doubleToInt(ms.cYToLat(y1, zoom)) / density.iStep;
        g.setBackground(Color.WHITE);
        g.setColor(this.s.color);
        g.setStroke(this.checkAndGetStroke());
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (i2 = vMin; i2 <= vMax; ++i2) {
            int iLon = i2 * density.iStep;
            int x = ms.cLonToX(Coordinate.intToDouble(iLon), zoom);
            if (x <= x1 || x >= x2) continue;
            g.drawLine(x, vLineY1, x, vLineY2);
        }
        for (i2 = hMin; i2 <= hMax; ++i2) {
            int iLat = i2 * density.iStep;
            int y = ms.cLatToY(Coordinate.intToDouble(iLat), zoom);
            if (y <= y1 || y >= y2) continue;
            g.drawLine(hLineX1, y, hLineX2, y);
        }
        g.setStroke(BASIC_STROKE);
        g.setFont(this.s.font);
        FontMetrics fontMetrics = g.getFontMetrics();
        int fontDescent = fontMetrics.getDescent();
        int fontHeight = fontMetrics.getHeight();
        this.resetLabelCompression();
        int labelRectY = y2 - 2 - fontHeight;
        int labelY = y2 - 2 - fontDescent;
        for (i = vMin; i <= vMax; ++i) {
            int iLon = i * density.iStep;
            int x = ms.cLonToX(Coordinate.intToDouble(iLon), zoom);
            labelX = x - (stringWidth = fontMetrics.stringWidth(label = this.getLabel(iLon, density))) / 2;
            labelRectX = labelX;
            if (this.viewport.contains(labelRectX, labelRectY, stringWidth, fontHeight)) {
                g.clearRect(labelRectX, labelRectY, stringWidth, fontHeight);
                g.drawRect(labelRectX, labelRectY, stringWidth, fontHeight);
                g.drawString(label, labelX, labelY);
                continue;
            }
            this.resetLabelCompression();
        }
        this.resetLabelCompression();
        this.viewport.height -= fontHeight + 2;
        labelX = labelRectX = x1 + 2;
        for (i = hMin; i <= hMax; ++i) {
            int iLat = i * density.iStep;
            int y = ms.cLatToY(Coordinate.intToDouble(iLat), zoom);
            label = this.getLabel(iLat, density);
            stringWidth = fontMetrics.stringWidth(label);
            if (this.placement == Placement.BOTTOM_RIGHT || this.placement == Placement.TOP_RIGHT) {
                labelX = labelRectX = x2 - 2 - stringWidth;
            }
            labelRectY = y - fontHeight / 2;
            labelY = labelRectY + fontHeight - fontDescent;
            if (this.viewport.contains(labelRectX, labelRectY, stringWidth, fontHeight)) {
                g.clearRect(labelRectX, labelRectY, stringWidth, fontHeight);
                g.drawRect(labelRectX, labelRectY, stringWidth, fontHeight);
                g.drawString(label, labelX, labelY);
                continue;
            }
            this.resetLabelCompression();
        }
        g.dispose();
    }

    public void setPosition(Placement placement) {
        this.placement = placement != null ? placement : Placement.BOTTOM_RIGHT;
    }

    private Stroke checkAndGetStroke() {
        if (this.stroke == null || this.stroke.getLineWidth() != this.s.width) {
            this.stroke = new BasicStroke(this.s.width);
        }
        return this.stroke;
    }

    private void resetLabelCompression() {
        this.lastDegree = Integer.MAX_VALUE;
        this.lastMinute = Integer.MAX_VALUE;
    }

    private String getLabel(int coord, WgsDensity density) {
        coord = Math.abs(coord);
        int degree = Coordinate.getDegree(coord);
        int minute = Coordinate.getMinute(coord);
        int second = Coordinate.getSecond(coord);
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(" ");
        if (!this.s.compressLabels || this.lastDegree != degree || !density.compressDegree) {
            this.stringBuilder.append(degree);
            this.stringBuilder.append('\u00b0');
        }
        if (!(!density.displayMinute || this.s.compressLabels && this.lastMinute == minute && density.compressMinute)) {
            if (minute < 10) {
                this.stringBuilder.append('0');
            }
            this.stringBuilder.append(minute);
            this.stringBuilder.append('\'');
        }
        if (density.displaySecond) {
            if (second < 10) {
                this.stringBuilder.append('0');
            }
            this.stringBuilder.append(second);
            this.stringBuilder.append('\"');
        }
        this.stringBuilder.append(" ");
        this.lastDegree = degree;
        this.lastMinute = minute;
        return this.stringBuilder.toString();
    }

    public static enum Placement {
        BOTTOM_RIGHT,
        BOTTOM_LEFT,
        TOP_RIGHT,
        TOP_LEFT;

    }

    public static enum WgsDensity {
        DEGREES_90(0),
        DEGREES_45(1),
        DEGREES_30(2),
        DEGREES_15(3),
        DEGREES_10(4),
        DEGREES_5(5),
        DEGREES_2(6),
        DEGREE_1(7),
        MINUTES_30(8),
        MINUTES_20(9),
        MINUTES_10(10),
        MINUTES_5(11),
        MINUTES_2(12),
        MINUTE_1(13),
        SECONDS_30(15),
        SECONDS_20(15),
        SECONDS_10(16),
        SECONDS_5(17),
        SECONDS_2(18),
        SECOND_1(19);

        public final int iStep;
        public final int minZoom;
        public final boolean compressDegree;
        public final boolean compressMinute;
        public final boolean displayMinute;
        public final boolean displaySecond;

        private WgsDensity(int minZoom) {
            this.minZoom = minZoom;
            String[] split = this.name().split("_");
            int value = Integer.parseInt(split[1]);
            if (split[0].startsWith("D")) {
                this.iStep = value * 3600000;
                this.displaySecond = false;
                this.displayMinute = false;
                this.compressMinute = false;
                this.compressDegree = false;
            } else if (split[0].startsWith("M")) {
                this.iStep = value * 60000;
                this.compressDegree = true;
                this.displayMinute = true;
                this.compressMinute = false;
                this.displaySecond = false;
            } else {
                this.iStep = value * 1000;
                this.displaySecond = true;
                this.displayMinute = true;
                this.compressDegree = true;
                this.compressMinute = true;
            }
        }

        public String toString() {
            String[] split = this.name().split("_");
            String unitKey = "map_ctrl_wgs_grid_density_" + split[0].toLowerCase();
            return I18nUtils.localizedStringForKey("map_ctrl_wgs_grid_density_prefix", new Object[0]) + " " + split[1] + " " + I18nUtils.localizedStringForKey(unitKey, new Object[0]);
        }
    }
}

