/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview.controller;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import javax.swing.JOptionPane;
import mobac.data.gpx.gpx11.Gpx;
import mobac.data.gpx.gpx11.WptType;
import mobac.gui.actions.GpxEditor;
import mobac.gui.gpxtree.GpxEntry;
import mobac.gui.gpxtree.GpxRootEntry;
import mobac.gui.gpxtree.RteEntry;
import mobac.gui.gpxtree.TrksegEntry;
import mobac.gui.mapview.PreviewMap;
import mobac.gui.mapview.controller.JMapController;
import mobac.gui.panels.JGpxPanel;
import mobac.program.interfaces.MapSpace;
import mobac.utilities.I18nUtils;

public class GpxMapController
extends JMapController
implements MouseListener {
    private JGpxPanel panel;
    private GpxEntry entry;

    public GpxMapController(PreviewMap map, JGpxPanel panel, boolean enabled) {
        super(map, enabled);
        this.panel = panel;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.disable();
        if (e.getButton() == 1) {
            this.entry = this.panel.getSelectedEntry();
            Gpx gpx = this.entry.getLayer().getGpx();
            Point p = e.getPoint();
            Point tl = this.map.getTopLeftCoordinate();
            p.x += tl.x;
            p.y += tl.y;
            MapSpace mapSpace = this.map.getMapSource().getMapSpace();
            int maxPixel = mapSpace.getMaxPixels(this.map.getZoom());
            if (p.x < 0 || p.x > maxPixel || p.y < 0 || p.y > maxPixel) {
                return;
            }
            double lon = mapSpace.cXToLon(p.x, this.map.getZoom());
            double lat = mapSpace.cYToLat(p.y, this.map.getZoom());
            String name = JOptionPane.showInputDialog(null, (Object)I18nUtils.localizedStringForKey("dlg_gpx_inpu_point_name", new Object[0]));
            if (name == null) {
                return;
            }
            Gpx gpx11 = gpx;
            WptType wpt = new WptType();
            wpt.setName(name);
            wpt.setLat(new BigDecimal(lat));
            wpt.setLon(new BigDecimal(lon));
            GpxEditor editor = GpxEditor.getInstance();
            if (this.entry.getClass() == GpxRootEntry.class) {
                gpx11.getWpt().add(wpt);
            } else if (this.entry instanceof RteEntry) {
                editor.findRteAndAdd((RteEntry)this.entry, wpt);
            } else if (this.entry instanceof TrksegEntry) {
                editor.findTrksegAndAdd((TrksegEntry)this.entry, wpt);
            }
            this.panel.addWpt(wpt, this.entry);
        }
        this.map.repaint();
    }

    public void repaint() {
        this.map.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void disable() {
        super.disable();
        this.map.getMapSelectionController().enable();
    }
}

