/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview.controller;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import mobac.gui.mapview.PreviewMap;
import mobac.gui.mapview.controller.AbstractPolygonSelectionMapController;

public class PolygonCircleSelectionMapController
extends AbstractPolygonSelectionMapController
implements MouseMotionListener,
MouseListener {
    private static final int POLYGON_POINTS = 16;
    private static final double ANGLE_PART = 0.39269908169872414;
    private Point center;

    public PolygonCircleSelectionMapController(PreviewMap map) {
        super(map);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.center = this.convertToAbsolutePoint(e.getPoint());
            this.polygonPoints.ensureCapacity(16);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if ((e.getModifiersEx() & 0x400) == 1024 && this.center != null) {
            Point circlePoint = this.convertToAbsolutePoint(e.getPoint());
            double radius = circlePoint.distance(this.center);
            this.polygonPoints.clear();
            for (int i = 0; i < 16; ++i) {
                double angle = 0.39269908169872414 * (double)i;
                int y = (int)Math.round(Math.sin(angle) * radius);
                int x = (int)Math.round(Math.cos(angle) * radius);
                this.polygonPoints.add(new Point(this.center.x + x, this.center.y + y));
            }
            this.map.grabFocus();
            this.map.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

