/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview.controller;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import mobac.gui.mapview.PreviewMap;
import mobac.gui.mapview.controller.JMapController;
import mobac.gui.mapview.layer.RectangleSelectionLayer;

public class RectangleSelectionMapController
extends JMapController
implements MouseMotionListener,
MouseListener {
    private Point iStartSelectionPoint;
    private Point iEndSelectionPoint;
    protected RectangleSelectionLayer mapLayer = new RectangleSelectionLayer(this);

    public RectangleSelectionMapController(PreviewMap map) {
        super(map, false);
    }

    @Override
    public void enable() {
        super.enable();
    }

    @Override
    public void disable() {
        this.map.mapLayers.remove(this.mapLayer);
        this.map.setSelectionByTileCoordinate(null, null, true);
        super.disable();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.iStartSelectionPoint = this.convertToAbsolutePoint(e.getPoint());
            this.iEndSelectionPoint = this.convertToAbsolutePoint(e.getPoint());
        }
        this.map.grabFocus();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if ((e.getModifiersEx() & 0x400) == 1024 && this.iStartSelectionPoint != null) {
            this.iEndSelectionPoint = this.convertToAbsolutePoint(e.getPoint());
            this.map.setSelectionByTileCoordinate(22, this.iStartSelectionPoint, this.iEndSelectionPoint, true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 1) {
            this.map.setSelectionByTileCoordinate(22, this.iStartSelectionPoint, this.convertToAbsolutePoint(e.getPoint()), true);
        }
        this.map.grabFocus();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.map.grabFocus();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public Point getiStartSelectionPoint() {
        return this.iStartSelectionPoint;
    }

    public Point getiEndSelectionPoint() {
        return this.iEndSelectionPoint;
    }

    public RectangleSelectionLayer getMapLayer() {
        return this.mapLayer;
    }

    public PreviewMap getMap() {
        return this.map;
    }
}

