/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview.layer;

import java.awt.Graphics;
import mobac.gui.mapview.JMapViewer;
import mobac.gui.mapview.Tile;
import mobac.gui.mapview.interfaces.MapTileLayer;
import mobac.program.interfaces.MapSource;

public class OverlayMapTileLayer
implements MapTileLayer {
    protected JMapViewer mapViewer;
    protected MapSource mapSource;

    public OverlayMapTileLayer(JMapViewer mapViewer, MapSource tileSource) {
        this.mapViewer = mapViewer;
        this.mapSource = tileSource;
    }

    @Override
    public void startPainting(MapSource mapSource) {
    }

    @Override
    public void paintTile(Graphics g, int gx, int gy, int tilex, int tiley, int zoom) {
        Tile tile = this.getTile(tilex, tiley, zoom);
        if (tile == null) {
            return;
        }
        tile.paintTransparent(g, gx, gy);
    }

    protected Tile getTile(int tilex, int tiley, int zoom) {
        int max = 1 << zoom;
        if (tilex < 0 || tilex >= max || tiley < 0 || tiley >= max) {
            return null;
        }
        Tile tile = this.mapViewer.getTileImageCache().getTile(this.mapSource, tilex, tiley, zoom);
        if (tile == null) {
            tile = new Tile(this.mapSource, tilex, tiley, zoom);
            this.mapViewer.getTileImageCache().addTile(tile);
        }
        if (tile.getTileState() == Tile.TileState.TS_NEW) {
            this.mapViewer.getJobDispatcher().addJob(this.mapViewer.getTileLoader().createTileLoaderJob(this.mapSource, tilex, tiley, zoom));
        }
        return tile;
    }
}

