/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview.layer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import mobac.gui.mapview.JMapViewer;
import mobac.gui.mapview.controller.RectangleSelectionMapController;
import mobac.gui.mapview.interfaces.MapLayer;
import mobac.program.interfaces.MapSpace;

public class RectangleSelectionLayer
implements MapLayer {
    private final RectangleSelectionMapController mapController;

    public RectangleSelectionLayer(RectangleSelectionMapController rectangleSelectionMapController) {
        this.mapController = rectangleSelectionMapController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(JMapViewer map, Graphics2D g, int zoom, int minX, int minY, int maxX, int maxY) {
        MapSpace mapSpace = map.getMapSource().getMapSpace();
        g.setColor(Color.BLUE);
        Point p1 = this.mapController.getiStartSelectionPoint();
        Point p2 = this.mapController.getiEndSelectionPoint();
        if (p1 == null || p2 == null) {
            return;
        }
        p1 = mapSpace.changeZoom(p1, 22, zoom);
        p2 = mapSpace.changeZoom(p2, 22, zoom);
        int x = Math.min(p1.x, p2.x);
        int y = Math.min(p1.y, p2.y);
        int w = Math.abs(p1.x - p2.x);
        int h = Math.abs(p1.y - p2.y);
        AffineTransform at = g.getTransform();
        try {
            g.translate(-minX, -minY);
            g.drawRect(x, y, w, h);
        }
        finally {
            g.setTransform(at);
        }
    }
}

