/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview.layer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import mobac.gui.mapview.JMapViewer;
import mobac.gui.mapview.interfaces.MapLayer;

public class ShapeLayer
implements MapLayer {
    private Color color = new Color(0.0f, 1.0f, 0.0f, 0.5f);
    private int calculationZoom;
    private Shape shape;

    public ShapeLayer(Shape shape, int zoom) {
        this.shape = shape;
    }

    @Override
    public void paint(JMapViewer map, Graphics2D g, int zoom, int minX, int minY, int maxX, int maxY) {
        AffineTransform af = g.getTransform();
        g.translate(-minX, -minY);
        double scale = zoom < this.calculationZoom ? 1.0 / (double)(1 << this.calculationZoom - zoom) : (double)(1 << zoom - this.calculationZoom);
        g.scale(scale, scale);
        g.setColor(this.color);
        g.fill(this.shape);
        g.setTransform(af);
    }
}

