/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview.layer;

import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import javax.swing.JOptionPane;
import mobac.gui.MainGUI;
import mobac.gui.dialogs.WorkinprogressDialog;
import mobac.gui.mapview.JMapViewer;
import mobac.gui.mapview.PreviewMap;
import mobac.gui.mapview.interfaces.MapLayer;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.tilestore.TileStore;
import mobac.program.tilestore.berkeleydb.DelayedInterruptThread;
import mobac.utilities.GUIExceptionHandler;
import mobac.utilities.I18nUtils;

public class TileStoreCoverageLayer
implements MapLayer {
    private final MapSource mapSource;
    private final int zoom;
    private final Point pixelCoordinateMin;
    private final Point pixelCoordinateMax;
    private final Point tileNumMin;
    private final Point tileNumMax;
    private BufferedImage coverageImage = null;

    public static void removeCacheCoverageLayers() {
        try {
            PreviewMap previewMap = MainGUI.getMainGUI().previewMap;
            Iterator mapLayers = previewMap.mapLayers.iterator();
            while (mapLayers.hasNext()) {
                MapLayer ml = (MapLayer)mapLayers.next();
                if (!(ml instanceof TileStoreCoverageLayer)) continue;
                mapLayers.remove();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TileStoreCoverageLayer(PreviewMap mapViewer, MapSource mapSource, int zoom) {
        this.mapSource = mapSource;
        this.zoom = zoom;
        MapSpace mapSpace = mapSource.getMapSpace();
        int tileSize = mapSpace.getTileSize();
        int mapViewerZoom = mapViewer.getZoom();
        Point min = mapViewer.getTopLeftCoordinate();
        Point max = new Point(min.x + mapViewer.getWidth(), min.y + mapViewer.getHeight());
        min = mapSpace.changeZoom(min, mapViewerZoom, zoom);
        max = mapSpace.changeZoom(max, mapViewerZoom, zoom);
        this.tileNumMax = new Point(max.x / tileSize, max.y / tileSize);
        this.tileNumMin = new Point(min.x / tileSize, min.y / tileSize);
        this.pixelCoordinateMax = new Point(this.tileNumMax.x * tileSize + tileSize - 1, this.tileNumMax.y * tileSize + tileSize - 1);
        this.pixelCoordinateMin = new Point(this.tileNumMin.x * tileSize, this.tileNumMin.y * tileSize);
        this.updateCoverageImage();
    }

    private void updateCoverageImage() {
        this.coverageImage = null;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    TileStoreCoverageLayer.this.coverageImage = TileStore.getInstance().getCacheCoverage(TileStoreCoverageLayer.this.mapSource, TileStoreCoverageLayer.this.zoom, TileStoreCoverageLayer.this.tileNumMin, TileStoreCoverageLayer.this.tileNumMax);
                    if (TileStoreCoverageLayer.this.coverageImage == null) {
                        JOptionPane.showMessageDialog(MainGUI.getMainGUI(), I18nUtils.localizedStringForKey("msg_tile_store_failed_retrieve_coverage", new Object[0]), I18nUtils.localizedStringForKey("Error", new Object[0]), 0);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    GUIExceptionHandler.processException(e);
                }
                if (TileStoreCoverageLayer.this.coverageImage == null) {
                    TileStoreCoverageLayer.removeCacheCoverageLayers();
                }
                MainGUI.getMainGUI().previewMap.repaint();
            }
        };
        WorkinprogressDialog dialog = new WorkinprogressDialog((Frame)MainGUI.getMainGUI(), "Loading coverage data", DelayedInterruptThread.createThreadFactory());
        dialog.startWork(r);
    }

    @Override
    public void paint(JMapViewer mapViewer, Graphics2D g, int zoom, int minX, int minY, int maxX, int maxY) {
        if (this.coverageImage == null) {
            return;
        }
        this.paintCoverage(g, zoom, minX, minY, maxX, maxY);
    }

    protected void paintCoverage(Graphics2D g, int zoom, int minX, int minY, int maxX, int maxY) {
        Point max = this.pixelCoordinateMax;
        Point min = this.pixelCoordinateMin;
        MapSpace mapSpace = this.mapSource.getMapSpace();
        int mapX = mapSpace.xChangeZoom(min.x, this.zoom, zoom);
        int mapY = mapSpace.yChangeZoom(min.y, this.zoom, zoom);
        int mapW = mapSpace.xChangeZoom(max.x - min.x + 1, this.zoom, zoom);
        int mapH = mapSpace.yChangeZoom(max.y - min.y + 1, this.zoom, zoom);
        int x = mapX - minX;
        int y = mapY - minY;
        int w = mapW;
        int h = mapH;
        g.drawImage(this.coverageImage, x, y, w, h, null);
    }
}

