/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import mobac.gui.components.JCollapsiblePanel;
import mobac.gui.components.JMapSourceTree;
import mobac.program.interfaces.MapSource;
import mobac.utilities.GBC;
import mobac.utilities.I18nUtils;

public class JMapSourcesPanel
extends JCollapsiblePanel {
    private static final long serialVersionUID = 1L;
    protected JLabel mapSourceLabel;
    protected static final String initialMapSourceLabel = " ";
    protected final String plainTitle = this.getTitle();

    public JMapSourcesPanel(JMapSourceTree mapSourceTree) {
        super(I18nUtils.localizedStringForKey("lp_map_source_title", new Object[0]), new GridBagLayout());
        JScrollPane mapSourceTreeScrollPane = new JScrollPane(mapSourceTree, 20, 30);
        mapSourceTreeScrollPane.setPreferredSize(new Dimension(100, 200));
        mapSourceTreeScrollPane.setAutoscrolls(true);
        this.addContent(mapSourceTreeScrollPane, GBC.eol().fill().insets(0, 1, 0, 0));
    }

    @Override
    protected void fillTitlePanel() {
        super.fillTitlePanel();
        this.mapSourceLabel = new JLabel(initialMapSourceLabel);
        this.mapSourceLabel.addMouseListener(this.collapsingMouseListener);
        this.titlePanel.add((Component)this.mapSourceLabel, GBC.std());
        this.titlePanel.revalidate();
    }

    public void setMapSourceLabel(MapSource mapSource) {
        String mapSourceString = mapSource.toString();
        if (mapSourceString == null) {
            mapSourceString = "";
        }
        this.mapSourceLabel.setText(mapSourceString);
        this.mapSourceLabel.setToolTipText(JMapSourceTree.generateMapSourceTooltip(mapSource));
        this.mapSourceLabel.setVisible(!mapSourceString.isEmpty());
    }
}

