/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mobac.gui.components.JCollapsiblePanel;
import mobac.gui.components.JTileSizeCombo;
import mobac.program.annotations.SupportedParameters;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.model.AtlasOutputFormat;
import mobac.program.model.Settings;
import mobac.program.model.TileImageFormat;
import mobac.program.model.TileImageParameters;
import mobac.program.tiledatawriter.TileImageJpegDataWriter;
import mobac.utilities.GBC;
import mobac.utilities.I18nUtils;
import mobac.utilities.Utilities;

public class JTileImageParametersPanel
extends JCollapsiblePanel {
    private static final long serialVersionUID = 1L;
    private static boolean JPEG_TESTED = false;
    private JCheckBox enableCustomTileProcessingCheckButton;
    private JLabel tileSizeWidthLabel;
    private JLabel tileSizeHeightLabel;
    private JLabel tileImageFormatLabel;
    private JTileSizeCombo tileSizeWidth;
    private JTileSizeCombo tileSizeHeight;
    private JComboBox<TileImageFormat> tileImageFormat;
    private boolean widthEnabled = true;
    private boolean heightEnabled = true;
    private boolean formatPngEnabled = true;
    private boolean formatJpgEnabled = true;

    public JTileImageParametersPanel() {
        super(I18nUtils.localizedStringForKey("lp_tile_param_title", new Object[0]), new GridBagLayout());
        this.setName("TileImageParameters");
        this.enableCustomTileProcessingCheckButton = new JCheckBox(I18nUtils.localizedStringForKey("lp_tile_param_recreate_checkbox_title", new Object[0]));
        this.enableCustomTileProcessingCheckButton.addActionListener(new EnableCustomTileSizeCheckButtonListener());
        this.enableCustomTileProcessingCheckButton.setToolTipText(I18nUtils.localizedStringForKey("lp_tile_param_recreate_checkbox_tips", new Object[0]));
        this.tileSizeWidthLabel = new JLabel(I18nUtils.localizedStringForKey("lp_tile_param_width_title", new Object[0]));
        this.tileSizeWidth = new JTileSizeCombo();
        this.tileSizeWidth.setToolTipText(I18nUtils.localizedStringForKey("lp_tile_param_width_tips", new Object[0]));
        this.tileSizeHeightLabel = new JLabel(I18nUtils.localizedStringForKey("lp_tile_param_height_title", new Object[0]));
        this.tileSizeHeight = new JTileSizeCombo();
        this.tileSizeHeight.setToolTipText(I18nUtils.localizedStringForKey("lp_tile_param_height_tips", new Object[0]));
        this.tileImageFormatLabel = new JLabel(I18nUtils.localizedStringForKey("lp_tile_param_image_fmt_title", new Object[0]));
        this.tileImageFormat = new JComboBox<TileImageFormat>(new TileFormatComboModel(TileImageFormat.values()));
        this.tileImageFormat.setMaximumRowCount(this.tileImageFormat.getItemCount());
        this.tileImageFormat.addActionListener(new TileImageFormatListener());
        GBC gbc_std = GBC.std().insets(5, 2, 5, 3);
        GBC gbc_eol = GBC.eol().insets(5, 2, 5, 3);
        JPanel tileSizePanel = new JPanel(new GridBagLayout());
        tileSizePanel.add((Component)this.tileSizeWidthLabel, gbc_std);
        tileSizePanel.add((Component)this.tileSizeWidth, gbc_std);
        tileSizePanel.add((Component)this.tileSizeHeightLabel, gbc_std);
        tileSizePanel.add((Component)this.tileSizeHeight, gbc_eol);
        JPanel tileColorDepthPanel = new JPanel();
        tileColorDepthPanel.add(this.tileImageFormatLabel);
        tileColorDepthPanel.add(this.tileImageFormat);
        this.contentContainer.add((Component)this.enableCustomTileProcessingCheckButton, gbc_eol);
        this.contentContainer.add((Component)tileSizePanel, GBC.eol());
        this.contentContainer.add((Component)tileColorDepthPanel, GBC.eol());
    }

    public void loadSettings() {
        Settings settings = Settings.getInstance();
        this.enableCustomTileProcessingCheckButton.setSelected(settings.isCustomTileSize());
        this.updateControlsState();
        this.tileImageFormat.setSelectedItem((Object)settings.getTileImageFormat());
        this.tileSizeHeight.setValue(settings.getTileSize().height);
        this.tileSizeWidth.setValue(settings.getTileSize().width);
    }

    public void saveSettings() {
        Settings settings = Settings.getInstance();
        settings.setCustomTileSize(this.enableCustomTileProcessingCheckButton.isSelected());
        Dimension tileSize = new Dimension(this.tileSizeWidth.getValue(), this.tileSizeHeight.getValue());
        settings.setTileSize(tileSize);
        settings.setTileImageFormat((TileImageFormat)((Object)this.tileImageFormat.getSelectedItem()));
    }

    public TileImageParameters getSelectedTileImageParameters() {
        TileImageParameters customTileParameters = null;
        boolean customTileSize = this.enableCustomTileProcessingCheckButton.isSelected();
        if (customTileSize) {
            int width = this.tileSizeWidth.getValue();
            int height = this.tileSizeHeight.getValue();
            TileImageFormat format = (TileImageFormat)((Object)this.tileImageFormat.getSelectedItem());
            customTileParameters = new TileImageParameters(width, height, format);
        }
        return customTileParameters;
    }

    public void atlasFormatChanged(AtlasOutputFormat newAtlasOutputFormat) {
        Class<? extends AtlasCreator> atlasCreatorClass = newAtlasOutputFormat.getMapCreatorClass();
        SupportedParameters params = atlasCreatorClass.getAnnotation(SupportedParameters.class);
        if (params != null) {
            TreeSet<TileImageParameters.Name> paramNames = new TreeSet<TileImageParameters.Name>(Arrays.asList(params.names()));
            if (paramNames.contains((Object)TileImageParameters.Name.format)) {
                this.formatPngEnabled = true;
                this.formatJpgEnabled = true;
            } else {
                this.formatPngEnabled = paramNames.contains((Object)TileImageParameters.Name.format_png);
                this.formatJpgEnabled = paramNames.contains((Object)TileImageParameters.Name.format_jpg);
            }
            this.widthEnabled = paramNames.contains((Object)TileImageParameters.Name.width);
            this.heightEnabled = paramNames.contains((Object)TileImageParameters.Name.height);
            this.enableCustomTileProcessingCheckButton.setEnabled(true);
        } else {
            this.formatPngEnabled = false;
            this.formatJpgEnabled = false;
            this.widthEnabled = false;
            this.heightEnabled = false;
            this.enableCustomTileProcessingCheckButton.setEnabled(false);
        }
        this.updateControlsState();
    }

    public void updateControlsState() {
        boolean b = false;
        if (this.enableCustomTileProcessingCheckButton.isEnabled()) {
            b = this.enableCustomTileProcessingCheckButton.isSelected();
        }
        this.tileSizeWidth.setEnabled(b && this.widthEnabled);
        this.tileSizeWidthLabel.setEnabled(b && this.widthEnabled);
        this.tileSizeHeightLabel.setEnabled(b && this.heightEnabled);
        this.tileSizeHeight.setEnabled(b && this.heightEnabled);
        boolean formatEnabled = this.formatJpgEnabled || this.formatPngEnabled;
        this.tileImageFormatLabel.setEnabled(b && formatEnabled);
        this.tileImageFormat.setEnabled(b && formatEnabled);
        if (this.formatPngEnabled && !this.formatJpgEnabled) {
            this.updateFormatComboModel(TileImageFormat.getPngFormats());
        } else if (!this.formatPngEnabled && this.formatJpgEnabled) {
            this.updateFormatComboModel(TileImageFormat.getJpgFormats());
        } else {
            this.updateFormatComboModel(TileImageFormat.values());
        }
    }

    private void updateFormatComboModel(TileImageFormat[] values) {
        TileFormatComboModel model = (TileFormatComboModel)this.tileImageFormat.getModel();
        model.changeValues(values);
    }

    public String getValidationErrorMessages() {
        String errorText = "";
        if (!this.enableCustomTileProcessingCheckButton.isSelected()) {
            return errorText;
        }
        if (!this.tileSizeHeight.isValueValid()) {
            errorText = errorText + String.format(I18nUtils.localizedStringForKey("lp_tile_param_msg_valid_height", new Object[0]), 50, 8192);
        }
        if (!this.tileSizeWidth.isValueValid()) {
            errorText = errorText + String.format(I18nUtils.localizedStringForKey("lp_tile_param_msg_valid_width", new Object[0]), 50, 8192);
        }
        return errorText;
    }

    private class TileFormatComboModel
    extends AbstractListModel<TileImageFormat>
    implements ComboBoxModel<TileImageFormat> {
        TileImageFormat[] values;
        Object selectedObject = null;

        public TileFormatComboModel(TileImageFormat[] values) {
            this.values = values;
            if (values.length > 0) {
                this.selectedObject = values[0];
            }
        }

        public void changeValues(TileImageFormat[] values) {
            this.values = values;
            boolean found = false;
            for (TileImageFormat format : values) {
                if (!format.equals(this.selectedObject)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.selectedObject = values[0];
            }
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public int getSize() {
            return this.values.length;
        }

        @Override
        public TileImageFormat getElementAt(int index) {
            return this.values[index];
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (this.selectedObject != null && !this.selectedObject.equals(anItem) || this.selectedObject == null && anItem != null) {
                this.selectedObject = anItem;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedObject;
        }
    }

    private class TileImageFormatListener
    implements ActionListener {
        private TileImageFormatListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!JTileImageParametersPanel.this.tileImageFormat.isEnabled()) {
                return;
            }
            TileImageFormat tif = (TileImageFormat)((Object)JTileImageParametersPanel.this.tileImageFormat.getSelectedItem());
            if (tif == null) {
                return;
            }
            if (!JPEG_TESTED && tif.getDataWriter() instanceof TileImageJpegDataWriter) {
                if (!TileImageJpegDataWriter.performOpenJDKJpegTest()) {
                    JOptionPane.showMessageDialog(null, "<html>The JPEG image format is not supported by OpenJDK.<br>Please select a different tile format.</html>", "Image format not available on OpenJDK", 0);
                }
                JPEG_TESTED = true;
            } else if (tif == TileImageFormat.PNG4Bit || tif == TileImageFormat.PNG8Bit) {
                if (Utilities.testJaiColorQuantizerAvailable()) {
                    return;
                }
                JOptionPane.showMessageDialog(null, "<html>This image format is requires additional libraries to be installed:<br><b>Java Advanced Image library</b> (jai_core.jar & jai_codec.jar)<br>For more details please see the file <b>README.HTM</b> in section <b>Requirements</b>.</html>", "Image format not available - libraries missing", 0);
                JTileImageParametersPanel.this.tileImageFormat.setSelectedIndex(0);
            }
        }
    }

    private class EnableCustomTileSizeCheckButtonListener
    implements ActionListener {
        private EnableCustomTileSizeCheckButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTileImageParametersPanel.this.updateControlsState();
        }
    }
}

