/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.settings;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import mobac.gui.mapview.WgsGrid;
import mobac.gui.settings.SettingsGUI;
import mobac.program.model.PaperSize;
import mobac.program.model.Settings;
import mobac.program.model.SettingsPaperAtlas;
import mobac.program.model.UnitSystem;
import mobac.utilities.GBCTable;
import mobac.utilities.I18nUtils;

public class SettingsGUIPaper
extends JPanel {
    private static final long serialVersionUID = -8265562215604604074L;
    private final JButton jButtonDefaults = new JButton();
    private final JButton jButtonExport = new JButton();
    private final JButton jButtonImport = new JButton();
    private final JCheckBox jCheckBoxCompass = new JCheckBox();
    private final JCheckBox jCheckBoxLandscape = new JCheckBox();
    private final JCheckBox jCheckBoxPageNumbers = new JCheckBox("", true);
    private final JCheckBox jCheckBoxScaleBar = new JCheckBox();
    private final JCheckBox jCheckBoxWgsGrid = new JCheckBox("", true);
    private final JFileChooser jFileChooser = new JFileChooser();
    private final TitledBorder titledBorderActions = SettingsGUI.createSectionBorder("");
    private final TitledBorder titledBorderAdditions = SettingsGUI.createSectionBorder("");
    private final TitledBorder titledBorderAdvanced = SettingsGUI.createSectionBorder("");
    private final TitledBorder titledBorderMargins = SettingsGUI.createSectionBorder("");
    private final TitledBorder titledBorderSize = SettingsGUI.createSectionBorder("");
    private final JPanel jPanelActions = SettingsGUIPaper.createSection(this.titledBorderActions);
    private final JPanel jPanelAdditions = SettingsGUIPaper.createSection(this.titledBorderAdditions);
    private final JPanel jPanelAdvanced = SettingsGUIPaper.createSection(this.titledBorderAdvanced);
    private final JPanel jPanelMargins = SettingsGUIPaper.createSection(this.titledBorderMargins);
    private final JPanel jPanelSize = SettingsGUIPaper.createSection(this.titledBorderSize);
    private final JComboBox jComboBoxFormat = new JComboBox<PaperSize.Format>(PaperSize.Format.values());
    private final JComboBox jComboBoxWgsDensity = new JComboBox<WgsGrid.WgsDensity>(WgsGrid.WgsDensity.values());
    private final JRadioButton jRadioButtonCustom = new JRadioButton("", true);
    private final JRadioButton jRadioButtonDefault = new JRadioButton("", true);
    private final JRadioButton jRadioButtonSelection = new JRadioButton("", true);
    private final SpinnerNumberModel modelCompression = new SpinnerNumberModel(6, 0, 9, 1);
    private final SpinnerNumberModel modelCrop = new SpinnerNumberModel(15, 0, 100, 1);
    private final SpinnerNumberModel modelDpi = new SpinnerNumberModel(96, 72, 300, 1);
    private final SpinnerNumberModel modelHeight = new SpinnerNumberModel(0.0, 0.0, 0.0, 1.0);
    private final SpinnerNumberModel modelWidth = new SpinnerNumberModel(0.0, 0.0, 0.0, 1.0);
    private final SpinnerNumberModel modelMarginBottom = new SpinnerNumberModel(0.0, 0.0, 0.0, 1.0);
    private final SpinnerNumberModel modelMarginLeft = new SpinnerNumberModel(0.0, 0.0, 0.0, 1.0);
    private final SpinnerNumberModel modelMarginRight = new SpinnerNumberModel(0.0, 0.0, 0.0, 1.0);
    private final SpinnerNumberModel modelMarginTop = new SpinnerNumberModel(0.0, 0.0, 0.0, 1.0);
    private final SpinnerNumberModel modelOverlap = new SpinnerNumberModel(0.0, 0.0, 0.0, 1.0);
    private final JSpinner jSpinnerDpi = new JSpinner(this.modelDpi);
    private final JSpinner jSpinnerWidth = new JSpinner(this.modelWidth);
    private final JSpinner jSpinnerHeight = new JSpinner(this.modelHeight);
    private final JSpinner jSpinnerMarginTop = new JSpinner(this.modelMarginTop);
    private final JSpinner jSpinnerMarginLeft = new JSpinner(this.modelMarginLeft);
    private final JSpinner jSpinnerMarginBottom = new JSpinner(this.modelMarginBottom);
    private final JSpinner jSpinnerMarginRight = new JSpinner(this.modelMarginRight);
    private final JSpinner jSpinnerOverlap = new JSpinner(this.modelOverlap);
    private final JSpinner jSpinnerCrop = new JSpinner(this.modelCrop);
    private final JSpinner jSpinnerCompression = new JSpinner(this.modelCompression);
    private final JLabel jLabelCompression = new JLabel();
    private final JLabel jLabelDpi = new JLabel();
    private final JLabel jLabelWidth = new JLabel();
    private final JLabel jLabelHeight = new JLabel();
    private final JLabel jLabelMarginTop = new JLabel();
    private final JLabel jLabelMarginLeft = new JLabel();
    private final JLabel jLabelMarginBottom = new JLabel();
    private final JLabel jLabelMarginRight = new JLabel();
    private final JLabel jLabelOverlap = new JLabel();
    private final JLabel jLabelCrop = new JLabel();
    private String importError;
    private String exportError;
    private String errorReason;
    private String errorTitle;
    private String xmlFileFilter;
    private UnitSystem unitSystem;

    private static void setModel(SpinnerNumberModel model, double min, double max, Double step) {
        model.setMaximum(Double.valueOf(max));
        model.setMinimum(Double.valueOf(min));
        model.setStepSize(step);
        double value = model.getNumber().doubleValue();
        value = Math.max(Math.min(value, max), min);
        model.setValue(value);
    }

    private static void setEditor(JSpinner jSpinner, String pattern) {
        jSpinner.setEditor(new JSpinner.NumberEditor(jSpinner, pattern));
    }

    private static JPanel createSection(TitledBorder border) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(border);
        return jPanel;
    }

    public SettingsGUIPaper() {
        super(new GridBagLayout());
        this.jSpinnerCrop.setEditor(new JSpinner.NumberEditor(this.jSpinnerCrop, "#0'%'"));
        this.setUnitSystem(UnitSystem.Metric);
        this.i18n();
        this.jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return SettingsGUIPaper.this.xmlFileFilter;
            }
        });
        this.jButtonImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsGUIPaper.this.importFromXml();
            }
        });
        this.jButtonExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsGUIPaper.this.exportToXml();
            }
        });
        this.jButtonDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsGUIPaper.this.resetToDefaults();
            }
        });
        this.jComboBoxFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaperSize.Format format = (PaperSize.Format)((Object)SettingsGUIPaper.this.jComboBoxFormat.getSelectedItem());
                double width = SettingsGUIPaper.this.unitSystem.pointsToUnits(format.width);
                double height = SettingsGUIPaper.this.unitSystem.pointsToUnits(format.height);
                SettingsGUIPaper.this.modelWidth.setValue(width);
                SettingsGUIPaper.this.modelHeight.setValue(height);
            }
        });
        this.jCheckBoxWgsGrid.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = e.getStateChange() != 2;
                SettingsGUIPaper.this.jComboBoxWgsDensity.setEnabled(enabled);
            }
        });
        this.jRadioButtonCustom.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = e.getStateChange() != 2;
                SettingsGUIPaper.this.jLabelWidth.setEnabled(enabled);
                SettingsGUIPaper.this.jLabelHeight.setEnabled(enabled);
                SettingsGUIPaper.this.jSpinnerWidth.setEnabled(enabled);
                SettingsGUIPaper.this.jSpinnerHeight.setEnabled(enabled);
            }
        });
        this.jRadioButtonDefault.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = e.getStateChange() != 2;
                SettingsGUIPaper.this.jComboBoxFormat.setEnabled(enabled);
                SettingsGUIPaper.this.jCheckBoxLandscape.setEnabled(enabled);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jRadioButtonSelection);
        buttonGroup.add(this.jRadioButtonDefault);
        buttonGroup.add(this.jRadioButtonCustom);
        GBCTable gbc = new GBCTable();
        this.jPanelSize.add((Component)this.jRadioButtonDefault, gbc.begin());
        this.jPanelSize.add((Component)this.jRadioButtonCustom, gbc.incY());
        this.jPanelSize.add((Component)this.jRadioButtonSelection, gbc.incY());
        this.jPanelSize.add((Component)this.jComboBoxFormat, gbc.incX());
        this.jPanelSize.add((Component)this.jLabelWidth, gbc.incY());
        this.jPanelSize.add((Component)this.jLabelHeight, gbc.incY());
        this.jPanelSize.add((Component)this.jCheckBoxLandscape, gbc.incX());
        this.jPanelSize.add((Component)this.jSpinnerWidth, gbc.incY());
        this.jPanelSize.add((Component)this.jSpinnerHeight, gbc.incY());
        this.jPanelSize.add(Box.createGlue(), gbc.incX().gridheight(3).fill());
        this.jPanelMargins.add((Component)this.jLabelMarginTop, gbc.begin());
        this.jPanelMargins.add((Component)this.jLabelMarginBottom, gbc.incY());
        this.jPanelMargins.add((Component)this.jSpinnerMarginTop, gbc.incX());
        this.jPanelMargins.add((Component)this.jSpinnerMarginBottom, gbc.incY());
        this.jPanelMargins.add((Component)this.jLabelMarginLeft, gbc.incX());
        this.jPanelMargins.add((Component)this.jLabelMarginRight, gbc.incY());
        this.jPanelMargins.add((Component)this.jSpinnerMarginLeft, gbc.incX());
        this.jPanelMargins.add((Component)this.jSpinnerMarginRight, gbc.incY());
        this.jPanelMargins.add(Box.createHorizontalGlue(), gbc.incX().fillH());
        this.jPanelAdditions.add((Component)this.jCheckBoxWgsGrid, gbc.begin());
        this.jPanelAdditions.add((Component)this.jCheckBoxPageNumbers, gbc.incY().gridwidth(2));
        this.jPanelAdditions.add((Component)this.jCheckBoxScaleBar, gbc.incY());
        this.jPanelAdditions.add((Component)this.jComboBoxWgsDensity, gbc.incX());
        gbc.incY();
        this.jPanelAdditions.add((Component)this.jCheckBoxCompass, gbc.incY());
        this.jPanelAdditions.add(Box.createHorizontalGlue(), gbc.incX().fillH());
        this.jPanelAdvanced.add((Component)this.jLabelDpi, gbc.begin());
        this.jPanelAdvanced.add((Component)this.jLabelCompression, gbc.incY());
        this.jPanelAdvanced.add((Component)this.jSpinnerDpi, gbc.incX());
        this.jPanelAdvanced.add((Component)this.jSpinnerCompression, gbc.incY());
        this.jPanelAdvanced.add((Component)this.jLabelOverlap, gbc.incX());
        this.jPanelAdvanced.add((Component)this.jLabelCrop, gbc.incY());
        this.jPanelAdvanced.add((Component)this.jSpinnerOverlap, gbc.incX());
        this.jPanelAdvanced.add((Component)this.jSpinnerCrop, gbc.incY());
        this.jPanelAdvanced.add(Box.createHorizontalGlue(), gbc.incX().fillH());
        this.jPanelActions.add((Component)this.jButtonImport, gbc.begin());
        this.jPanelActions.add((Component)this.jButtonExport, gbc.incX());
        this.jPanelActions.add((Component)this.jButtonDefaults, gbc.incX());
        this.jPanelActions.add(Box.createHorizontalGlue(), gbc.incX().fillH());
        gbc = new GBCTable(0);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.jPanelSize, gbc.begin());
        this.add((Component)this.jPanelMargins, gbc.incY());
        this.add((Component)this.jPanelAdditions, gbc.incX().fillH());
        this.add((Component)this.jPanelAdvanced, gbc.incY().fillH());
        this.add((Component)this.jPanelActions, gbc.begin(1, 3).gridwidth(2).fillH());
        this.add(Box.createGlue(), gbc.incY().gridwidth(2).fill());
    }

    private void importFromXml() {
        int state = this.jFileChooser.showOpenDialog(this);
        if (state == 0) {
            File file = this.jFileChooser.getSelectedFile();
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SettingsPaperAtlas.class});
                Unmarshaller um = context.createUnmarshaller();
                SettingsPaperAtlas s = (SettingsPaperAtlas)um.unmarshal(file);
                this.loadSettings(s);
            }
            catch (JAXBException ex) {
                String text = this.importError + file.getName() + "\n" + this.errorReason + ex.getMessage();
                JOptionPane.showMessageDialog(this, text, this.errorTitle, 0);
            }
        }
    }

    private void exportToXml() {
        int state = this.jFileChooser.showSaveDialog(this);
        if (state == 0) {
            File file = this.jFileChooser.getSelectedFile();
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SettingsPaperAtlas.class});
                Marshaller m = context.createMarshaller();
                SettingsPaperAtlas s = new SettingsPaperAtlas();
                this.applySettings(s);
                m.marshal((Object)s, file);
            }
            catch (JAXBException ex) {
                String text = this.exportError + file.getName() + "\n" + this.errorReason + ex.getMessage();
                JOptionPane.showMessageDialog(this, text, this.errorTitle, 0);
            }
        }
    }

    private void resetToDefaults() {
        this.loadSettings(new SettingsPaperAtlas());
    }

    private void i18n() {
        this.setName(I18nUtils.localizedStringForKey("set_paper_title", new Object[0]));
        this.titledBorderActions.setTitle(I18nUtils.localizedStringForKey("set_paper_actions", new Object[0]));
        this.titledBorderAdditions.setTitle(I18nUtils.localizedStringForKey("set_paper_additions", new Object[0]));
        this.titledBorderAdvanced.setTitle(I18nUtils.localizedStringForKey("set_paper_advanced", new Object[0]));
        this.titledBorderMargins.setTitle(I18nUtils.localizedStringForKey("set_paper_margins", new Object[0]));
        this.titledBorderSize.setTitle(I18nUtils.localizedStringForKey("set_paper_size", new Object[0]));
        this.jComboBoxFormat.setToolTipText(I18nUtils.localizedStringForKey("set_paper_size_default_format_tips", new Object[0]));
        this.jComboBoxWgsDensity.setToolTipText(I18nUtils.localizedStringForKey("set_paper_wgs_grid_density_tips", new Object[0]));
        this.jRadioButtonSelection.setText(I18nUtils.localizedStringForKey("set_paper_size_selection", new Object[0]));
        this.jRadioButtonSelection.setToolTipText(I18nUtils.localizedStringForKey("set_paper_size_selection_tips", new Object[0]));
        this.jRadioButtonDefault.setText(I18nUtils.localizedStringForKey("set_paper_size_default", new Object[0]));
        this.jRadioButtonDefault.setToolTipText(I18nUtils.localizedStringForKey("set_paper_size_default_tips", new Object[0]));
        this.jRadioButtonCustom.setText(I18nUtils.localizedStringForKey("set_paper_size_custom", new Object[0]));
        this.jRadioButtonCustom.setToolTipText(I18nUtils.localizedStringForKey("set_paper_size_custom_tips", new Object[0]));
        this.jCheckBoxScaleBar.setText(I18nUtils.localizedStringForKey("set_paper_scale_bar", new Object[0]));
        this.jCheckBoxScaleBar.setToolTipText(I18nUtils.localizedStringForKey("set_paper_scale_tips", new Object[0]));
        this.jCheckBoxCompass.setText(I18nUtils.localizedStringForKey("set_paper_compass", new Object[0]));
        this.jCheckBoxCompass.setToolTipText(I18nUtils.localizedStringForKey("set_paper_compass_tips", new Object[0]));
        this.jCheckBoxLandscape.setText(I18nUtils.localizedStringForKey("set_paper_size_default_landscape", new Object[0]));
        this.jCheckBoxLandscape.setToolTipText(I18nUtils.localizedStringForKey("set_paper_size_default_landscape_tips", new Object[0]));
        this.jCheckBoxWgsGrid.setText(I18nUtils.localizedStringForKey(I18nUtils.localizedStringForKey("set_paper_wgs_grid", new Object[0]), new Object[0]));
        this.jCheckBoxWgsGrid.setToolTipText(I18nUtils.localizedStringForKey("set_paper_wgs_grid_tips", new Object[0]));
        this.jCheckBoxPageNumbers.setText(I18nUtils.localizedStringForKey("set_paper_paper_nubmer", new Object[0]));
        this.jCheckBoxPageNumbers.setToolTipText(I18nUtils.localizedStringForKey("set_paper_paper_nubmer_tips", new Object[0]));
        this.jLabelCompression.setText(I18nUtils.localizedStringForKey("set_paper_advanced_compression", new Object[0]));
        String compression = I18nUtils.localizedStringForKey("set_paper_advanced_compression_tips", new Object[0]);
        this.jLabelCompression.setToolTipText(compression);
        this.jSpinnerCompression.setToolTipText(compression);
        this.jLabelDpi.setText(I18nUtils.localizedStringForKey("set_paper_advanced_dpi", new Object[0]));
        String dpi = I18nUtils.localizedStringForKey("set_paper_advanced_dpi_tips", new Object[0]);
        this.jLabelDpi.setToolTipText(dpi);
        this.jSpinnerDpi.setToolTipText(dpi);
        this.jLabelWidth.setText(I18nUtils.localizedStringForKey("set_paper_size_custom_width", new Object[0]));
        String width = I18nUtils.localizedStringForKey("set_paper_size_custom_width_tips", new Object[0]);
        this.jLabelWidth.setToolTipText(width);
        this.jSpinnerWidth.setToolTipText(width);
        this.jLabelHeight.setText(I18nUtils.localizedStringForKey("set_paper_size_custom_height", new Object[0]));
        String height = I18nUtils.localizedStringForKey("set_paper_size_custom_height_tips", new Object[0]);
        this.jLabelHeight.setToolTipText(height);
        this.jSpinnerHeight.setToolTipText(height);
        String margin = I18nUtils.localizedStringForKey("set_paper_margins_tips", new Object[0]);
        this.jLabelMarginTop.setText(I18nUtils.localizedStringForKey("set_paper_margins_top", new Object[0]));
        this.jLabelMarginTop.setToolTipText(margin);
        this.jSpinnerMarginTop.setToolTipText(margin);
        this.jLabelMarginLeft.setText(I18nUtils.localizedStringForKey("set_paper_margins_left", new Object[0]));
        this.jLabelMarginLeft.setToolTipText(margin);
        this.jSpinnerMarginLeft.setToolTipText(margin);
        this.jLabelMarginBottom.setText(I18nUtils.localizedStringForKey("set_paper_margins_bottom", new Object[0]));
        this.jLabelMarginBottom.setToolTipText(margin);
        this.jSpinnerMarginBottom.setToolTipText(margin);
        this.jLabelMarginRight.setText(I18nUtils.localizedStringForKey("set_paper_margins_right", new Object[0]));
        this.jLabelMarginRight.setToolTipText(margin);
        this.jSpinnerMarginRight.setToolTipText(margin);
        this.jLabelOverlap.setText(I18nUtils.localizedStringForKey("set_paper_advanced_overlap", new Object[0]));
        String overlap = I18nUtils.localizedStringForKey("set_paper_advanced_overlap_tips", new Object[0]);
        this.jLabelOverlap.setToolTipText(overlap);
        this.jSpinnerOverlap.setToolTipText(overlap);
        this.jLabelCrop.setText(I18nUtils.localizedStringForKey("set_paper_advanced_crop", new Object[0]));
        String crop = I18nUtils.localizedStringForKey("set_paper_advanced_crop_tips", new Object[0]);
        this.jLabelCrop.setToolTipText(crop);
        this.jSpinnerCrop.setToolTipText(crop);
        this.jButtonImport.setText(I18nUtils.localizedStringForKey("set_paper_actions_import_xml", new Object[0]));
        this.jButtonImport.setToolTipText(I18nUtils.localizedStringForKey("set_paper_actions_import_xml_tip", new Object[0]));
        this.jButtonExport.setText(I18nUtils.localizedStringForKey("set_paper_actions_export_xml", new Object[0]));
        this.jButtonExport.setToolTipText(I18nUtils.localizedStringForKey("set_paper_actions_export_xml_tip", new Object[0]));
        this.jButtonDefaults.setText(I18nUtils.localizedStringForKey("set_paper_actions_restore_default", new Object[0]));
        this.jButtonDefaults.setToolTipText(I18nUtils.localizedStringForKey("set_paper_actions_restore_default_tips", new Object[0]));
        this.importError = I18nUtils.localizedStringForKey("set_paper_actions_error_import", new Object[0]);
        this.exportError = I18nUtils.localizedStringForKey("set_paper_actions_error_export", new Object[0]);
        this.errorReason = I18nUtils.localizedStringForKey("set_paper_actions_error_reason", new Object[0]);
        this.errorTitle = I18nUtils.localizedStringForKey("set_paper_actions_error_title", new Object[0]);
        this.xmlFileFilter = I18nUtils.localizedStringForKey("set_paper_actions_xml_filter", new Object[0]);
    }

    private void setUnitSystem(UnitSystem unitSystem) {
        if (unitSystem.equals((Object)this.unitSystem)) {
            return;
        }
        this.unitSystem = unitSystem;
        Double step = 0.1;
        double min = unitSystem.pointsToUnits(0.0);
        double max = unitSystem.pointsToUnits(144.0);
        SettingsGUIPaper.setModel(this.modelMarginBottom, min, max, step);
        SettingsGUIPaper.setModel(this.modelMarginLeft, min, max, step);
        SettingsGUIPaper.setModel(this.modelMarginRight, min, max, step);
        SettingsGUIPaper.setModel(this.modelMarginTop, min, max, step);
        min = unitSystem.pointsToUnits(1.0);
        max = unitSystem.pointsToUnits(16384.0);
        SettingsGUIPaper.setModel(this.modelWidth, min, max, step);
        SettingsGUIPaper.setModel(this.modelHeight, min, max, step);
        min = unitSystem.pointsToUnits(0.0);
        max = unitSystem.pointsToUnits(144.0);
        SettingsGUIPaper.setModel(this.modelOverlap, min, max, step);
        String pattern = "#0.00 " + unitSystem.unitTiny;
        SettingsGUIPaper.setEditor(this.jSpinnerWidth, pattern);
        SettingsGUIPaper.setEditor(this.jSpinnerHeight, pattern);
        SettingsGUIPaper.setEditor(this.jSpinnerMarginTop, pattern);
        SettingsGUIPaper.setEditor(this.jSpinnerMarginLeft, pattern);
        SettingsGUIPaper.setEditor(this.jSpinnerMarginBottom, pattern);
        SettingsGUIPaper.setEditor(this.jSpinnerMarginRight, pattern);
        SettingsGUIPaper.setEditor(this.jSpinnerOverlap, pattern);
    }

    private PaperSize getPaperSize() {
        if (this.jRadioButtonDefault.isSelected()) {
            PaperSize.Format format = (PaperSize.Format)((Object)this.jComboBoxFormat.getSelectedItem());
            boolean landscape = this.jCheckBoxLandscape.isSelected();
            return new PaperSize(format, landscape);
        }
        if (this.jRadioButtonCustom.isSelected()) {
            double width = this.modelWidth.getNumber().doubleValue();
            double height = this.modelHeight.getNumber().doubleValue();
            width = this.unitSystem.unitsToPoints(width);
            height = this.unitSystem.unitsToPoints(height);
            return new PaperSize(width, height);
        }
        return null;
    }

    private void setPaperSize(PaperSize paperSize) {
        if (paperSize == null) {
            this.jRadioButtonSelection.setSelected(true);
            return;
        }
        if (paperSize.format != null) {
            this.jRadioButtonDefault.setSelected(true);
            this.jComboBoxFormat.setSelectedIndex(paperSize.format.ordinal());
            this.jCheckBoxLandscape.setSelected(paperSize.landscape);
        } else {
            this.jRadioButtonCustom.setSelected(true);
        }
    }

    public void loadSettings(Settings s) {
        this.setUnitSystem(s.unitSystem);
        this.loadSettings(s.paperAtlas);
    }

    public void loadSettings(SettingsPaperAtlas s) {
        this.setPaperSize(s.paperSize);
        this.modelMarginTop.setValue(this.unitSystem.pointsToUnits(s.marginTop));
        this.modelMarginLeft.setValue(this.unitSystem.pointsToUnits(s.marginLeft));
        this.modelMarginBottom.setValue(this.unitSystem.pointsToUnits(s.marginBottom));
        this.modelMarginRight.setValue(this.unitSystem.pointsToUnits(s.marginRight));
        this.jCheckBoxScaleBar.setSelected(s.scaleBar);
        this.jCheckBoxCompass.setSelected(s.compass);
        this.jComboBoxWgsDensity.setSelectedItem((Object)s.wgsDensity);
        this.jCheckBoxWgsGrid.setSelected(s.wgsEnabled);
        this.jCheckBoxPageNumbers.setSelected(s.pageNumbers);
        this.modelCrop.setValue(s.crop);
        this.modelOverlap.setValue(this.unitSystem.pointsToUnits(s.overlap));
        this.modelCompression.setValue(s.compression);
        this.modelDpi.setValue(s.dpi);
    }

    public void applySettings(Settings s) {
        this.applySettings(s.paperAtlas);
    }

    public void applySettings(SettingsPaperAtlas s) {
        s.paperSize = this.getPaperSize();
        s.marginTop = this.unitSystem.unitsToPoints(this.modelMarginTop.getNumber().doubleValue());
        s.marginLeft = this.unitSystem.unitsToPoints(this.modelMarginLeft.getNumber().doubleValue());
        s.marginBottom = this.unitSystem.unitsToPoints(this.modelMarginBottom.getNumber().doubleValue());
        s.marginRight = this.unitSystem.unitsToPoints(this.modelMarginRight.getNumber().doubleValue());
        s.scaleBar = this.jCheckBoxScaleBar.isSelected();
        s.compass = this.jCheckBoxCompass.isSelected();
        s.wgsDensity = (WgsGrid.WgsDensity)((Object)this.jComboBoxWgsDensity.getSelectedItem());
        s.wgsEnabled = this.jCheckBoxWgsGrid.isSelected();
        s.pageNumbers = this.jCheckBoxPageNumbers.isSelected();
        s.crop = this.modelCrop.getNumber().intValue();
        s.overlap = this.unitSystem.unitsToPoints(this.modelOverlap.getNumber().doubleValue());
        s.compression = this.modelCompression.getNumber().intValue();
        s.dpi = this.modelDpi.getNumber().intValue();
    }
}

