/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import mobac.gui.dialogs.FontChooser;
import mobac.gui.settings.SettingsGUI;
import mobac.program.model.Settings;
import mobac.program.model.SettingsWgsGrid;
import mobac.utilities.GBCTable;
import mobac.utilities.I18nUtils;

public class SettingsGUIWgsGrid
extends JPanel {
    private static final long serialVersionUID = -3067609813682787669L;
    private final FontChooser fontChooser = new FontChooser();
    private final JButton jButtonFont = new JButton(FontChooser.encodeFont(FontChooser.DEFAULT));
    private final JCheckBox jCheckBoxCompressLabels = new JCheckBox();
    private final JPanel jPanelColor = new JPanel();
    private final SpinnerNumberModel modelWidth = new SpinnerNumberModel(0.5, 0.5, 5.0, 0.5);
    private final JSpinner jSpinnerWidth = new JSpinner(this.modelWidth);
    private JLabel jLabelColor = new JLabel();
    private JLabel jLabelFont = new JLabel();
    private JLabel jLabelWidth = new JLabel();
    private String title;

    public SettingsGUIWgsGrid() {
        super(new GridBagLayout());
        this.i18n();
        this.jButtonFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsGUIWgsGrid.this.fontChooser.show();
                if (SettingsGUIWgsGrid.this.fontChooser.wasCanceled()) {
                    return;
                }
                String text = FontChooser.encodeFont(SettingsGUIWgsGrid.this.fontChooser.getFont());
                SettingsGUIWgsGrid.this.jButtonFont.setText(text);
            }
        });
        this.jPanelColor.setPreferredSize(new Dimension(64, 18));
        this.jPanelColor.setOpaque(true);
        this.jPanelColor.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelColor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Color color = SettingsGUIWgsGrid.this.jPanelColor.getBackground();
                color = JColorChooser.showDialog(SettingsGUIWgsGrid.this.jPanelColor, SettingsGUIWgsGrid.this.title, color);
                if (color != null) {
                    SettingsGUIWgsGrid.this.jPanelColor.setBackground(color);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                SettingsGUIWgsGrid.this.jPanelColor.setBorder(BorderFactory.createRaisedBevelBorder());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SettingsGUIWgsGrid.this.jPanelColor.setBorder(BorderFactory.createEtchedBorder());
            }
        });
        GBCTable gbc = new GBCTable();
        this.add((Component)this.jLabelColor, gbc.begin());
        this.add((Component)this.jLabelWidth, gbc.incY());
        this.add((Component)this.jPanelColor, gbc.incX());
        this.add((Component)this.jSpinnerWidth, gbc.incY());
        this.add((Component)this.jLabelFont, gbc.incX());
        this.add((Component)this.jCheckBoxCompressLabels, gbc.incY().gridwidth(3));
        this.add((Component)this.jButtonFont, gbc.incX());
        this.add(Box.createHorizontalGlue(), gbc.incX().fillH());
    }

    public void i18n() {
        this.jCheckBoxCompressLabels.setText(I18nUtils.localizedStringForKey("set_display_grid_compress", new Object[0]));
        this.jCheckBoxCompressLabels.setToolTipText(I18nUtils.localizedStringForKey("set_display_grid_compress_tips", new Object[0]));
        this.setBorder(SettingsGUI.createSectionBorder(I18nUtils.localizedStringForKey("set_display_grid", new Object[0])));
        this.title = I18nUtils.localizedStringForKey("set_display_grid_title", new Object[0]);
        this.jLabelWidth.setText(I18nUtils.localizedStringForKey("set_display_grid_width", new Object[0]));
        String width = I18nUtils.localizedStringForKey("set_display_grid_width_tips", new Object[0]);
        this.jLabelWidth.setToolTipText(width);
        this.jSpinnerWidth.setToolTipText(width);
        this.jLabelColor.setText(I18nUtils.localizedStringForKey("set_display_grid_color", new Object[0]));
        String color = I18nUtils.localizedStringForKey("set_display_grid_color_tips", new Object[0]);
        this.jLabelColor.setToolTipText(color);
        this.jPanelColor.setToolTipText(color);
        this.jLabelFont.setText(I18nUtils.localizedStringForKey("set_display_grid_font", new Object[0]));
        String font = I18nUtils.localizedStringForKey("set_display_grid_font_tips", new Object[0]);
        this.jLabelFont.setToolTipText(font);
        this.jButtonFont.setToolTipText(font);
    }

    public void applySettings(Settings s) {
        this.applySettings(s.wgsGrid);
    }

    public void applySettings(SettingsWgsGrid s) {
        s.compressLabels = this.jCheckBoxCompressLabels.isSelected();
        s.font = this.fontChooser.getFont();
        s.color = this.jPanelColor.getBackground();
        s.width = this.modelWidth.getNumber().floatValue();
    }

    public void loadSettings(Settings s) {
        this.loadSettings(s.wgsGrid);
    }

    public void loadSettings(SettingsWgsGrid s) {
        this.jCheckBoxCompressLabels.setSelected(s.compressLabels);
        this.fontChooser.setFont(s.font);
        this.jButtonFont.setText(FontChooser.encodeFont(s.font));
        this.jPanelColor.setBackground(s.color);
        this.modelWidth.setValue(s.width);
    }
}

