/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.imageio.ImageIO;
import mobac.exceptions.MapSourceInitializationException;
import mobac.exceptions.TileException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.download.TileDownLoader;
import mobac.program.interfaces.HttpMapSource;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSourceListener;
import mobac.program.interfaces.MapSpace;
import mobac.program.model.MapSourceLoaderInfo;
import mobac.program.model.TileImageType;
import mobac.program.tilestore.TileStore;
import mobac.program.tilestore.TileStoreEntry;
import org.apache.log4j.Logger;

public abstract class AbstractHttpMapSource
implements HttpMapSource {
    protected Logger log;
    private boolean initialized = false;
    protected String name;
    protected int minZoom;
    protected int maxZoom;
    protected TileImageType tileType;
    protected HttpMapSource.TileUpdate tileUpdate;
    protected MapSpace mapSpace = MercatorPower2MapSpace.INSTANCE_256;
    protected MapSourceLoaderInfo loaderInfo = null;

    public AbstractHttpMapSource(String name, int minZoom, int maxZoom, TileImageType tileType) {
        this(name, minZoom, maxZoom, tileType, HttpMapSource.TileUpdate.None);
    }

    protected AbstractHttpMapSource() {
    }

    public AbstractHttpMapSource(String name, int minZoom, int maxZoom, TileImageType tileType, HttpMapSource.TileUpdate tileUpdate) {
        this.log = Logger.getLogger(this.getClass());
        this.name = name;
        this.minZoom = minZoom;
        this.maxZoom = Math.min(maxZoom, 22);
        this.tileType = tileType;
        this.tileUpdate = tileUpdate;
    }

    public boolean ignoreContentMismatch() {
        return false;
    }

    @Override
    public HttpURLConnection getTileUrlConnection(int zoom, int tilex, int tiley) throws IOException {
        String url = this.getTileUrl(zoom, tilex, tiley);
        if (url == null) {
            return null;
        }
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        this.prepareTileUrlConnection(conn);
        return conn;
    }

    protected void prepareTileUrlConnection(HttpURLConnection conn) {
    }

    public abstract String getTileUrl(int var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void initializeHttpMapSource() {
        if (this.initialized) {
            return;
        }
        try {
            AbstractHttpMapSource abstractHttpMapSource = this;
            synchronized (abstractHttpMapSource) {
                if (this.initialized) {
                    return;
                }
                this.initernalInitialize();
                this.initialized = true;
                this.log.debug("Map source has been initialized");
            }
        }
        catch (Exception e) {
            this.log.error("Map source initialization failed: " + e.getMessage(), e);
        }
        this.initialized = true;
    }

    protected void initernalInitialize() throws MapSourceInitializationException {
    }

    @Override
    public byte[] getTileData(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
        if (loadMethod == MapSource.LoadMethod.CACHE) {
            TileStoreEntry entry = TileStore.getInstance().getTile(x, y, zoom, this);
            if (entry == null) {
                return null;
            }
            byte[] data = entry.getData();
            if (Thread.currentThread() instanceof MapSourceListener) {
                ((MapSourceListener)((Object)Thread.currentThread())).tileDownloaded(data.length);
            }
            return data;
        }
        if (loadMethod == MapSource.LoadMethod.SOURCE) {
            this.initializeHttpMapSource();
            return TileDownLoader.downloadTileAndUpdateStore(x, y, zoom, this);
        }
        this.initializeHttpMapSource();
        return TileDownLoader.getImage(x, y, zoom, this);
    }

    @Override
    public BufferedImage getTileImage(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
        byte[] data = this.getTileData(zoom, x, y, loadMethod);
        if (data == null) {
            return null;
        }
        return ImageIO.read(new ByteArrayInputStream(data));
    }

    @Override
    public int getMaxZoom() {
        return this.maxZoom;
    }

    @Override
    public int getMinZoom() {
        return this.minZoom;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getStoreName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public TileImageType getTileImageType() {
        return this.tileType;
    }

    @Override
    public HttpMapSource.TileUpdate getTileUpdate() {
        return this.tileUpdate;
    }

    public boolean allowFileStore() {
        return true;
    }

    @Override
    public MapSpace getMapSpace() {
        return this.mapSpace;
    }

    @Override
    public Color getBackgroundColor() {
        return Color.BLACK;
    }

    @Override
    public MapSourceLoaderInfo getLoaderInfo() {
        return this.loaderInfo;
    }

    @Override
    public void setLoaderInfo(MapSourceLoaderInfo loaderInfo) {
        if (this.loaderInfo != null) {
            throw new RuntimeException("LoaderInfo already set for map source " + this.name);
        }
        this.loaderInfo = loaderInfo;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapSource)) {
            return false;
        }
        MapSource other = (MapSource)obj;
        return other.getName().equals(this.getName());
    }
}

