/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.xml.bind.annotation.XmlTransient;
import mobac.exceptions.MapSourceInitializationException;
import mobac.exceptions.TileException;
import mobac.program.interfaces.InitializableMapSource;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.model.MapSourceLoaderInfo;
import mobac.program.model.TileImageType;
import org.apache.log4j.Logger;

public abstract class AbstractMultiLayerMapSource
implements InitializableMapSource,
Iterable<MapSource> {
    protected Logger log;
    protected String name = "";
    protected TileImageType tileType = TileImageType.PNG;
    protected MapSource[] mapSources;
    private int maxZoom;
    private int minZoom;
    private MapSpace mapSpace;
    protected MapSourceLoaderInfo loaderInfo = null;

    public AbstractMultiLayerMapSource(String name, TileImageType tileImageType) {
        this();
        this.name = name;
        this.tileType = tileImageType;
    }

    protected AbstractMultiLayerMapSource() {
        this.log = Logger.getLogger(this.getClass());
    }

    protected void initializeValues() {
        MapSource refMapSource = this.mapSources[0];
        this.mapSpace = refMapSource.getMapSpace();
        this.maxZoom = 22;
        this.minZoom = 0;
        for (MapSource ms : this.mapSources) {
            this.maxZoom = Math.min(this.maxZoom, ms.getMaxZoom());
            this.minZoom = Math.max(this.minZoom, ms.getMinZoom());
            if (ms.getMapSpace().equals(this.mapSpace)) continue;
            throw new RuntimeException("Different map spaces used in multi-layer map source");
        }
    }

    @Override
    public void initialize() throws MapSourceInitializationException {
        MapSource refMapSource = this.mapSources[0];
        this.mapSpace = refMapSource.getMapSpace();
        this.maxZoom = 22;
        this.minZoom = 0;
        for (MapSource ms : this.mapSources) {
            if (ms instanceof InitializableMapSource) {
                ((InitializableMapSource)ms).initialize();
            }
            this.maxZoom = Math.min(this.maxZoom, ms.getMaxZoom());
            this.minZoom = Math.max(this.minZoom, ms.getMinZoom());
        }
    }

    public MapSource[] getLayerMapSources() {
        return this.mapSources;
    }

    @Override
    public Color getBackgroundColor() {
        return Color.BLACK;
    }

    @Override
    public MapSpace getMapSpace() {
        return this.mapSpace;
    }

    @Override
    public int getMaxZoom() {
        return this.maxZoom;
    }

    @Override
    public int getMinZoom() {
        return this.minZoom;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getStoreName() {
        return null;
    }

    @Override
    public byte[] getTileData(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, InterruptedException, TileException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream(16000);
        BufferedImage image = this.getTileImage(zoom, x, y, loadMethod);
        if (image == null) {
            return null;
        }
        ImageIO.write((RenderedImage)image, this.tileType.getFileExt(), buf);
        return buf.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getTileImage(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, InterruptedException, TileException {
        BufferedImage image = null;
        Graphics g2 = null;
        try {
            int i;
            ArrayList<BufferedImage> layerImages = new ArrayList<BufferedImage>(this.mapSources.length);
            int maxSize = this.mapSpace.getTileSize();
            for (i = 0; i < this.mapSources.length; ++i) {
                MapSource layerMapSource = this.mapSources[i];
                BufferedImage layerImage = layerMapSource.getTileImage(zoom, x, y, loadMethod);
                if (layerImage == null) continue;
                this.log.debug("Multi layer loading: " + layerMapSource + " " + x + " " + y + " " + zoom);
                layerImages.add(layerImage);
                int size = layerImage.getWidth();
                if (size <= maxSize) continue;
                maxSize = size;
            }
            image = new BufferedImage(maxSize, maxSize, 5);
            g2 = image.createGraphics();
            g2.setColor(this.getBackgroundColor());
            g2.fillRect(0, 0, maxSize, maxSize);
            for (i = 0; i < layerImages.size(); ++i) {
                BufferedImage layerImage = (BufferedImage)layerImages.get(i);
                ((Graphics2D)g2).setComposite(AlphaComposite.getInstance(3, this.getLayerAlpha(i)));
                g2.drawImage(layerImage, 0, 0, maxSize, maxSize, null);
            }
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            if (g2 != null) {
                g2.dispose();
            }
        }
    }

    protected float getLayerAlpha(int layerIndex) {
        return 1.0f;
    }

    @Override
    public TileImageType getTileImageType() {
        return this.tileType;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Iterator<MapSource> iterator() {
        return Arrays.asList(this.mapSources).iterator();
    }

    @Override
    @XmlTransient
    public MapSourceLoaderInfo getLoaderInfo() {
        return this.loaderInfo;
    }

    @Override
    public void setLoaderInfo(MapSourceLoaderInfo loaderInfo) {
        if (this.loaderInfo != null) {
            throw new RuntimeException("LoaderInfo already set");
        }
        this.loaderInfo = loaderInfo;
        for (MapSource ms : this.mapSources) {
            ms.setLoaderInfo(loaderInfo);
        }
    }
}

