/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JOptionPane;
import mobac.mapsources.AbstractMultiLayerMapSource;
import mobac.mapsources.MapSourcesManager;
import mobac.mapsources.MapsforgeMapSource;
import mobac.mapsources.custom.StandardMapSourceLayer;
import mobac.mapsources.impl.DebugLocalMapSource;
import mobac.mapsources.impl.DebugMapSource;
import mobac.mapsources.impl.DebugRandomLocalMapSource;
import mobac.mapsources.impl.DebugTransparentLocalMapSource;
import mobac.mapsources.impl.SimpleMapSource;
import mobac.mapsources.loader.BeanShellMapSourceLoader;
import mobac.mapsources.loader.CustomMapSourceLoader;
import mobac.mapsources.loader.EclipseMapPackLoader;
import mobac.mapsources.loader.MapPackManager;
import mobac.program.interfaces.MapSource;
import mobac.program.model.Settings;
import mobac.utilities.I18nUtils;
import org.apache.log4j.Logger;

public class DefaultMapSourcesManager
extends MapSourcesManager {
    private Logger log = Logger.getLogger(DefaultMapSourcesManager.class);
    private LinkedHashMap<String, MapSource> allMapSources = new LinkedHashMap(50);
    private HashMap<String, MapSource> allAvailableMapSources = new HashMap(50);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadMapSources() {
        try {
            File mapSourcesDir;
            boolean devMode = Settings.getInstance().devMode;
            this.addMapSource(new MapsforgeMapSource());
            if (devMode) {
                this.addMapSource(new DebugMapSource());
                this.addMapSource(new DebugLocalMapSource());
                this.addMapSource(new DebugTransparentLocalMapSource());
                this.addMapSource(new DebugRandomLocalMapSource());
            }
            if ((mapSourcesDir = Settings.getInstance().getMapSourcesDirectory()) == null) {
                throw new RuntimeException("Map sources directory is unset");
            }
            if (!mapSourcesDir.isDirectory()) {
                JOptionPane.showMessageDialog(null, String.format(I18nUtils.localizedStringForKey("msg_environment_mapsrc_dir_not_exist", new Object[0]), mapSourcesDir.getAbsolutePath()), I18nUtils.localizedStringForKey("Error", new Object[0]), 0);
                return;
            }
            try {
                MapPackManager mpm = new MapPackManager(mapSourcesDir);
                mpm.installUpdates();
                if (!this.loadMapPacksEclipseMode()) {
                    mpm.loadMapPacks(this);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load map packs: " + e.getMessage(), e);
            }
            BeanShellMapSourceLoader bsmsl = new BeanShellMapSourceLoader(this, mapSourcesDir);
            bsmsl.loadBeanShellMapSources();
            CustomMapSourceLoader cmsl = new CustomMapSourceLoader(this, mapSourcesDir);
            cmsl.loadCustomMapSources();
        }
        finally {
            if (this.allMapSources.size() == 0) {
                this.addMapSource(new SimpleMapSource());
            }
        }
    }

    private boolean loadMapPacksEclipseMode() {
        try {
            EclipseMapPackLoader empl = new EclipseMapPackLoader(this);
            return empl.loadMapPacks();
        }
        catch (IOException e) {
            this.log.error("Failed to load map packs directly from classpath");
            return false;
        }
    }

    @Override
    public void addMapSource(MapSource mapSource) {
        String mapSourceName;
        if (mapSource instanceof StandardMapSourceLayer) {
            mapSource = ((StandardMapSourceLayer)mapSource).getMapSource();
        }
        this.allAvailableMapSources.put(mapSource.getName(), mapSource);
        if (mapSource instanceof AbstractMultiLayerMapSource) {
            for (MapSource lms : (AbstractMultiLayerMapSource)mapSource) {
                MapSource old;
                if (lms instanceof StandardMapSourceLayer) {
                    lms = ((StandardMapSourceLayer)lms).getMapSource();
                }
                if ((old = this.allAvailableMapSources.put(lms.getName(), lms)) == null) continue;
                this.allAvailableMapSources.put(old.getName(), old);
                if (!mapSource.equals(old)) continue;
                JOptionPane.showMessageDialog(null, "Error: Duplicate map source name found: " + mapSource.getName(), "Duplicate name", 0);
            }
        }
        if (this.allMapSources.containsKey(mapSourceName = mapSource.getName())) {
            JOptionPane.showMessageDialog(null, String.format(I18nUtils.localizedStringForKey("msg_environment_error_duplicate_map_source", new Object[0]), mapSourceName, mapSource.getLoaderInfo().getSourceFile()), I18nUtils.localizedStringForKey("Error", new Object[0]), 0);
        } else {
            this.allMapSources.put(mapSourceName, mapSource);
        }
    }

    public static void initialize() {
        INSTANCE = new DefaultMapSourcesManager();
        ((DefaultMapSourcesManager)INSTANCE).loadMapSources();
    }

    public static void initializeEclipseMapPacksOnly() {
        INSTANCE = new DefaultMapSourcesManager();
        ((DefaultMapSourcesManager)INSTANCE).loadMapPacksEclipseMode();
    }

    @Override
    public Vector<MapSource> getAllAvailableMapSources() {
        return new Vector<MapSource>(this.allMapSources.values());
    }

    @Override
    public Vector<MapSource> getAllMapSources() {
        return new Vector<MapSource>(this.allMapSources.values());
    }

    @Override
    public Vector<MapSource> getAllLayerMapSources() {
        Vector<MapSource> all = this.getAllMapSources();
        TreeSet<MapSource> uniqueSources = new TreeSet<MapSource>(new Comparator<MapSource>(){

            @Override
            public int compare(MapSource o1, MapSource o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (MapSource ms : all) {
            if (ms instanceof AbstractMultiLayerMapSource) {
                for (MapSource lms : (AbstractMultiLayerMapSource)ms) {
                    uniqueSources.add(lms);
                }
                continue;
            }
            uniqueSources.add(ms);
        }
        Vector<MapSource> result = new Vector<MapSource>(uniqueSources);
        return result;
    }

    @Override
    public Vector<MapSource> getEnabledOrderedMapSources() {
        MapSource ms;
        Vector<MapSource> mapSources = new Vector<MapSource>(this.allMapSources.size());
        Vector<String> enabledMapSources = Settings.getInstance().mapSourcesEnabled;
        TreeSet<String> notEnabledMapSources = new TreeSet<String>(this.allMapSources.keySet());
        notEnabledMapSources.removeAll(enabledMapSources);
        for (String mapSourceName : enabledMapSources) {
            ms = this.getSourceByName(mapSourceName);
            if (ms == null) continue;
            mapSources.add(ms);
        }
        notEnabledMapSources.removeAll(Settings.getInstance().mapSourcesDisabled);
        for (String mapSourceName : notEnabledMapSources) {
            ms = this.getSourceByName(mapSourceName);
            if (ms == null) continue;
            mapSources.add(ms);
        }
        if (mapSources.size() == 0) {
            mapSources.add(new SimpleMapSource());
        }
        return mapSources;
    }

    @Override
    public Vector<MapSource> getDisabledMapSources() {
        Vector<String> disabledMapSources = Settings.getInstance().mapSourcesDisabled;
        Vector<MapSource> mapSources = new Vector<MapSource>(disabledMapSources.size());
        for (String mapSourceName : disabledMapSources) {
            MapSource ms = this.getSourceByName(mapSourceName);
            if (ms == null) continue;
            mapSources.add(ms);
        }
        return mapSources;
    }

    @Override
    public MapSource getDefaultMapSource() {
        MapSource ms = this.getSourceByName("MapQuest");
        if (ms != null) {
            return ms;
        }
        return this.allMapSources.values().iterator().next();
    }

    @Override
    public MapSource getSourceByName(String name) {
        return this.allAvailableMapSources.get(name);
    }
}

