/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources;

import java.security.SecureRandom;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;

public class MapSourceTools {
    protected static final char[] NUM_CHAR = new char[]{'0', '1', '2', '3'};
    public static final SecureRandom RND = new SecureRandom();

    public static String encodeQuadTree(int zoom, int tilex, int tiley) {
        char[] tileNum = new char[zoom];
        for (int i = zoom - 1; i >= 0; --i) {
            int num = tilex % 2 | tiley % 2 << 1;
            tileNum[i] = NUM_CHAR[num];
            tilex >>= 1;
            tiley >>= 1;
        }
        return new String(tileNum);
    }

    public static double[] calculateLatLon(MapSource mapSource, int zoom, int tilex, int tiley) {
        MapSpace mapSpace = mapSource.getMapSpace();
        int tileSize = mapSpace.getTileSize();
        double[] result = new double[]{mapSpace.cXToLon(tilex *= tileSize, zoom), mapSpace.cYToLat((tiley *= tileSize) + tileSize, zoom), mapSpace.cXToLon(tilex + tileSize, zoom), mapSpace.cYToLat(tiley, zoom)};
        return result;
    }

    public static String formatMapUrl(String mapUrl, int zoom, int tilex, int tiley) {
        String tmp = mapUrl;
        tmp = tmp.replace("{$x}", Integer.toString(tilex));
        tmp = tmp.replace("{$y}", Integer.toString(tiley));
        tmp = tmp.replace("{$z}", Integer.toString(zoom));
        tmp = tmp.replace("{$q}", MapSourceTools.encodeQuadTree(zoom, tilex, tiley));
        return tmp;
    }

    public static String formatMapUrl(String mapUrl, int serverNum, int zoom, int tilex, int tiley) {
        String tmp = mapUrl;
        tmp = tmp.replace("{$servernum}", Integer.toString(serverNum));
        return MapSourceTools.formatMapUrl(tmp, zoom, tilex, tiley);
    }

    public static String formatMapUrl(String mapUrl, String serverPart, int zoom, int tilex, int tiley) {
        String tmp = mapUrl;
        tmp = tmp.replace("{$serverpart}", serverPart);
        return MapSourceTools.formatMapUrl(tmp, zoom, tilex, tiley);
    }

    public static String getRandomServerPart(String[] serverParts) {
        return serverParts[RND.nextInt(serverParts.length)];
    }
}

