/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import mobac.program.model.Settings;
import mobac.utilities.Utilities;
import org.apache.log4j.Logger;

public class MapSourcesPropertiesManager {
    private static final Logger log = Logger.getLogger(MapSourcesPropertiesManager.class);
    private static final String FILENAME = "mapsources.properties";
    public static final Properties PROPERTIES = new Properties();
    private static boolean SHUTDOWN_HOOK_REGISTERED = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        File mapSourcesDir = Settings.getInstance().getMapSourcesDirectory();
        File mapSourcesProperties = new File(mapSourcesDir, FILENAME);
        if (!mapSourcesProperties.isFile()) {
            return;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(mapSourcesProperties);
            PROPERTIES.load(in);
        }
        catch (IOException e) {
            try {
                log.error("Failed to load mapsources.properties", e);
            }
            catch (Throwable throwable) {
                Utilities.closeStream(in);
                throw throwable;
            }
            Utilities.closeStream(in);
        }
        Utilities.closeStream(in);
        if (!SHUTDOWN_HOOK_REGISTERED) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    MapSourcesPropertiesManager.save();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        if (PROPERTIES.size() == 0) {
            return;
        }
        File mapSourcesDir = Settings.getInstance().getMapSourcesDirectory();
        File mapSourcesProperties = new File(mapSourcesDir, FILENAME);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(mapSourcesProperties);
            PROPERTIES.store(out, "");
        }
        catch (IOException e) {
            try {
                log.error("", e);
            }
            catch (Throwable throwable) {
                Utilities.closeStream(out);
                throw throwable;
            }
            Utilities.closeStream(out);
        }
        Utilities.closeStream(out);
    }
}

