/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.xml.bind.annotation.XmlElement;
import mobac.exceptions.MapSourceInitializationException;
import mobac.exceptions.NotImplementedException;
import mobac.exceptions.UnrecoverableDownloadException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.interfaces.FileBasedMapSource;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.interfaces.RefreshableMapSource;
import mobac.program.model.MapSourceLoaderInfo;
import mobac.program.model.TileImageType;
import org.apache.log4j.Logger;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.TileBitmap;
import org.mapsforge.core.model.Tile;
import org.mapsforge.map.awt.graphics.AwtGraphicFactory;
import org.mapsforge.map.datastore.MapDataStore;
import org.mapsforge.map.datastore.MultiMapDataStore;
import org.mapsforge.map.layer.cache.TileCache;
import org.mapsforge.map.layer.queue.Job;
import org.mapsforge.map.layer.renderer.DatabaseRenderer;
import org.mapsforge.map.layer.renderer.RendererJob;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.model.common.Observer;
import org.mapsforge.map.reader.MapFile;
import org.mapsforge.map.rendertheme.ExternalRenderTheme;
import org.mapsforge.map.rendertheme.InternalRenderTheme;
import org.mapsforge.map.rendertheme.XmlRenderTheme;
import org.mapsforge.map.rendertheme.XmlRenderThemeMenuCallback;
import org.mapsforge.map.rendertheme.XmlRenderThemeStyleLayer;
import org.mapsforge.map.rendertheme.XmlRenderThemeStyleMenu;
import org.mapsforge.map.rendertheme.rule.RenderThemeFuture;

public class MapsforgeMapSource
implements MapSource,
FileBasedMapSource,
RefreshableMapSource {
    private static final Logger LOG = Logger.getLogger(MapsforgeMapSource.class);
    private static final String name = "MapsforgeWorld";
    private MapSourceLoaderInfo loaderInfo = null;
    private MapSpace mapSpace = MercatorPower2MapSpace.INSTANCE_256;
    protected File mapFile;
    protected DatabaseRenderer renderer;
    protected XmlRenderTheme xmlRenderTheme;
    protected DisplayModel displayModel;
    protected MultiMapDataStore multiMapDataStore;
    protected RenderThemeFuture renderThemeFuture;
    protected XmlRenderThemeStyleMenu renderThemeStyleMenu;
    protected MapsForgeCache tileCache = new MapsForgeCache();
    @XmlElement(defaultValue="false")
    protected boolean transparent = false;
    @XmlElement(defaultValue="1.0")
    protected float textScale = 1.0f;

    public MapsforgeMapSource() {
        this("world.map");
    }

    public MapsforgeMapSource(String mapFileName) {
        this.mapFile = new File(mapFileName);
        this.displayModel = new DisplayModel();
        this.xmlRenderTheme = InternalRenderTheme.OSMARENDER;
    }

    @Override
    public void initialize() throws MapSourceInitializationException {
        if (!this.mapFile.exists()) {
            throw new MapSourceInitializationException("File does not exist: " + this.mapFile.getAbsolutePath());
        }
        this.reinitialize();
    }

    @Override
    public void reinitialize() {
        if (!this.mapFile.exists()) {
            return;
        }
        GraphicFactory graphicFactory = AwtGraphicFactory.INSTANCE;
        this.multiMapDataStore = new MultiMapDataStore(MultiMapDataStore.DataPolicy.RETURN_FIRST);
        this.multiMapDataStore.addMapDataStore(new MapFile(this.mapFile), true, true);
        this.renderer = new DatabaseRenderer((MapDataStore)this.multiMapDataStore, graphicFactory, this.tileCache);
        this.renderThemeFuture = new RenderThemeFuture(graphicFactory, this.xmlRenderTheme, this.displayModel);
        this.renderThemeFuture.run();
    }

    protected void loadExternalRenderTheme(File xmlRenderThemeFile) throws FileNotFoundException {
        XmlRenderThemeMenuCallback callBack = new XmlRenderThemeMenuCallback(){

            @Override
            public Set<String> getCategories(XmlRenderThemeStyleMenu styleMenu) {
                MapsforgeMapSource.this.renderThemeStyleMenu = styleMenu;
                String id = styleMenu.getDefaultValue();
                XmlRenderThemeStyleLayer baseLayer = styleMenu.getLayer(id);
                Set<String> result = baseLayer.getCategories();
                for (XmlRenderThemeStyleLayer overlay : baseLayer.getOverlays()) {
                    LOG.trace("Overlay " + overlay.getId() + " enabled: " + overlay.isEnabled());
                    if (!overlay.isEnabled()) continue;
                    result.addAll(overlay.getCategories());
                }
                return result;
            }
        };
        this.xmlRenderTheme = new ExternalRenderTheme(xmlRenderThemeFile, callBack);
    }

    @Override
    public void refresh() {
        this.tileCache.purge();
    }

    @Override
    public Color getBackgroundColor() {
        return Color.WHITE;
    }

    @Override
    public MapSpace getMapSpace() {
        return this.mapSpace;
    }

    @Override
    public int getMaxZoom() {
        return 19;
    }

    @Override
    public int getMinZoom() {
        return 0;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public byte[] getTileData(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, UnrecoverableDownloadException, InterruptedException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream(16000);
        try {
            BufferedImage image = this.getTileImage(zoom, x, y, loadMethod);
            if (image == null) {
                return null;
            }
            ImageIO.write((RenderedImage)image, "png", buf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buf.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getTileImage(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, UnrecoverableDownloadException, InterruptedException {
        TileBitmap tileBitmap;
        if (this.mapFile == null || this.xmlRenderTheme == null) {
            return null;
        }
        if (loadMethod == MapSource.LoadMethod.CACHE) {
            return null;
        }
        Tile tile = new Tile(x, y, (byte)zoom, 256);
        RendererJob job = new RendererJob(tile, this.multiMapDataStore, this.renderThemeFuture, this.displayModel, this.displayModel.getScaleFactor(), this.transparent, false);
        this.tileCache.put(job, null);
        MapsforgeMapSource mapsforgeMapSource = this;
        synchronized (mapsforgeMapSource) {
            tileBitmap = this.renderer.executeJob(job);
        }
        if (tileBitmap == null) {
            throw new IOException("Failed to render image");
        }
        return AwtGraphicFactory.getBitmap(tileBitmap);
    }

    @Override
    public TileImageType getTileImageType() {
        return TileImageType.PNG;
    }

    @Override
    public MapSourceLoaderInfo getLoaderInfo() {
        return this.loaderInfo;
    }

    @Override
    public void setLoaderInfo(MapSourceLoaderInfo loaderInfo) {
        this.loaderInfo = loaderInfo;
    }

    public String toString() {
        return name;
    }

    private static class MapsForgeCache
    implements TileCache {
        HashSet<Integer> set = new HashSet(10000);

        private MapsForgeCache() {
        }

        @Override
        public void put(Job job, TileBitmap tile) {
            this.set.add(job.hashCode());
        }

        @Override
        public boolean containsKey(Job job) {
            return this.set.contains(job.hashCode());
        }

        @Override
        public void destroy() {
        }

        @Override
        public TileBitmap get(Job job) {
            throw new NotImplementedException();
        }

        @Override
        public int getCapacity() {
            throw new NotImplementedException();
        }

        @Override
        public int getCapacityFirstLevel() {
            throw new NotImplementedException();
        }

        @Override
        public TileBitmap getImmediately(Job job) {
            throw new NotImplementedException();
        }

        @Override
        public void setWorkingSet(Set<Job> jobs) {
            throw new NotImplementedException();
        }

        @Override
        public void addObserver(Observer observer) {
            throw new NotImplementedException();
        }

        @Override
        public void removeObserver(Observer observer) {
            throw new NotImplementedException();
        }

        @Override
        public void purge() {
            this.set.clear();
        }
    }
}

