/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.custom;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import mobac.exceptions.MapSourceInitializationException;
import mobac.exceptions.TileException;
import mobac.mapsources.custom.CustomCloudMade;
import mobac.mapsources.custom.CustomLocalImageFileMapSource;
import mobac.mapsources.custom.CustomLocalTileFilesMapSource;
import mobac.mapsources.custom.CustomLocalTileSQliteMapSource;
import mobac.mapsources.custom.CustomLocalTileZipMapSource;
import mobac.mapsources.custom.CustomMapSource;
import mobac.mapsources.custom.CustomMapsforge;
import mobac.mapsources.custom.CustomWmsMapSource;
import mobac.mapsources.custom.StandardMapSourceLayer;
import mobac.program.interfaces.FileBasedMapSource;
import mobac.program.interfaces.InitializableMapSource;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.jaxb.ColorAdapter;
import mobac.program.model.MapSourceLoaderInfo;
import mobac.program.model.TileImageType;

@XmlRootElement(name="combined")
public class CustomCombinedMapSource
implements InitializableMapSource {
    @XmlElementWrapper(name="regionalMapSource")
    @XmlElements(value={@XmlElement(name="mapSource", type=StandardMapSourceLayer.class), @XmlElement(name="localTileSQLite", type=CustomLocalTileSQliteMapSource.class), @XmlElement(name="localTileFiles", type=CustomLocalTileFilesMapSource.class), @XmlElement(name="localTileZip", type=CustomLocalTileZipMapSource.class), @XmlElement(name="localImageFile", type=CustomLocalImageFileMapSource.class)})
    protected ArrayList<MapSource> regionalMapSource = new ArrayList();
    @XmlElementWrapper(name="baseMapSource")
    @XmlElements(value={@XmlElement(name="customMapSource", type=CustomMapSource.class), @XmlElement(name="customWmsMapSource", type=CustomWmsMapSource.class), @XmlElement(name="mapSource", type=StandardMapSourceLayer.class), @XmlElement(name="cloudMade", type=CustomCloudMade.class), @XmlElement(name="mapsforge", type=CustomMapsforge.class), @XmlElement(name="localTileSQLite", type=CustomLocalTileSQliteMapSource.class), @XmlElement(name="localTileFiles", type=CustomLocalTileFilesMapSource.class), @XmlElement(name="localTileZip", type=CustomLocalTileZipMapSource.class), @XmlElement(name="localImageFile", type=CustomLocalImageFileMapSource.class)})
    protected ArrayList<MapSource> baseMapSource = new ArrayList();
    @XmlElement
    protected String name;
    @XmlElement(defaultValue="#000000")
    @XmlJavaTypeAdapter(value=ColorAdapter.class)
    protected Color backgroundColor = Color.BLACK;
    @XmlElement
    protected TileImageType tileType = TileImageType.PNG;

    @Override
    public void initialize() throws MapSourceInitializationException {
        if (this.regionalMapSource.size() == 0) {
            throw new MapSourceInitializationException("Regional map missing");
        }
        if (this.baseMapSource.size() == 0) {
            throw new MapSourceInitializationException("Base map missing");
        }
        if (this.regionalMapSource.size() > 1 || this.baseMapSource.size() > 1) {
            throw new MapSourceInitializationException("Invalid map source definition: multiple regional or base maps defined.");
        }
        if (!(this.regionalMapSource instanceof FileBasedMapSource)) {
            throw new MapSourceInitializationException("Invalid regional map file format. Only file based local maps are supported!");
        }
        ((InitializableMapSource)((Object)this.regionalMapSource)).initialize();
        if (this.baseMapSource instanceof InitializableMapSource) {
            ((InitializableMapSource)((Object)this.baseMapSource)).initialize();
        }
    }

    @Override
    public byte[] getTileData(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
        try {
            byte[] data = this.regionalMapSource.get(0).getTileData(zoom, x, y, loadMethod);
            if (data != null) {
                return data;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.baseMapSource.get(0).getTileData(zoom, x, y, loadMethod);
    }

    @Override
    public BufferedImage getTileImage(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
        try {
            BufferedImage image = this.regionalMapSource.get(0).getTileImage(zoom, x, y, loadMethod);
            if (image != null) {
                return image;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.baseMapSource.get(0).getTileImage(zoom, x, y, loadMethod);
    }

    @Override
    public TileImageType getTileImageType() {
        return this.tileType;
    }

    @Override
    public int getMaxZoom() {
        return this.baseMapSource.get(0).getMaxZoom();
    }

    @Override
    public int getMinZoom() {
        return this.baseMapSource.get(0).getMinZoom();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MapSpace getMapSpace() {
        return this.baseMapSource.get(0).getMapSpace();
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public MapSourceLoaderInfo getLoaderInfo() {
        return null;
    }

    @Override
    public void setLoaderInfo(MapSourceLoaderInfo loaderInfo) {
    }
}

