/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.custom;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import mobac.exceptions.TileException;
import mobac.mapsources.mapspace.MapSpaceFactory;
import mobac.program.interfaces.FileBasedMapSource;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.jaxb.ColorAdapter;
import mobac.program.model.MapSourceLoaderInfo;
import mobac.program.model.TileImageType;
import mobac.utilities.I18nUtils;
import org.apache.log4j.Logger;

@XmlRootElement(name="localImageFile")
public class CustomLocalImageFileMapSource
implements FileBasedMapSource {
    private static final Logger log = Logger.getLogger(CustomLocalImageFileMapSource.class);
    private MapSourceLoaderInfo loaderInfo = null;
    @XmlElement(required=true, nillable=false)
    private double boxNorth = 90.0;
    @XmlElement(required=true, nillable=false)
    private double boxSouth = -90.0;
    @XmlElement(required=true, nillable=false)
    private double boxEast = 180.0;
    @XmlElement(required=true, nillable=false)
    private double boxWest = -180.0;
    private MapSpace mapSpace = MapSpaceFactory.getInstance(256, true);
    private boolean initialized = false;
    BufferedImage fullImage = null;
    private TileImageType tileImageType = null;
    @XmlElement(nillable=false, defaultValue="CustomImage")
    private String name = "Custom";
    @XmlElement(nillable=false, defaultValue="0")
    private int minZoom = 0;
    @XmlElement(nillable=false, defaultValue="20")
    private int maxZoom = 22;
    @XmlElement(required=true)
    private File imageFile = null;
    @XmlElement(nillable=false, defaultValue="false")
    private boolean retinaDisplay = false;
    @XmlElement(defaultValue="false")
    private boolean invertYCoordinate = false;
    @XmlElement(defaultValue="#00000000")
    @XmlJavaTypeAdapter(value=ColorAdapter.class)
    private Color backgroundColor = Color.BLACK;

    @Override
    public synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        this.reinitialize();
    }

    @Override
    public void reinitialize() {
        try {
            if (!this.imageFile.isFile()) {
                JOptionPane.showMessageDialog(null, String.format(I18nUtils.localizedStringForKey("msg_environment_invalid_source_folder", new Object[0]), this.name, this.imageFile.toString()), I18nUtils.localizedStringForKey("msg_environment_invalid_source_folder_title", new Object[0]), 0);
                this.initialized = true;
                return;
            }
            String[] parts = this.imageFile.getName().split("\\.");
            this.tileImageType = parts.length >= 2 ? TileImageType.getTileImageType(parts[parts.length - 1]) : TileImageType.PNG;
            this.boxWest = Math.min(this.boxEast, this.boxWest);
            this.boxEast = Math.max(this.boxEast, this.boxWest);
            this.boxSouth = Math.min(this.boxNorth, this.boxSouth);
            this.boxNorth = Math.max(this.boxNorth, this.boxSouth);
        }
        finally {
            this.initialized = true;
        }
    }

    @Override
    public byte[] getTileData(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream(16000);
        BufferedImage image = this.getTileImage(zoom, x, y, loadMethod);
        if (image == null) {
            return null;
        }
        ImageIO.write((RenderedImage)image, this.tileImageType.getFileExt(), buf);
        return buf.toByteArray();
    }

    private int absFloor(double value) {
        return value > 0.0 ? (int)Math.floor(value) : (int)Math.ceil(value);
    }

    private int absCeil(double value) {
        return value > 0.0 ? (int)Math.ceil(value) : (int)Math.floor(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getTileImage(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
        if (!this.initialized) {
            this.initialize();
        }
        if (log.isTraceEnabled()) {
            log.trace(String.format("Loading tile z=%d x=%d y=%d", zoom, x, y));
        }
        BufferedImage image = null;
        Graphics g2 = null;
        try {
            if (this.fullImage == null) {
                this.fullImage = ImageIO.read(this.imageFile);
            }
            int imageWidth = this.fullImage.getWidth();
            int imageHeight = this.fullImage.getHeight();
            int tileSize = this.mapSpace.getTileSize();
            double tileWest = this.mapSpace.cXToLon(x * tileSize, zoom);
            double tileNorth = this.mapSpace.cYToLat(y * tileSize, zoom);
            double tileEast = this.mapSpace.cXToLon((x + 1) * tileSize, zoom);
            double tileSouth = this.mapSpace.cYToLat((y + 1) * tileSize, zoom);
            double tileWidth = tileEast - tileWest;
            double tileHeight = tileNorth - tileSouth;
            double intersectWest = Math.max(tileWest, this.boxWest);
            double intersectEast = Math.min(tileEast, this.boxEast);
            double intersectNorth = Math.min(tileNorth, this.boxNorth);
            double intersectSouth = Math.max(tileSouth, this.boxSouth);
            double intersectWidth = intersectEast - intersectWest;
            double intersectHeight = intersectNorth - intersectSouth;
            if (intersectWidth > 0.0 && intersectHeight > 0.0) {
                int graphContextSize = tileSize * (this.retinaDisplay ? 2 : 1);
                image = new BufferedImage(graphContextSize, graphContextSize, 6);
                g2 = image.createGraphics();
                g2.setColor(this.getBackgroundColor());
                g2.fillRect(0, 0, graphContextSize, graphContextSize);
                double boxWidth = this.boxEast - this.boxWest;
                double boxHeight = this.boxNorth - this.boxSouth;
                double cropWScale = boxWidth <= 0.0 ? 0.0 : (double)imageWidth / boxWidth;
                double cropHScale = boxHeight <= 0.0 ? 0.0 : (double)imageHeight / boxHeight;
                int cropW = this.absCeil(intersectWidth * cropWScale);
                int cropH = this.absCeil(intersectHeight * cropHScale);
                int cropX = this.absFloor((intersectWest - this.boxWest) * cropWScale);
                int cropY = this.absFloor((this.boxNorth - intersectNorth) * cropHScale);
                if (cropX < imageWidth && cropY < imageHeight && cropX + cropW > 0 && cropY + cropH > 0) {
                    double drawrectWScale = tileWidth <= 0.0 ? 0.0 : (double)graphContextSize / tileWidth;
                    double drawrectHScale = tileHeight <= 0.0 ? 0.0 : (double)graphContextSize / tileHeight;
                    int drawrectW = this.absCeil(intersectWidth * drawrectWScale);
                    int drawrectH = this.absCeil(intersectHeight * drawrectHScale);
                    int drawrectX = this.absFloor((intersectWest - tileWest) * drawrectWScale);
                    int drawrectY = this.absFloor((tileNorth - intersectNorth) * drawrectHScale);
                    if (drawrectX < graphContextSize && drawrectY < graphContextSize && drawrectX + drawrectW > 1 && drawrectY + drawrectH > 1) {
                        g2.drawImage(this.fullImage, drawrectX, drawrectY, drawrectX + drawrectW, drawrectY + drawrectH, cropX, cropY, cropX + cropW, cropY + cropH, null);
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            log.debug("Map image file not found: " + this.imageFile.getAbsolutePath());
        }
        finally {
            if (g2 != null) {
                g2.dispose();
            }
        }
        return image;
    }

    @Override
    public TileImageType getTileImageType() {
        return this.tileImageType;
    }

    @Override
    public int getMaxZoom() {
        return this.maxZoom;
    }

    @Override
    public int getMinZoom() {
        return this.minZoom;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public MapSpace getMapSpace() {
        return this.mapSpace;
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    @XmlTransient
    public MapSourceLoaderInfo getLoaderInfo() {
        return this.loaderInfo;
    }

    @Override
    public void setLoaderInfo(MapSourceLoaderInfo loaderInfo) {
        this.loaderInfo = loaderInfo;
    }
}

