/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.custom;

import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.JOptionPane;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import mobac.exceptions.MapSourceInitializationException;
import mobac.mapsources.MapsforgeMapSource;
import mobac.program.DirectoryManager;
import mobac.program.model.MapSourceLoaderInfo;
import mobac.utilities.I18nUtils;
import mobac.utilities.Utilities;
import org.apache.log4j.Logger;

@XmlRootElement(name="mapsforge")
public class CustomMapsforge
extends MapsforgeMapSource {
    private static final Logger log = Logger.getLogger(CustomMapsforge.class);
    @XmlElement(nillable=false, defaultValue="MapsforgeCustom")
    private String name = "MapsforgeCustom";
    @XmlElement(name="mapFile")
    private String mapFileName;
    @XmlElement(name="xmlRenderTheme", defaultValue="")
    private String xmlRenderThemeFileName = "";
    @XmlElement(defaultValue="0")
    private int minZoom = 0;
    @XmlElement(defaultValue="20")
    private int maxZoom = 20;

    @Override
    public void initialize() throws MapSourceInitializationException {
        this.xmlRenderThemeFileName = this.xmlRenderThemeFileName.trim();
        MapSourceLoaderInfo loaderInfo = this.getLoaderInfo();
        File mapSourceXmlDir = null;
        if (loaderInfo != null) {
            File mapSourceXmlFile = this.getLoaderInfo().getSourceFile();
            mapSourceXmlDir = mapSourceXmlFile.getParentFile();
        }
        this.mapFile = Utilities.findFile(this.mapFileName, mapSourceXmlDir, DirectoryManager.currentDir, DirectoryManager.mapSourcesDir, DirectoryManager.userAppDataDir);
        if (this.mapFile == null) {
            JOptionPane.showMessageDialog(null, "Unable to find map file \"" + this.mapFileName + "\"", I18nUtils.localizedStringForKey("Error", new Object[0]), 0);
            return;
        }
        if (this.xmlRenderThemeFileName.length() > 0) {
            File renderFile = Utilities.findFile(this.xmlRenderThemeFileName, mapSourceXmlDir, DirectoryManager.currentDir, DirectoryManager.mapSourcesDir, DirectoryManager.userAppDataDir);
            if (renderFile == null) {
                JOptionPane.showMessageDialog(null, "Unable to find xmlRenderTheme file \"" + this.xmlRenderThemeFileName + "\"", I18nUtils.localizedStringForKey("Error", new Object[0]), 0);
                return;
            }
            try {
                this.loadExternalRenderTheme(renderFile);
            }
            catch (FileNotFoundException e) {
                log.error("", e);
                return;
            }
        }
        super.initialize();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getMaxZoom() {
        return this.maxZoom;
    }

    @Override
    public int getMinZoom() {
        return this.minZoom;
    }

    @Override
    public String toString() {
        return this.name;
    }
}

