/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.custom;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import mobac.exceptions.TileException;
import mobac.mapsources.MapSourcesManager;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.model.MapSourceLoaderInfo;
import mobac.program.model.TileImageType;

@XmlRootElement
public class StandardMapSourceLayer
implements MapSource {
    protected MapSource mapSource = null;
    protected MapSourceLoaderInfo loaderInfo = null;
    @XmlElement(name="name")
    protected String mapSourceName;

    public MapSource getMapSource() {
        return this.mapSource;
    }

    protected void afterUnmarshal(Unmarshaller u, Object parent) {
        this.mapSource = MapSourcesManager.getInstance().getSourceByName(this.mapSourceName);
        if (this.mapSource == null) {
            throw new RuntimeException("Unknown map source name used: " + this.mapSourceName);
        }
    }

    @Override
    public int getMaxZoom() {
        return this.mapSource.getMaxZoom();
    }

    @Override
    public int getMinZoom() {
        return this.mapSource.getMinZoom();
    }

    @Override
    public String getName() {
        return this.mapSource.getName();
    }

    @Override
    public byte[] getTileData(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
        return this.mapSource.getTileData(zoom, x, y, loadMethod);
    }

    @Override
    public BufferedImage getTileImage(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
        return this.mapSource.getTileImage(zoom, x, y, loadMethod);
    }

    @Override
    public TileImageType getTileImageType() {
        return this.mapSource.getTileImageType();
    }

    @Override
    public MapSpace getMapSpace() {
        return this.mapSource.getMapSpace();
    }

    @Override
    public Color getBackgroundColor() {
        return this.mapSource.getBackgroundColor();
    }

    public String toString() {
        return this.mapSource.toString();
    }

    public int hashCode() {
        return this.mapSource.hashCode();
    }

    @Override
    @XmlTransient
    public MapSourceLoaderInfo getLoaderInfo() {
        return this.loaderInfo;
    }

    @Override
    public void setLoaderInfo(MapSourceLoaderInfo loaderInfo) {
        this.loaderInfo = loaderInfo;
    }

    public boolean equals(Object obj) {
        return this.mapSource.equals(obj);
    }
}

