/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import mobac.exceptions.UnrecoverableDownloadException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.model.MapSourceLoaderInfo;
import mobac.program.model.TileImageType;

public class SimpleMapSource
implements MapSource {
    @Override
    public Color getBackgroundColor() {
        return Color.WHITE;
    }

    @Override
    public MapSpace getMapSpace() {
        return MercatorPower2MapSpace.INSTANCE_256;
    }

    @Override
    public int getMaxZoom() {
        return 2;
    }

    @Override
    public int getMinZoom() {
        return 0;
    }

    @Override
    public String getName() {
        return "Simple";
    }

    @Override
    public byte[] getTileData(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, UnrecoverableDownloadException, InterruptedException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream(16000);
        ImageIO.write((RenderedImage)this.getTileImage(zoom, x, y, MapSource.LoadMethod.DEFAULT), "png", buf);
        return buf.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getTileImage(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, UnrecoverableDownloadException, InterruptedException {
        BufferedImage image = new BufferedImage(256, 256, 5);
        Graphics2D g2 = image.createGraphics();
        try {
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, 255, 255);
            g2.setColor(Color.BLACK);
            g2.drawString("No map sources available", 8, 40);
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public TileImageType getTileImageType() {
        return TileImageType.PNG;
    }

    @Override
    public MapSourceLoaderInfo getLoaderInfo() {
        return null;
    }

    @Override
    public void setLoaderInfo(MapSourceLoaderInfo loaderInfo) {
        throw new RuntimeException("LoaderInfo can not be set");
    }

    public String toString() {
        return "";
    }
}

