/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.loader;

import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import mobac.exceptions.MapSourceCreateException;
import mobac.mapsources.MapSourcesManager;
import mobac.mapsources.custom.CustomCloudMade;
import mobac.mapsources.custom.CustomCombinedMapSource;
import mobac.mapsources.custom.CustomLocalTileFilesMapSource;
import mobac.mapsources.custom.CustomLocalTileSQliteMapSource;
import mobac.mapsources.custom.CustomLocalTileZipMapSource;
import mobac.mapsources.custom.CustomMapSource;
import mobac.mapsources.custom.CustomMapsforge;
import mobac.mapsources.custom.CustomMultiLayerMapSource;
import mobac.mapsources.custom.CustomWmsMapSource;
import mobac.mapsources.loader.MapPackManager;
import mobac.program.interfaces.FileBasedMapSource;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.WrappedMapSource;
import mobac.program.model.MapSourceLoaderInfo;
import mobac.utilities.Utilities;
import mobac.utilities.file.DirOrFileExtFilter;
import org.apache.log4j.Logger;

public class CustomMapSourceLoader
implements ValidationEventHandler {
    private final Logger log = Logger.getLogger(MapPackManager.class);
    private final MapSourcesManager mapSourcesManager;
    private final File mapSourcesDir;
    private final Unmarshaller unmarshaller;

    public CustomMapSourceLoader(MapSourcesManager mapSourceManager, File mapSourcesDir) {
        this.mapSourcesManager = mapSourceManager;
        this.mapSourcesDir = mapSourcesDir;
        try {
            Class[] customMapClasses = new Class[]{CustomMapSource.class, CustomWmsMapSource.class, CustomMultiLayerMapSource.class, CustomCombinedMapSource.class, CustomMapsforge.class, CustomCloudMade.class, CustomLocalTileFilesMapSource.class, CustomLocalTileZipMapSource.class, CustomLocalTileSQliteMapSource.class};
            JAXBContext context = JAXBContext.newInstance((Class[])customMapClasses);
            this.unmarshaller = context.createUnmarshaller();
            this.unmarshaller.setEventHandler((ValidationEventHandler)this);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to create JAXB context for custom map sources", e);
        }
    }

    public void loadCustomMapSources() {
        List<File> customMapSourceFiles = Utilities.traverseFolder(this.mapSourcesDir, new DirOrFileExtFilter(".xml"));
        for (File f : customMapSourceFiles) {
            try {
                Object o = this.unmarshaller.unmarshal(f);
                MapSource customMapSource = o instanceof WrappedMapSource ? ((WrappedMapSource)o).getMapSource() : (MapSource)o;
                customMapSource.setLoaderInfo(new MapSourceLoaderInfo(MapSourceLoaderInfo.LoaderType.XML, f));
                if (!(customMapSource instanceof FileBasedMapSource) && customMapSource.getTileImageType() == null) {
                    this.log.warn("A problem occured while loading \"" + f.getName() + "\": tileType is null - some atlas formats will produce an error!");
                }
                this.log.trace("Custom map source loaded: " + customMapSource + " from file \"" + f.getName() + "\"");
                this.mapSourcesManager.addMapSource(customMapSource);
            }
            catch (Exception e) {
                this.log.error("failed to load custom map source \"" + f.getName() + "\": " + e.getMessage(), e);
            }
        }
    }

    public MapSource loadCustomMapSource(InputStream in) throws MapSourceCreateException, JAXBException {
        Object o = this.unmarshaller.unmarshal(in);
        MapSource customMapSource = o instanceof WrappedMapSource ? ((WrappedMapSource)o).getMapSource() : (MapSource)o;
        customMapSource.setLoaderInfo(new MapSourceLoaderInfo(MapSourceLoaderInfo.LoaderType.XML, null));
        this.log.trace("Custom map source loaded: " + customMapSource);
        return customMapSource;
    }

    public boolean handleEvent(ValidationEvent event) {
        String errorMsg;
        ValidationEventLocator loc = event.getLocator();
        String file = loc.getURL().getFile();
        try {
            file = URLDecoder.decode(file, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        int lastSlash = file.lastIndexOf(47);
        if (lastSlash > 0) {
            file = file.substring(lastSlash + 1);
        }
        if ((errorMsg = event.getMessage()) == null) {
            for (Throwable t = event.getLinkedException(); t != null && errorMsg == null; t = t.getCause()) {
                errorMsg = t.getMessage();
            }
        }
        JOptionPane.showMessageDialog(null, "<html><h3>Failed to load a custom map</h3><p><i>" + errorMsg + "</i></p><br><p>file: \"<b>" + file + "</b>\"<br>line/column: <i>" + loc.getLineNumber() + "/" + loc.getColumnNumber() + "</i></p>", "Error: custom map loading failed", 0);
        this.log.error(event.toString());
        return false;
    }

    public static class WrappedMap {
    }
}

