/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.loader;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import mobac.mapsources.MapSourcesManager;
import mobac.program.interfaces.MapSource;
import mobac.utilities.Utilities;
import mobac.utilities.file.DirectoryFileFilter;
import org.apache.log4j.Logger;

public class EclipseMapPackLoader {
    private final Logger log = Logger.getLogger(EclipseMapPackLoader.class);
    private final MapSourcesManager mapSourcesManager;

    public EclipseMapPackLoader(MapSourcesManager mapSourcesManager) throws IOException {
        this.mapSourcesManager = mapSourcesManager;
    }

    public boolean loadMapPacks() throws IOException {
        File[] mapPacks;
        File binDir;
        ClassLoader cl = EclipseMapPackLoader.class.getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        boolean success = false;
        try {
            binDir = new File(cl.getResource(".").toURI());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        File mapPackDir = new File(binDir, "mobac/mapsources/mappacks");
        if (!mapPackDir.isDirectory()) {
            return false;
        }
        for (File d : mapPacks = mapPackDir.listFiles(new DirectoryFileFilter())) {
            String[] classNames;
            File list = new File(d, "mapsources.list");
            if (!list.isFile()) continue;
            String listContent = new String(Utilities.getFileBytes(list), StandardCharsets.UTF_8);
            for (String className : classNames = listContent.split("\\s+")) {
                try {
                    Class<?> clazz = Class.forName(className);
                    MapSource ms = (MapSource)clazz.newInstance();
                    this.mapSourcesManager.addMapSource(ms);
                    success = true;
                }
                catch (Exception e) {
                    this.log.error("className: \"" + className + "\"", e);
                }
            }
        }
        return success;
    }
}

