/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.mappacks.openstreetmap;

import java.nio.charset.StandardCharsets;
import mobac.exceptions.MapSourceInitializationException;
import mobac.mapsources.MapSourceUrlUpdater;
import mobac.mapsources.mappacks.openstreetmap.AbstractOsmMapSource;
import mobac.program.interfaces.HttpMapSource;

public class CloudMade
extends AbstractOsmMapSource {
    private static final String INIT_REGEX = "\"api_key\"\\:\"([A-F0-9]+)\"";
    private String styleID;
    private String displayName;
    private String apiKey = "";
    private static final String PATTERN = "http://%s.tile.cloudmade.com/%s/%s/256/%d/%d/%d.png";
    private static final String[] SERVER;
    private int SERVER_NUM = 0;

    public CloudMade(String styleID, String displayName) {
        super("OSM CloudMade " + styleID);
        this.displayName = displayName;
        this.styleID = styleID;
        this.maxZoom = 18;
        this.tileUpdate = HttpMapSource.TileUpdate.IfModifiedSince;
    }

    public CloudMade() {
        this("1", "OpenStreetMap CloudMade Default Style");
    }

    @Override
    protected void initernalInitialize() throws MapSourceInitializationException {
        this.apiKey = MapSourceUrlUpdater.loadDocumentAndExtractGroup("http://maps.cloudmade.com/", StandardCharsets.UTF_8, INIT_REGEX);
    }

    @Override
    public String getTileUrl(int zoom, int tilex, int tiley) {
        String url = String.format(PATTERN, SERVER[this.SERVER_NUM], this.apiKey, this.styleID, zoom, tilex, tiley);
        this.SERVER_NUM = (this.SERVER_NUM + 1) % SERVER.length;
        return url;
    }

    @Override
    public String toString() {
        return this.displayName;
    }

    static {
        try {
            Class<?> c = Class.forName("mobac.mapsources.custom.CustomCloudMade");
            c.getField("CLOUD_MADE_CLASS").set(c, CloudMade.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SERVER = new String[]{"a", "b", "c"};
    }
}

