/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.mapspace;

import java.awt.Point;
import mobac.program.interfaces.MapSpace;

public class MercatorPower2MapSpace
implements MapSpace {
    public static final double MAX_LAT = 85.05112877980659;
    public static final double MIN_LAT = -85.05112877980659;
    protected final int tileSize;
    protected final int[] worldSize;
    public static final MapSpace INSTANCE_256 = new MercatorPower2MapSpace(256);

    protected MercatorPower2MapSpace(int tileSize) {
        this.tileSize = tileSize;
        this.worldSize = new int[23];
        for (int zoom = 0; zoom < this.worldSize.length; ++zoom) {
            this.worldSize[zoom] = tileSize * (1 << zoom);
        }
    }

    protected double radius(int zoom) {
        return (double)this.getMaxPixels(zoom) / (Math.PI * 2);
    }

    @Override
    public MapSpace.ProjectionCategory getProjectionCategory() {
        return MapSpace.ProjectionCategory.SPHERE;
    }

    @Override
    public int getMaxPixels(int zoom) {
        return this.worldSize[zoom];
    }

    protected int falseNorthing(int aZoomlevel) {
        return -1 * this.getMaxPixels(aZoomlevel) / 2;
    }

    @Override
    public int cLatToY(double lat, int zoom) {
        lat = Math.max(-85.05112877980659, Math.min(85.05112877980659, lat));
        double sinLat = Math.sin(Math.toRadians(lat));
        double log = Math.log((1.0 + sinLat) / (1.0 - sinLat));
        int mp = this.getMaxPixels(zoom);
        int y = (int)((double)mp * (0.5 - log / (Math.PI * 4)));
        y = Math.min(y, mp - 1);
        return y;
    }

    @Override
    public int cLonToX(double lon, int zoom) {
        int mp = this.getMaxPixels(zoom);
        int x = (int)((double)mp * (lon + 180.0) / 360.0);
        x = Math.min(x, mp - 1);
        return x;
    }

    @Override
    public double cXToLon(int x, int zoom) {
        return 360.0 * (double)x / (double)this.getMaxPixels(zoom) - 180.0;
    }

    @Override
    public double cYToLat(int y, int zoom) {
        double latitude = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-1.0 * (double)(y += this.falseNorthing(zoom)) / this.radius(zoom)));
        return -1.0 * Math.toDegrees(latitude);
    }

    @Override
    public int getTileSize() {
        return this.tileSize;
    }

    @Override
    public int moveOnLatitude(int startX, int y, int zoom, double angularDist) {
        double lat = -1.0 * (1.5707963267948966 - 2.0 * Math.atan(Math.exp(-1.0 * (double)(y += this.falseNorthing(zoom)) / this.radius(zoom))));
        double lon = this.cXToLon(startX, zoom);
        double sinLat = Math.sin(lat);
        int newX = this.cLonToX(lon += Math.toDegrees(Math.atan2(Math.sin(angularDist) * Math.cos(lat), Math.cos(angularDist) - sinLat * sinLat)), zoom);
        int w = newX - startX;
        return w;
    }

    @Override
    public double horizontalDistance(int zoom, int y, int xDist) {
        y = Math.max(y, 0);
        y = Math.min(y, this.getMaxPixels(zoom));
        double lat = this.cYToLat(y, zoom);
        double lon1 = -180.0;
        double lon2 = this.cXToLon(xDist, zoom);
        double dLon = Math.toRadians(lon2 - lon1);
        double cos_lat = Math.cos(Math.toRadians(lat));
        double sin_dLon_2 = Math.sin(dLon) / 2.0;
        double a = cos_lat * cos_lat * sin_dLon_2 * sin_dLon_2;
        return 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
    }

    @Override
    public int xChangeZoom(int x, int oldZoom, int newZoom) {
        int zoomDiff = oldZoom - newZoom;
        return zoomDiff > 0 ? x >> zoomDiff : x << -zoomDiff;
    }

    @Override
    public int yChangeZoom(int y, int oldZoom, int newZoom) {
        int zoomDiff = oldZoom - newZoom;
        return zoomDiff > 0 ? y >> zoomDiff : y << -zoomDiff;
    }

    @Override
    public Point changeZoom(Point pixelCoordinate, int oldZoom, int newZoom) {
        int x = this.xChangeZoom(pixelCoordinate.x, oldZoom, newZoom);
        int y = this.yChangeZoom(pixelCoordinate.y, oldZoom, newZoom);
        return new Point(x, y);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.tileSize;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MercatorPower2MapSpace other = (MercatorPower2MapSpace)obj;
        return this.tileSize == other.tileSize;
    }
}

