/*
 * Decompiled with CFR 0.152.
 */
package mobac.program;

import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapDownloadSkippedException;
import mobac.gui.AtlasProgress;
import mobac.program.DirectoryManager;
import mobac.program.JobDispatcher;
import mobac.program.PauseResumeHandler;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.tileprovider.DownloadedTileProvider;
import mobac.program.atlascreators.tileprovider.FilteredMapSourceProvider;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.download.DownloadJobProducerThread;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.DownloadJobListener;
import mobac.program.interfaces.DownloadableElement;
import mobac.program.interfaces.FileBasedMapSource;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSourceCallerThreadInfo;
import mobac.program.model.AtlasOutputFormat;
import mobac.program.model.Settings;
import mobac.program.tilestore.TileStore;
import mobac.utilities.GUIExceptionHandler;
import mobac.utilities.I18nUtils;
import mobac.utilities.Utilities;
import mobac.utilities.tar.TarIndex;
import mobac.utilities.tar.TarIndexedArchive;
import org.apache.log4j.Logger;

public class AtlasThread
extends Thread
implements DownloadJobListener,
AtlasProgress.AtlasCreationController,
MapSourceCallerThreadInfo {
    private static final Logger log = Logger.getLogger(AtlasThread.class);
    private static int threadNum = 0;
    private File customAtlasDir = null;
    private boolean quitMobacAfterAtlasCreation = false;
    private DownloadJobProducerThread djp = null;
    private JobDispatcher downloadJobDispatcher;
    private AtlasProgress ap = new AtlasProgress(this);
    private AtlasInterface atlas;
    private AtlasCreator atlasCreator = null;
    private PauseResumeHandler pauseResumeHandler;
    private int activeDownloads = 0;
    private int jobsCompleted = 0;
    private int jobsRetryError = 0;
    private int jobsPermanentError = 0;
    private int maxDownloadRetries = 1;

    public AtlasThread(AtlasInterface atlas) throws AtlasTestException {
        this(atlas, atlas.getOutputFormat().createAtlasCreatorInstance());
    }

    public AtlasThread(AtlasInterface atlas, AtlasCreator atlasCreator) throws AtlasTestException {
        super("AtlasThread " + AtlasThread.getNextThreadNum());
        this.atlas = atlas;
        this.atlasCreator = atlasCreator;
        this.testAtlas();
        TileStore.getInstance().closeAll();
        this.maxDownloadRetries = Settings.getInstance().downloadRetryCount;
        this.pauseResumeHandler = new PauseResumeHandler();
    }

    private void testAtlas() throws AtlasTestException {
        try {
            for (LayerInterface layer : this.atlas) {
                for (MapInterface map : layer) {
                    MapSource mapSource = map.getMapSource();
                    if (this.atlasCreator.testMapSource(mapSource)) continue;
                    throw new AtlasTestException("The selected atlas output format \"" + this.atlas.getOutputFormat() + "\" does not support the map source \"" + map.getMapSource() + "\"");
                }
            }
        }
        catch (AtlasTestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AtlasTestException(e);
        }
    }

    private static synchronized int getNextThreadNum() {
        return ++threadNum;
    }

    @Override
    public void run() {
        GUIExceptionHandler.registerForCurrentThread();
        log.info("Starting creation of " + this.atlas.getOutputFormat() + " atlas \"" + this.atlas.getName() + "\"");
        if (this.customAtlasDir != null) {
            log.debug("Target directory: " + this.customAtlasDir);
        }
        this.ap.setDownloadControlerListener(this);
        try {
            this.createAtlas();
            log.info("Altas creation finished");
            if (this.quitMobacAfterAtlasCreation) {
                System.exit(0);
            }
        }
        catch (OutOfMemoryError e) {
            System.gc();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String message = I18nUtils.localizedStringForKey("msg_out_of_memory_head", new Object[0]);
                    int maxMem = Utilities.getJavaMaxHeapMB();
                    if (maxMem > 0) {
                        message = message + String.format(I18nUtils.localizedStringForKey("msg_out_of_memory_detail", new Object[0]), maxMem);
                    }
                    JOptionPane.showMessageDialog(null, message, I18nUtils.localizedStringForKey("msg_out_of_memory_title", new Object[0]), 0);
                    AtlasThread.this.ap.closeWindow();
                }
            });
            log.error("Out of memory: ", e);
        }
        catch (InterruptedException e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, I18nUtils.localizedStringForKey("msg_atlas_download_abort", new Object[0]), I18nUtils.localizedStringForKey("Information", new Object[0]), 1);
                    AtlasThread.this.ap.closeWindow();
                }
            });
            log.info("Altas creation was interrupted by user");
        }
        catch (Exception e) {
            log.error("Altas creation aborted because of an error: ", e);
            GUIExceptionHandler.showExceptionDialog(e);
        }
        System.gc();
        if (this.quitMobacAfterAtlasCreation) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(1);
        }
    }

    protected void createAtlas() throws InterruptedException, IOException {
        long totalNrOfOnlineTiles = this.atlas.calculateTilesToDownload();
        for (Object l : this.atlas) {
            Iterator iterator = l.iterator();
            while (iterator.hasNext()) {
                MapInterface m = (MapInterface)iterator.next();
                if (!(m.getMapSource() instanceof FileBasedMapSource)) continue;
                totalNrOfOnlineTiles -= m.calculateTilesToDownload();
            }
        }
        if (totalNrOfOnlineTiles > 500000L) {
            JOptionPane.showMessageDialog(null, String.format(I18nUtils.localizedStringForKey("msg_too_many_tiles_msg", new Object[0]), 500000, totalNrOfOnlineTiles), I18nUtils.localizedStringForKey("msg_too_many_tiles_title", new Object[0]), 0);
            return;
        }
        try {
            this.atlasCreator.startAtlasCreation(this.atlas, this.customAtlasDir);
        }
        catch (AtlasTestException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Atlas format restriction violated", 0);
            return;
        }
        this.ap.initAtlas(this.atlas);
        this.ap.setVisible(true);
        Settings s = Settings.getInstance();
        this.downloadJobDispatcher = new JobDispatcher(this, s.downloadThreadCount, this.pauseResumeHandler, this.ap);
        try {
            for (LayerInterface layer : this.atlas) {
                this.atlasCreator.initLayerCreation(layer);
                for (MapInterface map : layer) {
                    try {
                        while (!this.createMap(map)) {
                        }
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (MapDownloadSkippedException e) {
                    }
                    catch (Exception e) {
                        log.error("", e);
                        Object[] options = new String[]{I18nUtils.localizedStringForKey("Continue", new Object[0]), I18nUtils.localizedStringForKey("Abort", new Object[0]), I18nUtils.localizedStringForKey("dlg_download_show_error_report", new Object[0])};
                        int a = JOptionPane.showOptionDialog(null, I18nUtils.localizedStringForKey("dlg_download_erro_head", new Object[0]) + e.getMessage() + "\n[" + e.getClass().getSimpleName() + "]\n\n", I18nUtils.localizedStringForKey("Error", new Object[0]), 0, 0, null, options, options[0]);
                        switch (a) {
                            case 2: {
                                GUIExceptionHandler.processException(e);
                            }
                            case 1: {
                                throw new InterruptedException();
                            }
                        }
                    }
                }
                this.atlasCreator.finishLayerCreation();
            }
        }
        catch (InterruptedException e) {
            this.atlasCreator.abortAtlasCreation();
            throw e;
        }
        catch (Error e) {
            this.atlasCreator.abortAtlasCreation();
            throw e;
        }
        finally {
            if (this.djp != null) {
                this.djp.cancel();
            }
            this.downloadJobDispatcher.terminateAllWorkerThreads();
            if (!this.atlasCreator.isAborted()) {
                this.atlasCreator.finishAtlasCreation();
            }
            this.ap.atlasCreationFinished();
        }
    }

    public boolean createMap(MapInterface map) throws Exception {
        TarIndex tileIndex = null;
        TarIndexedArchive tileArchive = null;
        this.jobsCompleted = 0;
        this.jobsRetryError = 0;
        this.jobsPermanentError = 0;
        this.ap.initMapDownload(map);
        if (AtlasThread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        int zoom = map.getZoom();
        int tileCount = (int)map.calculateTilesToDownload();
        this.ap.setZoomLevel(zoom);
        try {
            TileProvider mapTileProvider;
            tileArchive = null;
            if (!(map.getMapSource() instanceof FileBasedMapSource)) {
                int answer;
                if (!AtlasOutputFormat.TILESTORE.equals(this.atlas.getOutputFormat())) {
                    String tempSuffix = "MOBAC_" + this.atlas.getName() + "_" + zoom + "_";
                    File tileArchiveFile = File.createTempFile(tempSuffix, ".tar", DirectoryManager.tempDir);
                    tileArchiveFile.deleteOnExit();
                    log.debug("Writing downloaded tiles to " + tileArchiveFile.getPath());
                    tileArchive = new TarIndexedArchive(tileArchiveFile, tileCount);
                } else {
                    log.debug("Downloading to tile store only");
                }
                this.djp = new DownloadJobProducerThread(this, this.downloadJobDispatcher, tileArchive, (DownloadableElement)((Object)map));
                boolean failedMessageAnswered = false;
                block11: while (this.djp.isAlive() || this.downloadJobDispatcher.getWaitingJobCount() > 0 || this.downloadJobDispatcher.isAtLeastOneWorkerActive()) {
                    Thread.sleep(500L);
                    if (failedMessageAnswered || this.jobsRetryError <= 50 || this.ap.ignoreDownloadErrors()) continue;
                    this.pauseResumeHandler.pause();
                    Object[] answers = new String[]{I18nUtils.localizedStringForKey("Continue", new Object[0]), I18nUtils.localizedStringForKey("Retry", new Object[0]), I18nUtils.localizedStringForKey("Skip", new Object[0]), I18nUtils.localizedStringForKey("Abort", new Object[0])};
                    answer = JOptionPane.showOptionDialog(this.ap, I18nUtils.localizedStringForKey("dlg_download_errors_todo_msg", new Object[0]), I18nUtils.localizedStringForKey("dlg_download_errors_todo", new Object[0]), 0, 3, null, answers, answers[0]);
                    failedMessageAnswered = true;
                    switch (answer) {
                        case 0: {
                            this.pauseResumeHandler.resume();
                            continue block11;
                        }
                        case 1: {
                            this.djp.cancel();
                            this.djp = null;
                            this.downloadJobDispatcher.cancelOutstandingJobs();
                            boolean bl = false;
                            return bl;
                        }
                        case 2: {
                            this.downloadJobDispatcher.cancelOutstandingJobs();
                            throw new MapDownloadSkippedException();
                        }
                    }
                    this.downloadJobDispatcher.cancelOutstandingJobs();
                    this.downloadJobDispatcher.terminateAllWorkerThreads();
                    throw new InterruptedException();
                }
                this.djp = null;
                log.debug("All download jobs has been completed!");
                if (tileArchive != null) {
                    tileArchive.writeEndofArchive();
                    tileArchive.close();
                    tileIndex = tileArchive.getTarIndex();
                    if (tileIndex.size() < tileCount && !this.ap.ignoreDownloadErrors()) {
                        int missing = tileCount - tileIndex.size();
                        log.debug("Expected tile count: " + tileCount + " downloaded tile count: " + tileIndex.size() + " missing: " + missing);
                        answer = JOptionPane.showConfirmDialog(this.ap, String.format(I18nUtils.localizedStringForKey("dlg_download_errors_missing_tile_msg", new Object[0]), missing), I18nUtils.localizedStringForKey("dlg_download_errors_missing_tile", new Object[0]), 0, 0);
                        if (answer != 0) {
                            throw new InterruptedException();
                        }
                    }
                }
                this.downloadJobDispatcher.cancelOutstandingJobs();
                log.debug("Starting to create atlas from downloaded tiles");
                mapTileProvider = new DownloadedTileProvider(tileIndex, map);
            } else {
                mapTileProvider = new FilteredMapSourceProvider(map, MapSource.LoadMethod.DEFAULT);
            }
            this.atlasCreator.initializeMap(map, mapTileProvider);
            this.atlasCreator.createMap();
        }
        catch (Error e) {
            log.error("Error in createMap: " + e.getMessage(), e);
            throw e;
        }
        finally {
            if (tileIndex != null) {
                tileIndex.closeAndDelete();
            } else if (tileArchive != null) {
                tileArchive.delete();
            }
        }
        return true;
    }

    @Override
    public void pauseResumeAtlasCreation() {
        if (this.pauseResumeHandler.isPaused()) {
            log.debug("Atlas creation resumed");
            this.pauseResumeHandler.resume();
        } else {
            log.debug("Atlas creation paused");
            this.pauseResumeHandler.pause();
        }
    }

    @Override
    public boolean isPaused() {
        return this.pauseResumeHandler.isPaused();
    }

    public PauseResumeHandler getPauseResumeHandler() {
        return this.pauseResumeHandler;
    }

    @Override
    public void abortAtlasCreation() {
        try {
            DownloadJobProducerThread djp_ = this.djp;
            if (djp_ != null) {
                djp_.cancel();
            }
            if (this.downloadJobDispatcher != null) {
                this.downloadJobDispatcher.terminateAllWorkerThreads();
            }
            this.pauseResumeHandler.resume();
            this.interrupt();
        }
        catch (Exception e) {
            log.error("Exception thrown in stopDownload()" + e.getMessage());
        }
    }

    public int getActiveDownloads() {
        return this.activeDownloads;
    }

    @Override
    public synchronized void jobStarted() {
        ++this.activeDownloads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobFinishedSuccessfully(int bytesDownloaded) {
        AtlasThread atlasThread = this;
        synchronized (atlasThread) {
            this.ap.incMapDownloadProgress();
            --this.activeDownloads;
            ++this.jobsCompleted;
        }
        this.ap.updateGUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobFinishedWithError(boolean retry) {
        AtlasThread atlasThread = this;
        synchronized (atlasThread) {
            --this.activeDownloads;
            if (retry) {
                ++this.jobsRetryError;
            } else {
                ++this.jobsPermanentError;
                this.ap.incMapDownloadProgress();
            }
        }
        if (!this.ap.ignoreDownloadErrors()) {
            Toolkit.getDefaultToolkit().beep();
        }
        this.ap.setErrorCounter(this.jobsRetryError, this.jobsPermanentError);
        this.ap.updateGUI();
    }

    @Override
    public int getMaxDownloadRetries() {
        return this.maxDownloadRetries;
    }

    public AtlasProgress getAtlasProgress() {
        return this.ap;
    }

    public File getCustomAtlasDir() {
        return this.customAtlasDir;
    }

    public void setCustomAtlasDir(File customAtlasDir) {
        this.customAtlasDir = customAtlasDir;
    }

    public void setQuitMobacAfterAtlasCreation(boolean quitMobacAfterAtlasCreation) {
        this.quitMobacAfterAtlasCreation = quitMobacAfterAtlasCreation;
    }

    @Override
    public boolean isMapPreviewThread() {
        return false;
    }
}

