/*
 * Decompiled with CFR 0.152.
 */
package mobac.program;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import mobac.program.Logging;
import mobac.utilities.Utilities;

public class DirectoryManager {
    public static final File currentDir;
    public static final File programDir;
    public static final File userHomeDir;
    public static final File tempDir;
    public static final File userAppDataDir;
    public static final File userSettingsDir;
    public static final File mapSourcesDir;
    public static final File toolsDir;
    public static final File atlasProfilesDir;
    public static final File tileStoreDir;
    private static Properties dirConfig;

    private static File applyDirConfig(String propertyName, File defaultDir) {
        if (dirConfig == null) {
            return defaultDir;
        }
        try {
            String dirCfg = dirConfig.getProperty(propertyName);
            if (dirCfg == null) {
                return defaultDir;
            }
            return DirectoryManager.expandCommandLine(dirCfg);
        }
        catch (Exception e) {
            Logging.LOG.error("Error reading directory configuration: " + e.getMessage(), e);
            JOptionPane.showMessageDialog(null, "<html><p>Failed to load directory.ini - entry \"" + propertyName + "\":<p><p>" + e.getMessage() + "</p></html>", "Faile do load directory.ini", 0);
            return defaultDir;
        }
    }

    private static File expandCommandLine(String cmd) {
        Pattern vars = Pattern.compile("[$]\\{(\\S+)\\}");
        Matcher m = vars.matcher(cmd.trim());
        StringBuffer sb = new StringBuffer(cmd.length());
        int lastMatchEnd = 0;
        while (m.find()) {
            sb.append(cmd.substring(lastMatchEnd, m.start()));
            String envVar = m.group(1);
            String envVal = System.getenv(envVar);
            if (envVal == null) {
                File defPath = null;
                if ("mobac-prog".equalsIgnoreCase(envVar)) {
                    defPath = programDir;
                } else if ("home".equalsIgnoreCase(envVar)) {
                    defPath = userHomeDir;
                } else if ("XDG_CONFIG_HOME".equalsIgnoreCase(envVar)) {
                    defPath = new File(userHomeDir, ".config");
                } else if ("XDG_CACHE_HOME".equalsIgnoreCase(envVar)) {
                    defPath = new File(userHomeDir, ".cache");
                } else if ("XDG_DATA_HOME".equalsIgnoreCase(envVar)) {
                    File localDataDir = new File(userHomeDir, ".local");
                    defPath = new File(localDataDir, "share");
                }
                if (defPath != null) {
                    envVal = defPath.getAbsolutePath();
                }
            }
            if (envVal == null) {
                sb.append(cmd.substring(m.start(), m.end()));
            } else {
                sb.append(envVal);
            }
            lastMatchEnd = m.end();
        }
        sb.append(cmd.substring(lastMatchEnd));
        return new File(sb.toString());
    }

    public static void initialize() {
        if (currentDir == null || userAppDataDir == null || tempDir == null || programDir == null) {
            throw new RuntimeException("DirectoryManager failed");
        }
    }

    private static void loadDirectoriesIni() {
        File dirIniFile = new File(programDir, "directories.ini");
        if (!dirIniFile.isFile()) {
            return;
        }
        dirConfig = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(dirIniFile);
            dirConfig.load(in);
        }
        catch (IOException e) {
            try {
                System.err.println("Failed to load " + dirIniFile.getName());
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Utilities.closeStream(in);
                throw throwable;
            }
            Utilities.closeStream(in);
        }
        Utilities.closeStream(in);
    }

    private static File getProgramDir() {
        File f = null;
        try {
            f = Utilities.getClassLocation(DirectoryManager.class);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return currentDir;
        }
        if ("bin".equals(f.getName())) {
            return f.getParentFile();
        }
        return f;
    }

    private static File getUserAppDataDir() {
        File appDataDir;
        String appData = System.getenv("APPDATA");
        if (appData != null && (appDataDir = new File(appData)).isDirectory()) {
            File mobacDataDir = new File(appData, "Mobile Atlas Creator");
            if (mobacDataDir.isDirectory() || mobacDataDir.mkdir()) {
                return mobacDataDir;
            }
            throw new RuntimeException("Unable to create directory \"" + mobacDataDir.getAbsolutePath() + "\"");
        }
        File userDir = new File(System.getProperty("user.home"));
        File mobacUserDir = new File(userDir, ".mobac");
        if (!mobacUserDir.exists() && !mobacUserDir.mkdir()) {
            throw new RuntimeException("Unable to create directory \"" + mobacUserDir.getAbsolutePath() + "\"");
        }
        return mobacUserDir;
    }

    static {
        dirConfig = null;
        currentDir = new File(System.getProperty("user.dir"));
        userHomeDir = new File(System.getProperty("user.home"));
        programDir = DirectoryManager.getProgramDir();
        DirectoryManager.loadDirectoriesIni();
        userAppDataDir = DirectoryManager.getUserAppDataDir();
        tempDir = DirectoryManager.applyDirConfig("mobac.tmpdir", new File(System.getProperty("java.io.tmpdir")));
        mapSourcesDir = DirectoryManager.applyDirConfig("mobac.mapsourcesdir", new File(programDir, "mapsources"));
        toolsDir = DirectoryManager.applyDirConfig("mobac.toolsdir", new File(programDir, "tools"));
        userSettingsDir = DirectoryManager.applyDirConfig("mobac.usersettingsdir", programDir);
        atlasProfilesDir = DirectoryManager.applyDirConfig("mobac.atlasprofilesdir", currentDir);
        tileStoreDir = DirectoryManager.applyDirConfig("mobac.tilestoredir", new File(programDir, "tilestore"));
    }
}

