/*
 * Decompiled with CFR 0.152.
 */
package mobac.program;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.swing.JOptionPane;
import mobac.mapsources.MapSourcesManager;
import mobac.program.DirectoryManager;
import mobac.program.interfaces.MapSource;
import mobac.program.model.Atlas;
import mobac.program.model.EastNorthCoordinate;
import mobac.program.model.Layer;
import mobac.program.model.Profile;
import mobac.program.model.Settings;
import mobac.utilities.GUIExceptionHandler;
import mobac.utilities.I18nUtils;
import mobac.utilities.Utilities;
import mobac.utilities.file.FileExtFilter;
import mobac.utilities.file.NamePatternFileFilter;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class EnvironmentSetup {
    private static boolean FIRST_START = false;
    public static Logger log = Logger.getLogger(EnvironmentSetup.class);

    public static void checkMemory() {
        Runtime r = Runtime.getRuntime();
        long maxHeap = r.maxMemory();
        String heapMBFormatted = String.format(Locale.ENGLISH, "%3.2f MiB", (double)maxHeap / 1048576.0);
        log.info("Total available memory to MOBAC: " + heapMBFormatted);
        if (maxHeap < 200000000L) {
            String msg = String.format(I18nUtils.localizedStringForKey("msg_environment_lack_memory", new Object[0]), heapMBFormatted);
            JOptionPane.showMessageDialog(null, msg, I18nUtils.localizedStringForKey("msg_environment_lack_memory_title", new Object[0]), 2);
        }
    }

    public static void upgrade() {
        File[] files;
        NamePatternFileFilter ff = new NamePatternFileFilter("tac-profile-.*.xml");
        File profilesDir = DirectoryManager.currentDir;
        for (File f : files = profilesDir.listFiles(ff)) {
            File dest = new File(profilesDir, f.getName().replaceFirst("tac-", "mobac-"));
            f.renameTo(dest);
        }
    }

    public static void copyMapPacks() {
        File progMapSourcesDir;
        File userMapSourcesDir = Settings.getInstance().getMapSourcesDirectory();
        if (userMapSourcesDir.equals(progMapSourcesDir = new File(DirectoryManager.programDir, "mapsources"))) {
            return;
        }
        if (userMapSourcesDir.isDirectory()) {
            return;
        }
        try {
            Utilities.mkDirs(userMapSourcesDir);
            FileUtils.copyDirectory(progMapSourcesDir, userMapSourcesDir, new FileExtFilter(".jar"));
        }
        catch (IOException e) {
            log.error(e);
            JOptionPane.showMessageDialog(null, I18nUtils.localizedStringForKey("msg_environment_error_init_mapsrc_dir", new Object[0]) + e.getMessage(), I18nUtils.localizedStringForKey("Error", new Object[0]), 0);
            System.exit(1);
        }
    }

    public static void checkFileSetup() {
        EnvironmentSetup.checkDirectory(DirectoryManager.userSettingsDir, "user settings", true);
        EnvironmentSetup.checkDirectory(DirectoryManager.atlasProfilesDir, "atlas profile", true);
        EnvironmentSetup.checkDirectory(DirectoryManager.tileStoreDir, "tile store", true);
        EnvironmentSetup.checkDirectory(DirectoryManager.tempDir, "temporary atlas download", true);
        if (!Settings.FILE.exists()) {
            try {
                FIRST_START = true;
                Settings.save();
            }
            catch (Exception e) {
                log.error("Error while creating settings.xml: " + e.getMessage(), e);
                Object[] options = new String[]{"Exit", "Show error report"};
                int a = JOptionPane.showOptionDialog(null, "Could not create file settings.xml - program will exit.", "Error", 0, 0, null, options, options[0]);
                if (a == 1) {
                    GUIExceptionHandler.showExceptionDialog(e);
                }
                System.exit(1);
            }
        }
    }

    protected static void checkDirectory(File dir2, String dirName, boolean checkIsWriteable) {
        try {
            Utilities.mkDirs(dir2);
        }
        catch (IOException e) {
            GUIExceptionHandler.processFatalExceptionSimpleDialog(String.format(I18nUtils.localizedStringForKey("msg_environment_error_create_dir", new Object[0]), dirName, dir2.getAbsolutePath()), e);
        }
        if (!checkIsWriteable) {
            return;
        }
        try {
            File testFile = File.createTempFile("MOBAC", "", dir2);
            testFile.createNewFile();
            testFile.deleteOnExit();
            testFile.delete();
        }
        catch (IOException e) {
            GUIExceptionHandler.processFatalExceptionSimpleDialog(String.format(I18nUtils.localizedStringForKey("msg_environment_error_write_file", new Object[0]), dirName, dir2.getAbsolutePath()), e);
        }
    }

    public static void createDefaultAtlases() {
        if (!FIRST_START) {
            return;
        }
        Profile p = new Profile("Google Maps New York");
        Atlas atlas = Atlas.newInstance();
        try {
            EastNorthCoordinate max = new EastNorthCoordinate(40.97264, -74.142609);
            EastNorthCoordinate min = new EastNorthCoordinate(40.541982, -73.699036);
            Layer layer = new Layer(atlas, "GM New York");
            MapSource ms = MapSourcesManager.getInstance().getSourceByName("Mapnik");
            if (ms == null) {
                return;
            }
            layer.addMapsAutocut("GM New York 16", ms, max, min, 16, null, 32000);
            layer.addMapsAutocut("GM New York 14", ms, max, min, 14, null, 32000);
            atlas.addLayer(layer);
            p.save(atlas);
        }
        catch (Exception e) {
            log.error("Creation for example profiles failed", e);
            GUIExceptionHandler.showExceptionDialog(e);
        }
    }
}

